/*
 * Decompiled with CFR 0.152.
 */
package com.sas.plugins;

import com.sas.plugins.PluginLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class PluginResourceBundle {
    private ResourceBundle m_bundle = null;
    protected String m_strResourceFileName;
    protected static Hashtable m_bundleCache;
    protected static Hashtable m_ImageCache;
    protected ClassLoader m_classLoader;

    public PluginResourceBundle(InputStream is) throws IOException {
        this.m_classLoader = PluginLoader.getClassLoader();
        this.m_bundle = new PropertyResourceBundle(is);
    }

    public PluginResourceBundle(InputStream is, ClassLoader classLoader) throws IOException {
        this.m_classLoader = classLoader;
        this.m_bundle = new PropertyResourceBundle(is);
    }

    public PluginResourceBundle(Class source) {
        this.m_classLoader = source.getClassLoader();
        String strClassName = source.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        this.m_bundle = this.getBundle(strPackageName + ".PropertyBundle");
    }

    protected ResourceBundle getBundle(String strBundlePath) {
        ResourceBundle returnValue = this.getCachedBundle(strBundlePath);
        if (returnValue != null) {
            return returnValue;
        }
        Locale locale = Locale.getDefault();
        try {
            returnValue = ResourceBundle.getBundle(strBundlePath, locale, this.m_classLoader);
        }
        catch (Throwable e) {
            try {
                returnValue = PropertyResourceBundle.getBundle(strBundlePath, locale, this.m_classLoader);
            }
            catch (Throwable e2) {
                return null;
            }
        }
        this.cacheBundle(strBundlePath, returnValue);
        this.m_strResourceFileName = strBundlePath;
        return returnValue;
    }

    protected ResourceBundle getCachedBundle(String key) {
        if (m_bundleCache == null) {
            m_bundleCache = new Hashtable();
        }
        return (ResourceBundle)m_bundleCache.get(key);
    }

    protected ImageIcon getImageImpl(String sFileName) {
        ImageIcon image = null;
        String sImagePath = this.getRawString("ImageLocation.notrans") + sFileName;
        if (m_ImageCache == null) {
            m_ImageCache = new Hashtable();
        } else {
            image = (ImageIcon)m_ImageCache.get(sImagePath);
            if (image != null) {
                return image;
            }
        }
        try {
            URL url = this.m_classLoader.getResource(sImagePath);
            image = new ImageIcon(url);
        }
        catch (Exception e) {
            System.err.println("Exception loading image: " + sImagePath);
            e.printStackTrace();
            String sDefaultPath = "com/sas/plugins/res/DefaultImage.gif";
            try {
                URL urlDefault = this.m_classLoader.getResource(sDefaultPath);
                image = new ImageIcon(urlDefault);
            }
            catch (Exception e2) {
                System.err.println("Exception loading image: " + sDefaultPath);
                e2.printStackTrace();
            }
        }
        if (image != null) {
            m_ImageCache.put(sImagePath, image);
        }
        return image;
    }

    protected void cacheBundle(String key, ResourceBundle bundle) {
        m_bundleCache.put(key, bundle);
    }

    public ImageIcon getImageIcon(String sFileName) {
        if (sFileName == null) {
            return null;
        }
        return this.getImageImpl(this.getRawString(sFileName));
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int notFoundReturnValue) {
        try {
            String strValue = this.getString(key);
            return new Integer(strValue);
        }
        catch (Throwable throwable) {
            return notFoundReturnValue;
        }
    }

    public String messageString(String key) {
        String pattern = this.getString(key);
        return pattern;
    }

    public String messageString(String key, Object parm1) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5, Object parm6) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString(), parm6.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String getRawString(String key) {
        String retValue = null;
        try {
            retValue = this.getString(key);
            retValue = retValue.trim();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retValue;
    }

    public String getString(String key) {
        String retValue;
        block5: {
            retValue = "";
            if (this.m_bundle == null) {
                try {
                    throw new Throwable();
                }
                catch (Throwable throwable) {
                    break block5;
                }
            }
            try {
                retValue = this.m_bundle.getString(key);
            }
            catch (Throwable t) {
                retValue = "Missing resource " + key;
                System.err.println(retValue + ". Have you copied your resources?");
                System.err.println("Missing resource is called from the following:");
                t.printStackTrace();
            }
        }
        return retValue;
    }
}

