/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

@SASScope
public class URIUtil {
    private static final int PORT_INVALID = -1;
    private static final int PORT_DAV = 80;
    private static final int PORT_HTTP = 80;
    private static final int PORT_HTTPS = 443;
    private static final int PORT_LDAP = 389;
    private static final int PORT_LDAPS = 636;
    private static final int PORT_OMI = 8561;

    public static String url1StartsWithUrl2(String url1, String url2) {
        String relpath = null;
        String scheme1 = null;
        String scheme2 = null;
        String host1 = null;
        String host2 = null;
        int port1 = -1;
        int port2 = -1;
        String path1 = null;
        String path2 = null;
        URI _uri1 = null;
        URI _uri2 = null;
        try {
            _uri1 = new URI(url1);
            _uri2 = new URI(url2);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return relpath;
        }
        scheme1 = _uri1.getScheme();
        if (scheme1 == null) {
            scheme1 = "";
        }
        scheme2 = _uri2.getScheme();
        host1 = _uri1.getHost();
        host2 = _uri2.getHost();
        port1 = _uri1.getPort();
        if (port1 == -1) {
            port1 = URIUtil.getDefaultPort(scheme1);
        }
        if ((port2 = _uri2.getPort()) == -1) {
            port2 = URIUtil.getDefaultPort(scheme2);
        }
        path1 = _uri1.getPath();
        path2 = _uri2.getPath();
        if (URIUtil.equalIgnoringCase(scheme1, scheme2) && URIUtil.hostsEqual(host1, host2) && port1 == port2) {
            if ("omi".equalsIgnoreCase(scheme1)) {
                return path1;
            }
            if ("ipod".equalsIgnoreCase(scheme1)) {
                return path1;
            }
            if ("ldap".equalsIgnoreCase(scheme1)) {
                return path1;
            }
            if (path1.equals(path2)) {
                return "";
            }
            if (!path1.startsWith(path2)) {
                return null;
            }
            StringBuffer path = new StringBuffer(path1.length() + 10);
            StringTokenizer st1 = new StringTokenizer(path1, "/");
            StringTokenizer st2 = new StringTokenizer(path2, "/");
            while (st2.hasMoreTokens()) {
                String seg2;
                String seg1 = st1.nextToken();
                if (seg1.equals(seg2 = st2.nextToken())) {
                    path.append('/' + seg1);
                    continue;
                }
                return null;
            }
            relpath = path1.substring(path.length());
        }
        return relpath;
    }

    private static int getDefaultPort(String scheme) {
        int port = -1;
        if (scheme == null) {
            port = -1;
        } else if (scheme.equalsIgnoreCase("http")) {
            port = 80;
        } else if (scheme.equalsIgnoreCase("dav")) {
            port = 80;
        } else if (scheme.equalsIgnoreCase("https")) {
            port = 443;
        } else if (scheme.equalsIgnoreCase("ldap")) {
            port = 389;
        } else if (scheme.equalsIgnoreCase("ldaps")) {
            port = 636;
        } else if (scheme.equalsIgnoreCase("omi")) {
            port = 8561;
        } else if (scheme.equalsIgnoreCase("ipod")) {
            port = 8561;
        } else if (scheme.equalsIgnoreCase("sas-oma")) {
            port = 8561;
        }
        return port;
    }

    private static boolean equalIgnoringCase(String s, String t) {
        boolean isEqual = false;
        if (s == t) {
            isEqual = true;
        } else if (s != null && t != null) {
            isEqual = s.equalsIgnoreCase(t);
        }
        return isEqual;
    }

    public static String addSegment(String path, String segment) {
        String tmpSegment;
        StringBuffer tmp = new StringBuffer(path.trim());
        if (tmp.length() == 0 || tmp.charAt(tmp.length() - 1) != '/') {
            tmp.append("/");
        }
        if ((tmpSegment = segment.trim()).length() > 0 && tmpSegment.charAt(0) == '/') {
            if (tmpSegment.length() > 1) {
                tmp.append(tmpSegment.substring(1));
            }
        } else {
            tmp.append(tmpSegment);
        }
        return tmp.toString();
    }

    private static boolean hostsEqual(String host1, String host2) {
        if (host1 == host2) {
            return true;
        }
        if (host1 == null && host2 == null) {
            return true;
        }
        if (host1 == null) {
            return false;
        }
        if (host2 == null) {
            return false;
        }
        boolean host_match = false;
        try {
            InetAddress myAddress = InetAddress.getByName(host1);
            InetAddress hisAddress = InetAddress.getByName(host2);
            host_match = myAddress.equals(hisAddress);
        }
        catch (UnknownHostException uhex) {
            host_match = host1.equalsIgnoreCase(host2);
        }
        return host_match;
    }

    public static String stripLeadingSlashes(String buffer) {
        int len = buffer.length();
        for (int i = 0; i < len; ++i) {
            if (buffer.charAt(i) == '/') continue;
            return buffer.substring(i);
        }
        return "";
    }

    public static String stripTrailingSlashes(String path) {
        StringBuffer buffer = new StringBuffer(path);
        int len = buffer.length();
        for (int i = len - 1; i >= 0 && buffer.charAt(i) == '/'; --i) {
            buffer.setLength(i);
        }
        return buffer.toString();
    }
}

