/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.DocumentServiceConfigAdapterInterface;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceException;
import com.sas.services.user.ProfileDomain;
import com.sas.services.user.SimpleUserIdentity;
import com.sas.services.user.UserServiceInitObject;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.UsageVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class UserServiceInitializer
implements DocumentServiceConfigAdapterInterface {
    private static final String XML_DOCUMENT = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><!DOCTYPE UserService><UserService xmlns=\"urn:sas:UserService\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:sas:UserService com_sas_services_user_UserService_9_2_0_0.xsd\" />";
    public static final String XML_ELEMENT_ATTRIBUTE_UID = "uid";
    public static final String XML_ELEMENT_USERSERVICE = "UserService";
    public static final String XML_ELEMENT_USERSERVICE_ATTRIBUTE_PERSONBASE = "personbase";
    public static final String XML_ELEMENT_USERSERVICE_ATTRIBUTE_GROUPBASE = "groupbase";
    public static final String XML_ELEMENT_USERSERVICE_ATTRIBUTE_CREDENTIALBASE = "credentialbase";
    public static final String XML_ELEMENT_USERSERVICE_ATTRIBUTE_DOMAIN = "domain";
    public static final String XML_ELEMENT_USERCONTEXT = "UserContext";
    public static final String XML_ELEMENT_USERCONTEXT_ATTRIBUTE_ID = "userid";
    public static final String XML_ELEMENT_USERCONTEXT_ATTRIBUTE_PASSWORD = "password";
    public static final String XML_ELEMENT_USERCONTEXT_ATTRIBUTE_DOMAIN = "domain";
    public static final String XML_ELEMENT_PROFILE = "Profile";
    public static final String XML_ELEMENT_PROFILE_ATTRIBUTE_APPLICATION = "Application";
    public static final String XML_ELEMENT_PROFILE_ATTRIBUTE_URL = "url";
    public static final String XML_ELEMENT_PROFILE_ATTRIBUTE_CLASS = "class";
    public static final String XML_ELEMENT_PROFILE_ATTRIBUTE_TYPE = "type";
    public static final String XML_ELEMENT_PROFILE_ATTRIBUTE_FILTER = "filter";
    public static final String XML_ELEMENT_PROFILE_ATTRIBUTE_BASE = "base";

    UserServiceInitializer() {
    }

    @Override
    public AbstractServiceComponentConfig createConfigFromDocument(Document document) throws ServiceException {
        return UserServiceInitializer.parse(document);
    }

    public static final UserServiceInitObject parse(Document document) throws ServiceConfigurationException {
        UserServiceInitObject.validate(document);
        UserServiceInitObject userServiceInitObject = new UserServiceInitObject();
        UserServiceInitializer.parseContext(document, userServiceInitObject);
        return userServiceInitObject;
    }

    private static final void parseContext(Node node, UserServiceInitObject userServiceInitObject) throws ServiceConfigurationException {
        if (node != null && userServiceInitObject != null) {
            Element element = null;
            switch (node.getNodeType()) {
                case 9: 
                case 11: {
                    NodeList nodeList = node.getChildNodes();
                    int nodeListLength = nodeList.getLength();
                    for (int i = 0; i < nodeListLength; ++i) {
                        UserServiceInitializer.parseContext(nodeList.item(i), userServiceInitObject);
                    }
                    break;
                }
                case 1: {
                    String elementName = node.getNodeName();
                    if (XML_ELEMENT_USERSERVICE.equalsIgnoreCase(elementName)) {
                        UserServiceInitializer.parseUserService((Element)node, userServiceInitObject);
                    } else if ("ConsumerUsage".equals(elementName)) {
                        userServiceInitObject.parseConsumerUsage((Element)node);
                    } else if (XML_ELEMENT_USERCONTEXT.equalsIgnoreCase(elementName)) {
                        element = (Element)node;
                        String uid = element.getAttribute(XML_ELEMENT_ATTRIBUTE_UID);
                        String userID = element.getAttribute(XML_ELEMENT_USERCONTEXT_ATTRIBUTE_ID);
                        String password = null;
                        try {
                            password = SasPasswordString.decode((String)element.getAttribute(XML_ELEMENT_USERCONTEXT_ATTRIBUTE_PASSWORD));
                        }
                        catch (SasPasswordEncodingException spee) {
                            password = element.getAttribute(XML_ELEMENT_USERCONTEXT_ATTRIBUTE_PASSWORD);
                        }
                        String domain = element.getAttribute("domain");
                        String userServiceDomain = userServiceInitObject.getDomain();
                        if (domain == null && userServiceDomain != null) {
                            domain = userServiceDomain;
                        }
                        if (userID == null || password == null) break;
                        userServiceInitObject.addUser(new SimpleUserIdentity(uid, userID, password, domain));
                    } else if (XML_ELEMENT_PROFILE.equalsIgnoreCase(elementName)) {
                        UserServiceInitializer.parseProfile((Element)node, userServiceInitObject);
                    }
                    NodeList nodeList = node.getChildNodes();
                    int nodeListLength = nodeList.getLength();
                    for (int i = 0; i < nodeListLength; ++i) {
                        UserServiceInitializer.parseContext(nodeList.item(i), userServiceInitObject);
                    }
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    private static void parseUserService(Element element, UserServiceInitObject serviceConfig) {
        try {
            String version = element.getAttribute("version");
            if (version.length() > 0) {
                serviceConfig.setUsageVersion(UsageVersion.decode((double)Double.parseDouble(version)));
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        serviceConfig.setPersonBase(element.getAttribute(XML_ELEMENT_USERSERVICE_ATTRIBUTE_PERSONBASE));
        serviceConfig.setGroupBase(element.getAttribute(XML_ELEMENT_USERSERVICE_ATTRIBUTE_GROUPBASE));
        serviceConfig.setCredentialBase(element.getAttribute(XML_ELEMENT_USERSERVICE_ATTRIBUTE_CREDENTIALBASE));
        serviceConfig.setDomain(element.getAttribute("domain"));
    }

    private static void parseProfile(Element element, UserServiceInitObject userServiceInitObject) {
        String application = element.getAttribute(XML_ELEMENT_PROFILE_ATTRIBUTE_APPLICATION);
        if (application != null) {
            ProfileDomain pd = new ProfileDomain(element.getAttribute(XML_ELEMENT_ATTRIBUTE_UID), element.getAttribute(XML_ELEMENT_PROFILE_ATTRIBUTE_URL), element.getAttribute(XML_ELEMENT_PROFILE_ATTRIBUTE_TYPE), element.getAttribute(XML_ELEMENT_PROFILE_ATTRIBUTE_FILTER), element.getAttribute(XML_ELEMENT_PROFILE_ATTRIBUTE_CLASS));
            pd.setBase(element.getAttribute(XML_ELEMENT_PROFILE_ATTRIBUTE_BASE));
            userServiceInitObject.addProfile(application, pd);
        }
    }

    static final String getXMLDocument() {
        return XML_DOCUMENT;
    }
}

