/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.CredentialResolver;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryGroup;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.security.ApplicationAuthorization;
import com.sas.services.security.LoginCallbackHandler;
import com.sas.services.security.RemoteCallbackHandler;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.user.UserIdentityListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public interface UserContextInterface
extends CredentialResolver {
    public static final String SHAREDRESOURCEKEY_ENVIRONMENT = "ENVIRONMENT";
    public static final String SHAREDRESOURCEKEY_SERVICEID = "USERSERVICEID";
    public static final String IDPROPAGATION_SSPI = "sspi";
    public static final String IDPROPAGATION_TRUSTED_PEER = "trustedpeer";
    public static final String INTERNAL_AUTH_DOMAIN = "InternalAuth";

    public void setSessionContext(SessionContextInterface var1) throws RemoteException;

    public SessionContextInterface getSessionContext() throws RemoteException;

    public String getPersonFQID() throws RemoteException;

    public String getName() throws RemoteException;

    public void setName(String var1) throws RemoteException;

    public String getDescription() throws RemoteException;

    public String getKey() throws RemoteException;

    public void setKey(String var1) throws RemoteException;

    public String getClientSource() throws RemoteException;

    public void setClientSource(String var1) throws RemoteException;

    public String getAppSource() throws RemoteException;

    public void setAppSource(String var1) throws RemoteException;

    public String getIDPropagation() throws ServiceException, RemoteException;

    public void addIdentity(UserIdentityInterface var1) throws RemoteException;

    public void removeIdentity(UserIdentityInterface var1) throws RemoteException;

    public List getIdentities() throws RemoteException;

    public UserIdentityInterface getIdentityByDomain(String var1) throws RemoteException;

    public UserIdentityInterface getIdentityByDomain(String var1, boolean var2) throws RemoteException, ServiceException;

    public UserIdentityInterface getIdentityByDomain(String var1, boolean var2, String var3) throws RemoteException, ServiceException;

    public List getIdentitiesByDomain(String var1, boolean var2, String var3) throws RemoteException, ServiceException;

    public void addRepositoryGroup(RepositoryGroup var1) throws ServiceException, RemoteException;

    public void removeRepositoryGroup(RepositoryGroup var1) throws ServiceException, RemoteException;

    public RepositoryGroup getRepositoryGroup(String var1) throws ServiceException, RemoteException;

    public ProfileInterface getProfile() throws RemoteException;

    public void addRepository(Object var1) throws RemoteException;

    public void removeRepository(Object var1) throws RemoteException;

    public RepositoryInterface getRepository(String var1) throws ServiceException, RemoteException;

    public RepositoryInterface getAuthRepository() throws ServiceException, RemoteException;

    public String getAuthRepositoryName() throws ServiceException, RemoteException;

    public ServerInterface getAuthServer() throws ServiceException, RemoteException;

    public String getAuthServerName() throws ServiceException, RemoteException;

    public List getRepositories() throws RemoteException;

    public List getServers() throws RemoteException;

    public void addServer(ServerInterface var1) throws ServiceException, RemoteException;

    public void removeServer(ServerInterface var1) throws ServiceException, RemoteException;

    public ServerInterface getServer(String var1) throws ServiceException, RemoteException;

    public Set getPrincipals() throws RemoteException;

    public Set getPublicCredentials() throws RemoteException;

    public Set getPrivateCredentials() throws RemoteException;

    public LoginCallbackHandler getLoginCallback() throws RemoteException;

    public boolean authenticate() throws RemoteException;

    public boolean authenticate(UserIdentityInterface var1, Map var2) throws RemoteException;

    public void destroy() throws RemoteException;

    public void addException(Exception var1) throws RemoteException;

    public void clearExceptions() throws RemoteException;

    public Exception[] getExceptions() throws RemoteException;

    public void setChallengeCallbackHandler(RemoteCallbackHandler var1) throws RemoteException;

    public RemoteCallbackHandler getChallengeCallbackHandler() throws RemoteException;

    public IdentityInterface getPerson() throws RemoteException;

    public void setPerson(IdentityInterface var1) throws RemoteException, IllegalStateException;

    public String getUniqueId() throws RemoteException;

    public boolean isDestroyed() throws RemoteException;

    public long getLoginTime() throws RemoteException;

    public Object getSharedResource(String var1) throws RemoteException;

    public Object putSharedResource(String var1, Object var2) throws RemoteException;

    public byte[] toByteArray() throws RemoteException;

    public void addUserIdentityListener(UserIdentityListener var1) throws RemoteException;

    public boolean isInRole(String var1) throws ServiceException, RemoteException;

    public boolean isInAnyRole(List var1) throws ServiceException, RemoteException;

    public List getRoles() throws ServiceException, RemoteException;

    public boolean hasCapability(String var1, String var2) throws ServiceException, RemoteException;

    public List getActions(String var1) throws ServiceException, RemoteException;

    public List getActions(String var1, boolean var2) throws ServiceException, RemoteException;

    public Map<String, ApplicationAuthorization> getGrantedApplicationActions(String ... var1) throws ServiceException, RemoteException;

    public boolean isInGroup(String var1) throws ServiceException, RemoteException;

    public boolean isInAnyGroup(List var1) throws ServiceException, RemoteException;

    public List getGroups() throws ServiceException, RemoteException;

    public void refreshRepositoryData() throws ServiceException, RemoteException;

    public String getResolvedUserId() throws ServiceException, RemoteException;

    public boolean isInternalUser() throws ServiceException, RemoteException;

    public Locale getLocale() throws ServiceException, RemoteException;

    public void setLocale(Locale var1) throws ServiceException, RemoteException;

    public void enableLocalAdminMode(String var1) throws ServiceException, RemoteException;
}

