/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.user.SubjectMatter;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class SubjectAuthenticator {
    private SubjectAuthenticator() {
    }

    public static UserContextInterface newAuthenticatedUser(UserServiceInterface userService, Subject subject) throws ServiceException, UserInitializationException, RemoteException {
        return SubjectAuthenticator.newAuthenticatedUser(userService, subject, null);
    }

    public static UserContextInterface newAuthenticatedUser(UserServiceInterface userService, Subject subject, Map advancedOptions) throws ServiceException, UserInitializationException, RemoteException {
        SubjectMatter newSubject = new SubjectMatter();
        try {
            Object nextCredential2;
            Set<Principal> principals = subject.getPrincipals();
            Iterator<Object> it = principals.iterator();
            while (it.hasNext()) {
                try {
                    Principal nextPrincipal = it.next();
                    if (!(nextPrincipal instanceof Serializable)) continue;
                    newSubject.addPrincipal(nextPrincipal);
                }
                catch (ClassCastException nextPrincipal) {}
            }
            it = subject.getPrivateCredentials().iterator();
            while (it.hasNext()) {
                try {
                    nextCredential2 = it.next();
                    if (!(nextCredential2 instanceof Serializable)) continue;
                    newSubject.addPrivateCredential(nextCredential2);
                }
                catch (ClassCastException nextCredential2) {}
            }
            it = subject.getPublicCredentials().iterator();
            while (it.hasNext()) {
                try {
                    nextCredential2 = it.next();
                    if (!(nextCredential2 instanceof Serializable)) continue;
                    newSubject.addPublicCredential(nextCredential2);
                }
                catch (ClassCastException classCastException) {}
            }
        }
        catch (Exception ex) {
            if (ex instanceof ServiceException) {
                throw (ServiceException)((Object)ex);
            }
            ex.printStackTrace(System.out);
            return null;
        }
        return userService.newRemoteUser(newSubject, advancedOptions);
    }
}

