/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.session;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.session.SessionContextInterface;
import java.io.Serializable;
import java.util.EventObject;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class SessionContextStateChangedEvent
extends EventObject
implements Serializable {
    private SessionContextInterface _sessionContext;
    private String _name;
    private Object _object;
    private int _stateChange;
    private static final int INIT_TOSTRING_LENGTH = 256;
    public static final long serialVersionUID = -6865823509891834082L;
    public static final int OBJECT_REMOVED = 1;
    public static final int SESSION_CONTEXT_DESTROYED = 2;

    public SessionContextStateChangedEvent(SessionContextInterface sessionContext, String name, Object object, int stateChange) {
        super(sessionContext);
        this._sessionContext = sessionContext;
        this._name = name;
        this._object = object;
        this._stateChange = stateChange;
    }

    public String getName() {
        return this._name;
    }

    public SessionContextInterface getSessionContext() {
        return this._sessionContext;
    }

    public Object getObject() {
        return this._object;
    }

    @Override
    public Object getSource() {
        return this._sessionContext;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(256);
        String evt = this.getClass().getName();
        buf.append(evt);
        buf.append("[source=");
        String remoteSrc = this._sessionContext.toString();
        buf.append(remoteSrc);
        buf.append("]");
        buf.append("[stateChange=");
        buf.append(this._stateChange);
        buf.append("]");
        buf.append("[name=");
        buf.append(this._name);
        buf.append("]");
        return buf.toString();
    }

    public int getStateChange() {
        return this._stateChange;
    }
}

