/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security;

import com.sas.codepolicy.SASScope;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.security.PermissionInterface;

@SASScope
public class Permission
implements PermissionInterface {
    static final long serialVersionUID = 3022884053421429873L;
    private String _type;
    private String _action;
    private MetadataInterface _owner;

    public Permission(String type, String action, MetadataInterface owner) {
        if ("GRANT".equalsIgnoreCase(type)) {
            this._type = "GRANT";
        } else if ("DENY".equalsIgnoreCase(type)) {
            this._type = "DENY";
        } else if ("REMOVE".equalsIgnoreCase(type)) {
            this._type = "REMOVE";
        } else {
            throw new IllegalArgumentException();
        }
        this._action = action;
        this._owner = owner;
    }

    public void setAction(String action) {
        this._action = action;
    }

    @Override
    public String getAction() {
        return this._action;
    }

    public void setType(String type) {
        if (type.equalsIgnoreCase("grant")) {
            this._type = "GRANT";
        } else if (type.equalsIgnoreCase("deny")) {
            this._type = "DENY";
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getType() {
        return this._type;
    }

    public void setOwningObject(MetadataInterface mi) {
        this._owner = mi;
    }

    @Override
    public MetadataInterface getOwningObject() {
        return this._owner;
    }

    public boolean equals(Object obj) {
        try {
            Permission o = (Permission)obj;
            if (this._action.equals(o.getAction()) && this._type.equals(o.getType())) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        if (this._action != null) {
            result = 37 * result + this._action.hashCode();
        }
        if (this._type != null) {
            result = 37 * result + this._type.hashCode();
        }
        return result;
    }
}

