/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security;

import com.sas.codepolicy.SASScope;
import com.sas.services.deployment.Environment;
import com.sas.util.Encryption;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;

@SASScope
public class ConnectionProfile {
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String USER = "userid";
    public static final String PASSWORD = "password";
    public static final String DOMAIN = "authenticationdomain";
    public static final String SINGLESIGNON = "SingleSignOn";
    public static final String SECURITYPACKAGE = "SecurityPackage";
    public static final String SERVICEPRINCIPALNAME = "ServicePrincipalName";
    public static final String SECURITYPACKAGELIST = "SecurityPackageList";
    public static final String ALLOWLOCALPASSWORDS = "AllowLocalPasswords";
    public static final String INTERNALACCOUNT = "InternalAccount";
    private Properties _properties = new Properties();

    private ConnectionProfile() {
    }

    public static ConnectionProfile newProfile(String host, String port) {
        ConnectionProfile profile = new ConnectionProfile();
        profile.setProperty(HOST, host);
        profile.setProperty(PORT, port);
        return profile;
    }

    public static ConnectionProfile newProfile(String host, String port, String user, String password) {
        ConnectionProfile profile = new ConnectionProfile();
        profile.setProperty(HOST, host);
        profile.setProperty(PORT, port);
        profile.setProperty(USER, user);
        profile.setProperty(PASSWORD, password);
        return profile;
    }

    public static ConnectionProfile newProfile(String host, String port, String user, String password, String domain) {
        ConnectionProfile profile = new ConnectionProfile();
        profile.setProperty(HOST, host);
        profile.setProperty(PORT, port);
        profile.setProperty(USER, user);
        profile.setProperty(PASSWORD, password);
        profile.setProperty(DOMAIN, domain);
        return profile;
    }

    public static ConnectionProfile loadProfile(String file) throws IOException {
        ConnectionProfile profile = new ConnectionProfile();
        String fullpath = ConnectionProfile.getFullPath(file);
        FileInputStream is = new FileInputStream(fullpath);
        profile._properties.load(is);
        ((InputStream)is).close();
        return profile;
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            this._properties.remove(key);
        } else {
            if (PASSWORD.equals(key)) {
                value = Encryption.encrypt((String)value);
            }
            this._properties.setProperty(key, value);
        }
    }

    public String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this._properties.getProperty(key, defaultValue);
    }

    public boolean getPropertyAsBoolean(String key, boolean defaultValue) {
        String value = this._properties.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public String getDomain() {
        String domain = this._properties.getProperty(DOMAIN);
        if (domain == null || domain.length() == 0) {
            boolean internalAccount = false;
            if (this._properties.containsKey(INTERNALACCOUNT)) {
                internalAccount = Boolean.parseBoolean(this._properties.getProperty(INTERNALACCOUNT));
            } else {
                String user = this._properties.getProperty(USER);
                if (user != null && user.toLowerCase().endsWith("@saspw")) {
                    internalAccount = true;
                }
            }
            domain = internalAccount ? "InternalAuth" : "DefaultAuth";
        }
        return domain;
    }

    public AppConfigurationEntry[] getAppConfigurationEntry() {
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put(HOST, this._properties.getProperty(HOST));
        optionsMap.put(PORT, this._properties.getProperty(PORT));
        optionsMap.put("holdopenconnection", "True");
        String user = this._properties.getProperty(USER);
        if (user == null || user.length() == 0) {
            String servicePrincipalName;
            optionsMap.put("idpropagation", "sspi");
            String securityPackage = this._properties.getProperty(SECURITYPACKAGE);
            if (securityPackage != null) {
                if (securityPackage.equals("Negotiate")) {
                    String securityPackageList = this._properties.getProperty(SECURITYPACKAGELIST);
                    if (securityPackageList != null && !securityPackageList.equals("Kerberos,NTLM")) {
                        optionsMap.put("sspisecuritypackagelist", securityPackageList);
                    }
                } else if (securityPackage != null && !securityPackage.equals("Negotiate")) {
                    optionsMap.put("sspisecuritypackagelist", securityPackage);
                }
            }
            if ((servicePrincipalName = this._properties.getProperty(SERVICEPRINCIPALNAME)) != null && servicePrincipalName.length() > 0) {
                optionsMap.put("sspispn", servicePrincipalName);
            }
        }
        optionsMap.put("domain", this.getDomain());
        AppConfigurationEntry[] appConfigurationEntries = new AppConfigurationEntry[]{new AppConfigurationEntry("com.sas.services.security.login.OMILoginModule", AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, optionsMap)};
        return appConfigurationEntries;
    }

    public Environment getEnvironment() {
        Environment env = new Environment();
        env.setAppConfigurationEntry(this.getAppConfigurationEntry());
        return env;
    }

    public void save(String file) throws IOException {
        String profileExtension = ".swa";
        if (!file.endsWith(".swa")) {
            file = file + ".swa";
        }
        String fullpath = ConnectionProfile.getFullPath(file);
        FileOutputStream os = new FileOutputStream(fullpath);
        this._properties.store(os, "SAS Authentication Profile");
        ((OutputStream)os).close();
    }

    public static String getAppDataPath() {
        String appDataPath = null;
        appDataPath = System.getProperty("sas.appdatapath");
        if (appDataPath == null) {
            try {
                appDataPath = System.getenv("APPDATA");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (appDataPath == null && (appDataPath = System.getProperty("user.home")) == null) {
                appDataPath = ".";
            }
        }
        return appDataPath;
    }

    private static String getFullPath(String file) {
        String profileExtension = ".swa";
        if (!file.endsWith(".swa")) {
            file = file + ".swa";
        }
        String fullpath = file;
        String separator = System.getProperty("file.separator");
        if (file.lastIndexOf(separator) < 0) {
            fullpath = separator.equals("/") ? ConnectionProfile.getAppDataPath() + "/.SASAppData/MetadataServerProfiles/" + file : ConnectionProfile.getAppDataPath() + separator + "SAS" + separator + "MetadataServerProfiles" + separator + file;
        }
        return fullpath;
    }
}

