/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.security.DomainCallback;
import com.sas.services.security.RemoteCallbackHandler;
import com.sas.services.security.RemoteDomainCallbackInterface;
import com.sas.services.security.RemoteNameCallbackInterface;
import com.sas.services.security.RemotePasswordCallbackInterface;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class Challenger
extends UnicastRemoteObject
implements RemoteCallbackHandler {
    private static final long serialVersionUID = 1L;
    CallbackHandler _localHandler;

    public Challenger(CallbackHandler localHandler) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, Challenger.class), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(Challenger.class), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(Challenger.class));
        this._localHandler = localHandler;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException, RemoteException {
        Callback callback;
        int i;
        Callback[] localCallbacks = new Callback[callbacks.length];
        for (i = 0; i < callbacks.length; ++i) {
            String prompt;
            callback = callbacks[i];
            if (callback instanceof RemoteNameCallbackInterface) {
                try {
                    prompt = ((RemoteNameCallbackInterface)callback).getPrompt();
                    String defaultName = ((RemoteNameCallbackInterface)callback).getDefaultName();
                    if (defaultName == null) {
                        localCallbacks[i] = new NameCallback(prompt);
                        continue;
                    }
                    localCallbacks[i] = new NameCallback(prompt, defaultName);
                    continue;
                }
                catch (Exception rex) {
                    rex.printStackTrace(System.err);
                    return;
                }
            }
            if (callback instanceof RemotePasswordCallbackInterface) {
                try {
                    prompt = ((RemotePasswordCallbackInterface)callback).getPrompt();
                    if (prompt == null || prompt.length() == 0) {
                        prompt = "password";
                    }
                    localCallbacks[i] = new PasswordCallback(prompt, false);
                    continue;
                }
                catch (RemoteException rex) {
                    rex.printStackTrace(System.err);
                    return;
                }
            }
            if (callback instanceof RemoteDomainCallbackInterface) {
                try {
                    String domain = ((RemoteDomainCallbackInterface)callback).getDomain();
                    localCallbacks[i] = new DomainCallback(domain);
                    continue;
                }
                catch (RemoteException rex) {
                    rex.printStackTrace(System.err);
                    return;
                }
            }
            localCallbacks[i] = callback;
        }
        this._localHandler.handle(localCallbacks);
        for (i = 0; i < localCallbacks.length; ++i) {
            callback = localCallbacks[i];
            if (callback instanceof NameCallback) {
                try {
                    String name = ((NameCallback)callback).getName();
                    ((RemoteNameCallbackInterface)callbacks[i]).setName(name);
                }
                catch (RemoteException rex) {
                    rex.printStackTrace(System.err);
                    return;
                }
            }
            if (!(callback instanceof PasswordCallback)) continue;
            try {
                ((RemotePasswordCallbackInterface)callbacks[i]).setPassword(((PasswordCallback)callback).getPassword());
                continue;
            }
            catch (RemoteException rex) {
                rex.printStackTrace(System.err);
                return;
            }
        }
    }
}

