/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.security.AuthenticatorInterface;
import com.sas.services.security.RB;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.text.Message;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class Authenticator
implements AuthenticatorInterface,
Serializable {
    private static final long serialVersionUID = -1098690082885012959L;

    @Override
    public boolean authenticate(UserContextInterface user, UserIdentityInterface ident, Map options) {
        try {
            Logger loggerIf = LogManager.getLogger((String)"com.sas.services.user.UserContext");
            if (options == null) {
                options = new HashMap();
            }
            if (loggerIf != null) {
                loggerIf.debug(Message.format((ResourceBundle)RB.getResources(), (String)"Authenticator.authenticatemsg.msg.fmt.txt", (Object)ident.getPrincipal()), (Object)"com.sas.services.security.Authenticator");
                loggerIf.debug(((Object)options).toString(), (Object)"com.sas.services.security.Authenticator");
            }
            try {
                return user.authenticate(ident, options);
            }
            catch (RemoteException rex) {
                if (loggerIf != null) {
                    loggerIf.warn(RB.getStringResource("Authenticator.remoteexcept.msg.txt"), (Object)"com.sas.services.security.Authenticator", (Object)rex);
                }
                return false;
            }
        }
        catch (Exception ex) {
            try {
                user.addException(ex);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return false;
        }
    }

    public boolean authenticate(UserContextInterface user) throws ServiceException, RemoteException {
        return user.authenticate();
    }
}

