/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security;

import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.ServiceProxy;
import com.sas.services.security.AuthenticationServiceInterface;
import com.sas.services.security.AuthenticatorInterface;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.List;

@SASScope
public class AuthenticationServiceProxy
extends ServiceProxy
implements AuthenticationServiceInterface {
    private static final long serialVersionUID = 3977294408792487737L;

    public AuthenticationServiceProxy(AuthenticationServiceInterface authenticationService) throws InitializationException {
        super(authenticationService);
    }

    @Override
    public List getDomains() throws RemoteException {
        List domainList = null;
        AuthenticationServiceInterface service = this.getAuthenticationService();
        try {
            domainList = service.getDomains();
        }
        catch (ConnectException e) {
            try {
                service = this.findAuthenticationService();
                domainList = service.getDomains();
            }
            catch (ServiceException ex) {
                throw new RemoteException(ex.getLocalizedMessage(), (Throwable)((Object)ex));
            }
        }
        return domainList;
    }

    @Override
    public boolean isTrusted(String domain) throws ServiceException, RemoteException {
        boolean result = false;
        AuthenticationServiceInterface service = this.getAuthenticationService();
        try {
            result = service.isTrusted(domain);
        }
        catch (ConnectException e) {
            service = this.findAuthenticationService();
            result = service.isTrusted(domain);
        }
        return result;
    }

    @Override
    public String getIDPropagation(String domain) throws ServiceException, RemoteException {
        String result = null;
        AuthenticationServiceInterface service = this.getAuthenticationService();
        try {
            result = service.getIDPropagation(domain);
        }
        catch (ConnectException e) {
            service = this.findAuthenticationService();
            result = service.getIDPropagation(domain);
        }
        return result;
    }

    @Override
    public AuthenticatorInterface getAuthenticator() throws RemoteException {
        AuthenticatorInterface authenticator = null;
        AuthenticationServiceInterface service = this.getAuthenticationService();
        try {
            authenticator = service.getAuthenticator();
        }
        catch (ConnectException e) {
            try {
                service = this.findAuthenticationService();
                authenticator = service.getAuthenticator();
            }
            catch (ServiceException ex) {
                throw new RemoteException(ex.getLocalizedMessage(), (Throwable)((Object)ex));
            }
        }
        return authenticator;
    }

    @Override
    public String getLoginConfigAppName() throws RemoteException {
        String loginContextApplicationName = null;
        AuthenticationServiceInterface service = this.getAuthenticationService();
        try {
            loginContextApplicationName = service.getLoginConfigAppName();
        }
        catch (ConnectException e) {
            try {
                service = this.findAuthenticationService();
                loginContextApplicationName = service.getLoginConfigAppName();
            }
            catch (ServiceException ex) {
                throw new RemoteException(ex.getLocalizedMessage(), (Throwable)((Object)ex));
            }
        }
        return loginContextApplicationName;
    }

    private final AuthenticationServiceInterface getAuthenticationService() {
        return (AuthenticationServiceInterface)this.getService();
    }

    private final AuthenticationServiceInterface findAuthenticationService() throws ServiceException, RemoteException {
        AuthenticationServiceInterface service = null;
        try {
            service = (AuthenticationServiceInterface)this.findRemoteService();
        }
        catch (ClassCastException e) {
            throw new ServiceException(e, e.getLocalizedMessage());
        }
        return service;
    }
}

