/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security;

import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.MergePolicy;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceException;
import com.sas.services.deployment.ConsumedResourceAdapter;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.deployment.Consumer;
import com.sas.services.deployment.ConsumerResourceAssoc;
import com.sas.services.deployment.ConsumerUsage;
import com.sas.services.security.AuthenticationServiceFactory;
import com.sas.services.security.AuthenticationServiceInitializer;
import com.sas.services.security.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

@SASScope
public final class AuthenticationServiceInitObject
extends AbstractServiceComponentConfig {
    private static final boolean IS_CONFIGURATION_UPDATEABLE = true;
    private static final UsageVersion USAGEVERSION_OLDEST = new UsageVersion(0, 0);
    private static final UsageVersion USAGEVERSION_CURRENT = new UsageVersion(0, 0);
    private String _loginConfigAppName;

    public AuthenticationServiceInitObject() {
        this("PFS");
    }

    public AuthenticationServiceInitObject(String loginConfigAppName) {
        super(AuthenticationServiceInitializer.getXMLDocument(), true);
        this.setUsageVersionCompatibility(USAGEVERSION_OLDEST, USAGEVERSION_CURRENT);
        this.setLoginConfigAppName(loginConfigAppName);
    }

    @Override
    protected AbstractServiceComponentConfig createConfiguration(Document document) throws ServiceException {
        return AuthenticationServiceInitializer.parse(document);
    }

    public String getLoginConfigAppName() {
        ConsumedResourceAdapter cra = this.getConsumedResourceAdapter("loginConfigAppName");
        return cra == null ? null : cra.getResourceValue();
    }

    public void setLoginConfigAppName(String loginConfigAppName) throws IllegalArgumentException {
        String appName = loginConfigAppName == null ? "" : loginConfigAppName.trim();
        int numChars = appName.length();
        for (int i = 0; i < numChars; ++i) {
            if (!Character.isWhitespace(loginConfigAppName.charAt(i))) continue;
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.loginConfigAppName.ex.fmt.txt", (Object)loginConfigAppName));
        }
        String resourceID = "loginConfigAppName";
        ConsumedResourceAdapter cra = this.getConsumedResourceAdapter("loginConfigAppName");
        if (cra == null) {
            cra = new ConsumedResourceAdapter("loginConfigAppName", appName, "loginConfigAppName", 0, RB.getStringResource("ASC.appName.type.txt"), true);
            this.addResourceAdapter(cra);
        } else {
            cra.setResourceValue(appName);
        }
        this._loginConfigAppName = appName;
    }

    @Override
    public String getConfirmDeleteUnusedResourcesMsg() {
        return RB.getStringResource("ASC.confirmRemovalUnusedResource.txt");
    }

    @Override
    public String getConfirmDeleteUnusedResourceMsg(ConsumedResourceInterface consumedResource) {
        return this.getConfirmDeleteUnusedResourcesMsg();
    }

    @Override
    public Consumer removeConsumer(Consumer consumer, boolean isRemoveResourceIfUnused) throws ServiceException {
        ConsumerUsage consumerUsage;
        Consumer removedConsumer = super.removeConsumer(consumer, isRemoveResourceIfUnused);
        if (isRemoveResourceIfUnused && (consumerUsage = this.getConsumerUsage()).getConsumersForResource("loginConfigAppName", true).size() == 0) {
            this.setLoginConfigAppName(null);
        }
        return removedConsumer;
    }

    @Override
    public Document getDocument() throws ServiceException {
        Document document = super.getDocument();
        try {
            AuthenticationServiceInitObject.appendDOM(document, this);
        }
        catch (DOMException e) {
            throw new ServiceConfigurationException(e, RB.getStringResource("ASC.getDocument.ex.txt"));
        }
        return document;
    }

    public static DocumentFragment appendDOM(Document document, AuthenticationServiceInitObject serviceConfig) {
        Element element;
        String appName;
        if (document != null && (appName = serviceConfig.getLoginConfigAppName()) != null && (appName = appName.trim()).length() > 0 && (element = document.getDocumentElement()) != null && "AuthenticationService".equals(element.getNodeName())) {
            element.setAttribute("loginConfigAppName", appName);
        }
        return null;
    }

    @Override
    public DocumentFragment appendDOM(Document document) {
        return AuthenticationServiceInitObject.appendDOM(document, this);
    }

    @Override
    protected void mergeConfiguration(AbstractServiceComponentConfig currentConfig, AbstractServiceComponentConfig newConfig) throws ServiceConfigurationException, IllegalArgumentException {
        this.mergeConfiguration(currentConfig, newConfig, this.getDefaultMergePolicy());
    }

    @Override
    protected void mergeConfiguration(AbstractServiceComponentConfig currentConfig, AbstractServiceComponentConfig newConfig, MergePolicy mergePolicy) throws ServiceConfigurationException, IllegalArgumentException {
        AuthenticationServiceInitObject serviceConfig1 = null;
        AuthenticationServiceInitObject serviceConfig2 = null;
        try {
            serviceConfig1 = (AuthenticationServiceInitObject)currentConfig;
            serviceConfig2 = (AuthenticationServiceInitObject)newConfig;
        }
        catch (ClassCastException e) {
            throw new ServiceConfigurationException(e, Message.format((ResourceBundle)RB.getResources(), (String)"ASC.invalidConfig.ex.fmt.txt", (Object)AuthenticationServiceInitObject.class.getName()));
        }
        AuthenticationServiceInitObject.mergeConfiguration(serviceConfig1, serviceConfig2, mergePolicy == null ? this.getDefaultMergePolicy() : mergePolicy);
    }

    private static void mergeConfiguration(AuthenticationServiceInitObject thisConfig, AuthenticationServiceInitObject newConfig, MergePolicy mergePolicy) throws ServiceConfigurationException, IllegalArgumentException {
        if (mergePolicy == null) {
            throw new IllegalArgumentException();
        }
        if (thisConfig == null) {
            throw new IllegalArgumentException();
        }
        if (newConfig == null) {
            throw new IllegalArgumentException();
        }
        String appNameCurrent = thisConfig.getLoginConfigAppName();
        String appNameOther = newConfig.getLoginConfigAppName();
        HashMap<String, String> resourceIdMap = new HashMap<String, String>(1);
        if (appNameOther != null && appNameOther.length() > 0) {
            boolean isOKToUpdate;
            boolean bl = isOKToUpdate = mergePolicy.isOKToReplace() || AuthenticationServiceInitObject.isResourceUndefined(appNameCurrent);
            if (!Strings.equal((String)appNameCurrent, (String)appNameOther, (boolean)false, (boolean)false) && !"PFS".equals(appNameOther)) {
                if (!isOKToUpdate) {
                    throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"ASC.conflictAppName.ex.fmt.txt", (Object)appNameCurrent, (Object)thisConfig.getConfigName(), (Object)appNameOther, (Object)newConfig.getConfigName()));
                }
                thisConfig.setLoginConfigAppName(appNameOther);
            }
        }
        String resourceKey = "loginConfigAppName";
        resourceIdMap.put(newConfig.getConsumedResourceAdapter("loginConfigAppName").getResourceID(), thisConfig.getConsumedResourceAdapter("loginConfigAppName").getResourceID());
        thisConfig.getConsumerUsage().merge(newConfig.getConsumerUsage(), resourceIdMap);
    }

    @Override
    public Consumer addConsumer(Consumer consumer, boolean isConsumer) {
        Consumer addedConsumer = super.addConsumer(consumer, isConsumer);
        if (isConsumer) {
            this.clearUndefinedResources(consumer);
        }
        return addedConsumer;
    }

    @Override
    public void setIsConsumer(Consumer consumer, boolean isConsumer) {
        super.setIsConsumer(consumer, isConsumer);
        if (isConsumer) {
            this.clearUndefinedResources(consumer);
        }
    }

    private void clearUndefinedResources(Consumer consumer) {
        if (consumer != null) {
            String consumerID = consumer.getID();
            ConsumerUsage consumerUsage = this.getConsumerUsage();
            ConsumerResourceAssoc consumerResourceAssoc = null;
            if (AuthenticationServiceInitObject.isResourceUndefined(this.getLoginConfigAppName())) {
                consumerResourceAssoc = consumerUsage.getConsumerResourceAssocsForConsumerAndResource(consumerID, "loginConfigAppName");
                consumerResourceAssoc.setIsConsumer(false);
            }
        }
    }

    private static boolean isResourceUndefined(String value) {
        return value == null || value.trim().length() == 0;
    }

    @Override
    protected DocumentFragment appendDOM(Document document, AbstractServiceComponentConfig serviceConfig) throws ServiceConfigurationException, IllegalArgumentException {
        DocumentFragment documentFragment = null;
        try {
            documentFragment = AuthenticationServiceInitObject.appendDOM(document, (AuthenticationServiceInitObject)serviceConfig);
        }
        catch (ClassCastException e) {
            throw new ServiceConfigurationException(e, Message.format((ResourceBundle)RB.getResources(), (String)"ASC.invalidConfig.ex.fmt.txt", (Object)AuthenticationServiceInitObject.class.getName()));
        }
        return documentFragment;
    }

    @Override
    protected void validateServiceConfigurationCustom(Document document) throws ServiceConfigurationException {
        AuthenticationServiceInitializer.parse(document);
    }

    static void validate(Document document) throws ServiceConfigurationException {
        if (document == null) {
            throw new ServiceConfigurationException(RB.getStringResource("IllegalArgument.nullDocument.ex.txt"));
        }
        Element docElement = document.getDocumentElement();
        String docElementName = docElement.getNodeName();
        if (!"AuthenticationService".equals(docElementName)) {
            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"ASC.invalidConfigDocElement.ex.fmt.txt", (Object)"AuthenticationService", (Object)docElementName));
        }
    }

    @Override
    protected String getServiceFactoryClassName() {
        return AuthenticationServiceFactory.class.getName();
    }

    @Override
    protected AbstractServiceComponentConfig getConfig(Document serviceConfigDocument) throws ServiceConfigurationException, IllegalArgumentException {
        return serviceConfigDocument == null ? new AuthenticationServiceInitObject() : AuthenticationServiceInitializer.parse(serviceConfigDocument);
    }

    protected void configureDocument(Document document) {
        AuthenticationServiceInitObject.appendDOM(document, this);
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (this == o) {
            isEqual = true;
        } else if (o != null && o.getClass() == this.getClass()) {
            AuthenticationServiceInitObject config = (AuthenticationServiceInitObject)o;
            isEqual = Strings.equal((String)this.getLoginConfigAppName(), (String)config.getLoginConfigAppName(), (boolean)false, (boolean)false);
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 5;
        if (this._loginConfigAppName != null) {
            hashCode ^= this._loginConfigAppName.hashCode();
        }
        return hashCode;
    }
}

