/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.logging;

import com.sas.codepolicy.SASScope;
import com.sas.entities.GUID;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.logging.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

@Deprecated
@SASScope
public class Output
implements Cloneable,
ConsumedResourceInterface {
    public static final String XML_ELEMENT_NAME = "Output";
    public static final String XML_ATTRIBUTE_UID = "uid";
    public static final String XML_ATTRIBUTE_ID = "id";
    public static final String XML_ATTRIBUTE_ASYNC = "async";
    public static final String XML_ATTRIBUTE_TYPE = "type";
    public static final String XML_ATTRIBUTE_LAYOUTPATTERN = "layoutPattern";
    public static final String XML_ATTRIBUTE_FILE = "file";
    public static final String XML_ATTRIBUTE_APPEND = "append";
    public static final String XML_ATTRIBUTE_IMMEDIATEFLUSH = "immediateFlush";
    public static final String XML_ATTRIBUTE_MAXFILESIZE = "maxFileSize";
    public static final String XML_ATTRIBUTE_MAXBACKUPINDEX = "maxBackupIndex";
    public static final String XML_ATTRIBUTE_DATEPATTERN = "datePattern";
    public static final String XML_ATTRIBUTE_TARGET = "target";
    public static final String XML_ATTRIBUTE_PORT = "port";
    public static final String XML_ATTRIBUTE_HOST = "host";
    public static final String XML_ATTRIBUTE_PARAM = "param";
    public static final String PROPERTYNAME_ID = "id";
    public static final String PROPERTYNAME_ASYNC = "async";
    public static final String PROPERTYNAME_TYPE = "type";
    public static final String PROPERTYNAME_LAYOUTPATTERN = "layoutPattern";
    public static final String PROPERTYNAME_FILE = "file";
    public static final String PROPERTYNAME_APPEND = "append";
    public static final String PROPERTYNAME_IMMEDIATEFLUSH = "immediateFlush";
    public static final String PROPERTYNAME_TARGET = "target";
    public static final String PROPERTYNAME_PORT = "port";
    public static final String PROPERTYNAME_HOST = "host";
    static final String XML_ATTRIBUTE_PARAM_VALUE = "value";
    static final String XML_ATTRIBUTE_PARAM_NAME = "name";
    private static final int PRIME_NUMBER = 31;
    private static final String TYPE_STRING_FILE = "File";
    private static final String TYPE_STRING_CONSOLE = "Console";
    private static final String TYPE_STRING_SOCKET = "Socket";
    private static final String TYPE_STRING_ARM = "ARM";
    private String _uid = GUID.newGUID();
    private volatile String _id;
    private volatile String _async;
    private volatile String _type;
    private volatile String _layoutPattern;
    private volatile Map<String, String> _params;
    private volatile String _maxBackupIndexLastSetValue = "";
    private volatile String _maxFileSizeLastSetValue = "";
    private volatile String _datePatternLastSetValue = "";

    public Output(String id, String async, String type, String layoutPattern, Map<String, String> params) {
        this.setID(id);
        this.setAsync(async);
        this.setType(type);
        this.setLayoutPattern(layoutPattern);
        this.setParams(params);
    }

    public Output(String uid, String id, String async, String type, String layoutPattern, Map<String, String> params) {
        this(id, async, type, layoutPattern, params);
        if (uid != null && uid.length() > 0) {
            this._uid = uid;
        }
    }

    public String getUID() {
        return this._uid;
    }

    public final String getID() {
        return this._id;
    }

    public final void setID(String id) {
        if (id != null) {
            this._id = id.trim();
        }
    }

    public final String getAsync() {
        return this._async;
    }

    public final void setAsync(String async) {
        if (async != null) {
            this._async = async.trim();
        }
    }

    public final String getType() {
        return this._type;
    }

    public final void setType(String type) {
        if (type != null) {
            this._type = type.trim();
        }
    }

    public final String getLayoutPattern() {
        return this._layoutPattern;
    }

    public final void setLayoutPattern(String layoutPattern) {
        this._layoutPattern = layoutPattern == null ? null : layoutPattern.trim();
    }

    public final Map<String, String> getParams() {
        return this._params;
    }

    public final void setParams(Map<String, String> params) {
        if (params != null) {
            this._params = params;
        }
    }

    public final String getFile() {
        return this._params.get("file");
    }

    public final void setFile(String file) {
        if (file != null) {
            this._params.put("file", file.trim());
        } else {
            this._params.remove("file");
        }
    }

    public final String getAppend() {
        return this._params.get("append");
    }

    public final void setAppend(String append) {
        if (append != null) {
            this._params.put("append", append.trim());
        } else {
            this._params.remove("append");
        }
    }

    public final String getImmediateFlush() {
        return this._params.get("immediateFlush");
    }

    public final void setImmediateFlush(String immediateFlush) {
        if (immediateFlush != null) {
            this._params.put("immediateFlush", immediateFlush.trim());
        } else {
            this._params.remove("immediateFlush");
        }
    }

    public final String getMaxFileSize() {
        return this._params.get(XML_ATTRIBUTE_MAXFILESIZE);
    }

    public final void setMaxFileSize(String maxFileSize) {
        if (maxFileSize != null) {
            this._params.put(XML_ATTRIBUTE_MAXFILESIZE, maxFileSize.trim());
        } else {
            this._params.remove(XML_ATTRIBUTE_MAXFILESIZE);
        }
    }

    public final String getMaxBackupIndex() {
        return this._params.get(XML_ATTRIBUTE_MAXBACKUPINDEX);
    }

    public final void setMaxBackupIndex(String maxBackupIndex) {
        if (maxBackupIndex != null) {
            this._params.put(XML_ATTRIBUTE_MAXBACKUPINDEX, maxBackupIndex.trim());
        } else {
            this._params.remove(XML_ATTRIBUTE_MAXBACKUPINDEX);
        }
    }

    public final String getDatePattern() {
        return this._params.get(XML_ATTRIBUTE_DATEPATTERN);
    }

    public final void setDatePattern(String datePattern) {
        if (datePattern != null) {
            this._params.put(XML_ATTRIBUTE_DATEPATTERN, datePattern.trim());
        } else {
            this._params.remove(XML_ATTRIBUTE_DATEPATTERN);
        }
    }

    public final String getTarget() {
        return this._params.get("target");
    }

    public final void setTarget(String target) {
        if (target != null) {
            this._params.put("target", target.trim());
        } else {
            this._params.remove("target");
        }
    }

    public final String getPort() {
        return this._params.get("port");
    }

    public final void setPort(String port) {
        if (port != null) {
            this._params.put("port", port.trim());
        } else {
            this._params.remove("port");
        }
    }

    public final String getHost() {
        return this._params.get("host");
    }

    public final void setHost(String host) {
        if (host != null) {
            this._params.put("host", host.trim());
        } else {
            this._params.remove("host");
        }
    }

    final DocumentFragment newDocumentFragment(Document document) {
        return Output.newDocumentFragment(document, this);
    }

    static final DocumentFragment newDocumentFragment(Document document, Output output) {
        DocumentFragment documentFragment = null;
        if (document != null && output != null) {
            documentFragment = document.createDocumentFragment();
            String outputType = output.getType();
            Element elementOutput = document.createElement(XML_ELEMENT_NAME);
            elementOutput.setAttribute(XML_ATTRIBUTE_UID, output.getUID());
            elementOutput.setAttribute("id", output.getID());
            elementOutput.setAttribute("type", outputType);
            elementOutput.setAttribute("layoutPattern", output.getLayoutPattern());
            if (output.getAsync() != null && !output.getAsync().equals("")) {
                elementOutput.setAttribute("async", output.getAsync());
            }
            for (Map.Entry<String, String> mapEntry : output.getParams().entrySet()) {
                String paramName = mapEntry.getKey();
                if (TYPE_STRING_FILE.equalsIgnoreCase(outputType) ? "target".equalsIgnoreCase(paramName) || "host".equalsIgnoreCase(paramName) || "port".equalsIgnoreCase(paramName) : (TYPE_STRING_CONSOLE.equalsIgnoreCase(outputType) ? "append".equalsIgnoreCase(paramName) || "file".equalsIgnoreCase(paramName) || XML_ATTRIBUTE_MAXBACKUPINDEX.equalsIgnoreCase(paramName) || XML_ATTRIBUTE_MAXFILESIZE.equalsIgnoreCase(paramName) || XML_ATTRIBUTE_DATEPATTERN.equalsIgnoreCase(paramName) || "host".equalsIgnoreCase(paramName) || "port".equalsIgnoreCase(paramName) : (TYPE_STRING_SOCKET.equalsIgnoreCase(outputType) ? "append".equalsIgnoreCase(paramName) || "file".equalsIgnoreCase(paramName) || XML_ATTRIBUTE_MAXBACKUPINDEX.equalsIgnoreCase(paramName) || XML_ATTRIBUTE_MAXFILESIZE.equalsIgnoreCase(paramName) || XML_ATTRIBUTE_DATEPATTERN.equalsIgnoreCase(paramName) || "target".equalsIgnoreCase(paramName) || "immediateFlush".equalsIgnoreCase(paramName) : TYPE_STRING_ARM.equalsIgnoreCase(outputType)))) continue;
                Element newParam = document.createElement(XML_ATTRIBUTE_PARAM);
                newParam.setAttribute(XML_ATTRIBUTE_PARAM_NAME, paramName);
                newParam.setAttribute(XML_ATTRIBUTE_PARAM_VALUE, mapEntry.getValue());
                elementOutput.appendChild(newParam);
            }
            documentFragment.appendChild(elementOutput);
        }
        return documentFragment;
    }

    final boolean hasConflict(Object obj, boolean isThrowException) throws ServiceConfigurationException {
        boolean isEqual = false;
        if (this == obj) {
            isEqual = true;
        } else if (obj != null) {
            try {
                Output output = (Output)obj;
                String async = output.getAsync();
                String layoutPattern = output.getLayoutPattern();
                isEqual = !(!this.isEqualID(output, isThrowException) || !"".equals(this._async) && async != null && !"".equals(async) && !this.isEqualAsync(output, isThrowException) || !this.isEqualType(output, isThrowException) || !"".equals(this._layoutPattern) && layoutPattern != null && !"".equals(layoutPattern) && !this.isEqualLayoutPattern(output, isThrowException) || !this.isEqualParameters(output, isThrowException));
            }
            catch (ClassCastException e) {
                isEqual = false;
            }
        }
        return !isEqual;
    }

    private boolean isEqualParameters(Output output, boolean isThrowException) throws ServiceConfigurationException {
        boolean isEqual = true;
        Map<String, String> parameterMap = output.getParams();
        String key = null;
        String value1 = null;
        String value2 = null;
        for (Map.Entry<String, String> mapEntry : this._params.entrySet()) {
            key = mapEntry.getKey();
            value1 = mapEntry.getValue();
            if (value1 == null || (value2 = parameterMap.get(key)) == null || value2.equals(value1)) continue;
            isEqual = false;
            if (!isThrowException) break;
            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"Output.parameterNotEqual.ex.fmt.txt", (Object)output.getID(), (Object)key, (Object)value1, (Object)value2));
        }
        return isEqual;
    }

    private boolean isEqualID(Output output, boolean isThrowException) throws ServiceConfigurationException {
        String value = output.getID();
        boolean isEqual = Strings.equal((String)this._id, (String)value, (boolean)false, (boolean)false);
        if (!isEqual && isThrowException) {
            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"Output.idNotEqual.ex.fmt.txt", (Object)this._id, (Object)value));
        }
        return isEqual;
    }

    private boolean isEqualAsync(Output output, boolean isThrowException) throws ServiceConfigurationException {
        String value = output.getAsync();
        boolean isEqual = Strings.equal((String)this._async, (String)value, (boolean)false, (boolean)false);
        if (!isEqual && isThrowException) {
            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"Output.asyncNotEqual.ex.fmt.txt", (Object)output.getID(), (Object)this._async, (Object)value));
        }
        return isEqual;
    }

    private boolean isEqualType(Output output, boolean isThrowException) throws ServiceConfigurationException {
        String value = output.getType();
        boolean isEqual = Strings.equal((String)this._type, (String)value, (boolean)false, (boolean)false);
        if (!isEqual && isThrowException) {
            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"Output.typeNotEqual.ex.fmt.txt", (Object)output.getID(), (Object)this._type, (Object)value));
        }
        return isEqual;
    }

    private boolean isEqualLayoutPattern(Output output, boolean isThrowException) throws ServiceConfigurationException {
        String value = output.getLayoutPattern();
        boolean isEqual = Strings.equal((String)this._layoutPattern, (String)value, (boolean)false, (boolean)false);
        if (!isEqual && isThrowException) {
            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"Output.layoutPatternNotEqual.ex.fmt.txt", (Object)output.getID(), (Object)this._layoutPattern, (Object)value));
        }
        return isEqual;
    }

    public final boolean equals(Object obj) {
        boolean isEqual = false;
        try {
            isEqual = !this.hasConflict(obj, false);
        }
        catch (ServiceConfigurationException e) {
            isEqual = false;
        }
        return isEqual;
    }

    public final int hashCode() {
        int hashCode = 31;
        if (this._id != null) {
            hashCode ^= this._id.hashCode();
        }
        if (this._async != null) {
            hashCode ^= this._async.hashCode();
        }
        if (this._type != null) {
            hashCode ^= this._type.hashCode();
        }
        if (this._layoutPattern != null) {
            hashCode ^= this._layoutPattern.hashCode();
        }
        if (this._params != null) {
            hashCode ^= this._params.hashCode();
        }
        return hashCode;
    }

    public String getMaxBackupIndexLastSetValue() {
        return this._maxBackupIndexLastSetValue;
    }

    public void setMaxBackupIndexLastSetValue(String backupIndexLastSetValue) {
        this._maxBackupIndexLastSetValue = backupIndexLastSetValue;
    }

    public String getMaxFileSizeLastSetValue() {
        return this._maxFileSizeLastSetValue;
    }

    public void setMaxFileSizeLastSetValue(String fileSizeLastSetValue) {
        this._maxFileSizeLastSetValue = fileSizeLastSetValue;
    }

    public String getDatePatternLastSetValue() {
        return this._datePatternLastSetValue;
    }

    public void setDatePatternLastSetValue(String datePatternLastSetValue) {
        this._datePatternLastSetValue = datePatternLastSetValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[id=");
        sb.append(this._id);
        sb.append("][type=");
        sb.append(this._type);
        sb.append("][async=");
        sb.append(this._async);
        sb.append("][layoutPattern=");
        sb.append(this._layoutPattern);
        if (TYPE_STRING_FILE.equalsIgnoreCase(this._type)) {
            sb.append("][maxFileSize=");
            sb.append(this._maxFileSizeLastSetValue);
        }
        sb.append(']');
        if (this._params.size() > 0) {
            sb.append("[params: ");
            for (Map.Entry<String, String> mapEntry : this._params.entrySet()) {
                sb.append('{');
                sb.append(mapEntry.getKey());
                sb.append('=');
                sb.append(mapEntry.getValue());
                sb.append('}');
            }
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Output output = (Output)super.clone();
        output.setParams(new HashMap<String, String>(this._params));
        return output;
    }

    void merge(Output newOutput) {
        if (newOutput != null) {
            this.setID(newOutput.getID());
            this.setType(newOutput.getType());
            String value = newOutput.getAppend();
            if (value != null) {
                this.setAppend(value);
            }
            if ((value = newOutput.getAsync()) != null && !"".equals(value)) {
                this.setAsync(value);
            }
            if ((value = newOutput.getDatePattern()) != null && !"".equals(value)) {
                this.setDatePattern(value);
            }
            if ((value = newOutput.getDatePatternLastSetValue()) != null && !"".equals(value)) {
                this.setDatePatternLastSetValue(value);
            }
            if ((value = newOutput.getFile()) != null && !"".equals(value)) {
                this.setFile(value);
            }
            if ((value = newOutput.getHost()) != null && !"".equals(value)) {
                this.setHost(value);
            }
            if ((value = newOutput.getImmediateFlush()) != null && !"".equals(value)) {
                this.setImmediateFlush(value);
            }
            if ((value = newOutput.getLayoutPattern()) != null && !"".equals(value)) {
                this.setLayoutPattern(value);
            }
            if ((value = newOutput.getMaxBackupIndex()) != null && !"".equals(value)) {
                this.setMaxBackupIndex(value);
            }
            if ((value = newOutput.getMaxBackupIndexLastSetValue()) != null && !"".equals(value)) {
                this.setMaxBackupIndexLastSetValue(value);
            }
            if ((value = newOutput.getMaxFileSize()) != null && !"".equals(value)) {
                this.setMaxFileSize(value);
            }
            if ((value = newOutput.getMaxFileSizeLastSetValue()) != null && !"".equals(value)) {
                this.setMaxFileSizeLastSetValue(value);
            }
            if ((value = newOutput.getPort()) != null && !"".equals(value)) {
                this.setPort(value);
            }
            if ((value = newOutput.getTarget()) != null && !"".equals(value)) {
                this.setTarget(value);
            }
        }
    }

    void replace(Output newOutput) {
        if (newOutput != null) {
            this.setType(newOutput.getType());
            this.setAppend(newOutput.getAppend());
            this.setAsync(newOutput.getAsync());
            this.setDatePattern(newOutput.getDatePattern());
            this.setDatePatternLastSetValue(newOutput.getDatePatternLastSetValue());
            this.setFile(newOutput.getFile());
            this.setHost(newOutput.getHost());
            this.setImmediateFlush(newOutput.getImmediateFlush());
            this.setLayoutPattern(newOutput.getLayoutPattern());
            this.setMaxBackupIndex(newOutput.getMaxBackupIndex());
            this.setMaxBackupIndexLastSetValue(newOutput.getMaxBackupIndexLastSetValue());
            this.setMaxFileSize(newOutput.getMaxFileSize());
            this.setMaxFileSizeLastSetValue(newOutput.getMaxFileSizeLastSetValue());
            this.setPort(newOutput.getPort());
            this.setTarget(newOutput.getTarget());
        }
    }

    @Override
    public String getResourceID() {
        return this._uid;
    }

    @Override
    public String getResourceValue() {
        return this._id;
    }

    @Override
    public String getLocalizedResourceType() {
        return RB.getStringResource("Output.resourceType.txt");
    }

    @Override
    public String getLocalizedResourceTypeAndValue() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"Common.ResourceTypeValue.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
    }

    @Override
    public String getResourceType() {
        return XML_ELEMENT_NAME;
    }

    @Override
    public int getResourceTypeCode() {
        return 1;
    }

    @Override
    public boolean isRequired() {
        return false;
    }
}

