/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.logging;

import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.DocumentServiceConfigAdapterInterface;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceException;
import com.sas.services.logging.Context;
import com.sas.services.logging.LoggingLog;
import com.sas.services.logging.LoggingServiceInitObject2;
import com.sas.services.logging.Output;
import com.sas.services.logging.RB;
import com.sas.services.logging.Renderer;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.beans.Introspector;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class LoggingServiceInitializer2
implements DocumentServiceConfigAdapterInterface {
    private static final String XML_DOCUMENT = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><!DOCTYPE LoggingService><LoggingService xmlns=\"urn:sas:LoggingService\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:sas:LoggingService com_sas_services_logging_LoggingService_9_2_0_0.xsd\" />";
    public static final String XML_ELEMENT_LOGGINGSERVICE = "LoggingService";
    public static final String XML_ELEMENT_ATTRIBUTE_UID = "uid";
    private static final String XML_ELEMENT_LOGGINGSERVICE_ATTRIBUTE_IMPLEMENTATION = "implementation";
    private static final String XML_ELEMENT_LOGGINGSERVICE_ATTRIBUTE_ISBASICLOGGING = "isBasicLogging";
    private static final String XML_ELEMENT_LOGGINGSERVICE_ATTRIBUTE_BASICLOGGINGPRIORITY = "basicLoggingPriority";
    private static final String XML_ELEMENT_RENDERER = "Renderer";
    private static final String XML_ELEMENT_RENDERER_ATTRIBUTE_RENDEREDCLASS = "renderedClass";
    private static final String XML_ELEMENT_RENDERER_ATTRIBUTE_RENDERINGCLASS = "renderingClass";
    private static final String XML_ELEMENT_LOGGINGCONTEXT = "LoggingContext";
    private static final String XML_ELEMENT_LOGGINGCONTEXT_ATTRIBUTE_NAME = "name";
    private static final String XML_ELEMENT_LOGGINGCONTEXT_ATTRIBUTE_CHAINED = "chained";
    private static final String XML_ELEMENT_LOGGINGCONTEXT_ATTRIBUTE_PRIORITY = "priority";
    private static final String XML_ELEMENT_ROOTLOGGINGCONTEXT = "RootLoggingContext";
    private static final String XML_ELEMENT_OUTPUTREF = "OutputRef";
    private static final String XML_ELEMENT_OUTPUTREF_ATTRIBUTE_ID = "outputID";
    private static final String PRIORITY_DEBUG = "DEBUG";
    private static final String PRIORITY_INFO = "INFO";
    private static final String PRIORITY_WARN = "WARN";
    private static final String PRIORITY_ERROR = "ERROR";
    private static final String PRIORITY_FATAL = "FATAL";
    private static int DEFAULT_BASIC_LOGGING_PRIORITY = Level.DEBUG.intLevel();

    @Override
    public AbstractServiceComponentConfig createConfigFromDocument(Document document) throws ServiceException {
        return LoggingServiceInitializer2.parse(document);
    }

    public static final LoggingServiceInitObject2 parse(Document document) throws ServiceConfigurationException {
        if (LoggingLog.isDebug() && LoggingLog.isDebugContext("com.sas.services.logging.configuration")) {
            LoggingLog.debug(RB.getStringResource("LoggingService.config.start.txt"));
            LoggingLog.printNode("  ", document);
            LoggingLog.debug(RB.getStringResource("LoggingService.config.end.txt"));
        }
        LoggingServiceInitObject2.validate(document);
        LoggingServiceInitObject2 loggingServiceConfiguration = new LoggingServiceInitObject2();
        LoggingServiceInitializer2.parseContext(document, loggingServiceConfiguration, false);
        return loggingServiceConfiguration;
    }

    public static void initialize(Object initObject, LoggingServiceInitObject2 loggingServiceConfiguration) throws ServiceConfigurationException {
        LoggingServiceInitializer2.parseContext(LoggingServiceInitializer2.getInitDocument(initObject), loggingServiceConfiguration, false);
    }

    private static final Document getInitDocument(Object initObject) throws ServiceConfigurationException {
        if (initObject == null) {
            throw new ServiceConfigurationException(RB.getStringResource("LoggingServiceInitializer.nonNullInitializationObjectRequired.ex.txt"));
        }
        if (!(initObject instanceof Document)) {
            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitializer.initializationObjectMustBeADocument.ex.txt", (Object)initObject));
        }
        return (Document)initObject;
    }

    static final void parseContext(Node node, LoggingServiceInitObject2 loggingServiceInitObject, boolean isProcessOutputsOnly) throws ServiceConfigurationException {
        NodeList nodeList = null;
        Node childNode = null;
        switch (node.getNodeType()) {
            case 9: {
                nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    childNode = nodeList.item(i);
                    if (childNode.getNodeType() == 3) continue;
                    LoggingServiceInitializer2.parseContext(childNode, loggingServiceInitObject, false);
                }
                break;
            }
            case 1: {
                int i;
                Element element = (Element)node;
                String elementName = node.getNodeName();
                if (elementName.equalsIgnoreCase(XML_ELEMENT_ROOTLOGGINGCONTEXT) || elementName.equalsIgnoreCase(XML_ELEMENT_LOGGINGCONTEXT)) {
                    if (isProcessOutputsOnly) break;
                    boolean isRoot = elementName.equalsIgnoreCase(XML_ELEMENT_ROOTLOGGINGCONTEXT);
                    String name = "";
                    String priority = "";
                    String chained = "";
                    Vector<String> outputs = new Vector<String>(5);
                    String uid = null;
                    if (isRoot) {
                        name = XML_ELEMENT_ROOTLOGGINGCONTEXT;
                    } else {
                        if (!element.hasAttribute(XML_ELEMENT_LOGGINGCONTEXT_ATTRIBUTE_NAME)) {
                            LoggingLog.error(RB.getStringResource("LoggingServiceInitializer.LoggingContextNameRequired.txt"));
                            break;
                        }
                        name = element.getAttribute(XML_ELEMENT_LOGGINGCONTEXT_ATTRIBUTE_NAME);
                    }
                    if (element.hasAttribute(XML_ELEMENT_ATTRIBUTE_UID)) {
                        uid = element.getAttribute(XML_ELEMENT_ATTRIBUTE_UID);
                    }
                    if (!isRoot && element.hasAttribute(XML_ELEMENT_LOGGINGCONTEXT_ATTRIBUTE_CHAINED)) {
                        chained = element.getAttribute(XML_ELEMENT_LOGGINGCONTEXT_ATTRIBUTE_CHAINED);
                    }
                    if (element.hasAttribute(XML_ELEMENT_LOGGINGCONTEXT_ATTRIBUTE_PRIORITY)) {
                        priority = element.getAttribute(XML_ELEMENT_LOGGINGCONTEXT_ATTRIBUTE_PRIORITY);
                    }
                    NodeList outputRefList = element.getChildNodes();
                    block13: for (int m = 0; m < outputRefList.getLength(); ++m) {
                        Node outputRefNode = outputRefList.item(m);
                        switch (outputRefNode.getNodeType()) {
                            case 1: {
                                Element outputRef = (Element)outputRefNode;
                                String outputRefTag = outputRefNode.getNodeName();
                                if (outputRefTag.equalsIgnoreCase(XML_ELEMENT_OUTPUTREF)) {
                                    if (outputRef.hasAttribute(XML_ELEMENT_OUTPUTREF_ATTRIBUTE_ID)) {
                                        outputs.add(outputRef.getAttribute(XML_ELEMENT_OUTPUTREF_ATTRIBUTE_ID));
                                        continue block13;
                                    }
                                    LoggingLog.error(RB.getStringResource("LoggingServiceInitializer.OutputRefMissingOutputID.txt"));
                                    continue block13;
                                }
                                LoggingLog.error(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitializer.OutputRefOnly.fmt.txt", (Object)outputRefTag));
                                continue block13;
                            }
                        }
                    }
                    loggingServiceInitObject.addContext(new Context(uid, name, priority, Boolean.toString(Boolean.valueOf(chained)), outputs));
                    break;
                }
                if ("ConsumerUsage".equals(elementName)) {
                    if (isProcessOutputsOnly) break;
                    loggingServiceInitObject.parseConsumerUsage(element);
                    break;
                }
                if (elementName.equalsIgnoreCase("Output")) {
                    if (!isProcessOutputsOnly) break;
                    String id = "";
                    String async = "";
                    String type = "";
                    String layoutPattern = "";
                    String uid = null;
                    if (!element.hasAttribute("id")) {
                        LoggingLog.error(RB.getStringResource("LoggingServiceInitializer.OutputIDRequired.txt"));
                        break;
                    }
                    if (!element.hasAttribute("type")) {
                        LoggingLog.error(RB.getStringResource("LoggingServiceInitializer.OutputTypeRequired.txt"));
                        break;
                    }
                    id = element.getAttribute("id");
                    if (element.hasAttribute(XML_ELEMENT_ATTRIBUTE_UID)) {
                        uid = element.getAttribute(XML_ELEMENT_ATTRIBUTE_UID);
                    }
                    if (element.hasAttribute("async")) {
                        async = element.getAttribute("async");
                    }
                    type = element.getAttribute("type");
                    if (element.hasAttribute("layoutPattern")) {
                        layoutPattern = element.getAttribute("layoutPattern");
                    }
                    NodeList paramList = element.getChildNodes();
                    HashMap<String, String> params = new HashMap<String, String>(paramList.getLength());
                    block14: for (int j = 0; j < paramList.getLength(); ++j) {
                        Node paramNode = paramList.item(j);
                        switch (paramNode.getNodeType()) {
                            case 1: {
                                Element param = (Element)paramNode;
                                String paramTag = paramNode.getNodeName();
                                if (paramTag.equalsIgnoreCase("param")) {
                                    String name = Introspector.decapitalize(param.getAttribute(XML_ELEMENT_LOGGINGCONTEXT_ATTRIBUTE_NAME));
                                    String value = param.getAttribute("value");
                                    params.put(name, value);
                                    continue block14;
                                }
                                LoggingLog.error(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitializer.OutputParamOnly.fmt.txt", (Object)paramTag));
                                continue block14;
                            }
                        }
                    }
                    loggingServiceInitObject.addOutput(new Output(uid, id, async, type, layoutPattern, params));
                    break;
                }
                if (elementName.equalsIgnoreCase(XML_ELEMENT_RENDERER)) {
                    if (isProcessOutputsOnly) break;
                    if (!element.hasAttribute(XML_ELEMENT_RENDERER_ATTRIBUTE_RENDEREDCLASS)) {
                        LoggingLog.error(RB.getStringResource("Common.RendererRequirements.txt"));
                        break;
                    }
                    if (!element.hasAttribute(XML_ELEMENT_RENDERER_ATTRIBUTE_RENDERINGCLASS)) {
                        LoggingLog.error(RB.getStringResource("Common.RendererRequirements.txt"));
                        break;
                    }
                    String uid = null;
                    if (element.hasAttribute(XML_ELEMENT_ATTRIBUTE_UID)) {
                        uid = element.getAttribute(XML_ELEMENT_ATTRIBUTE_UID);
                    }
                    loggingServiceInitObject.addRenderer(new Renderer(uid, element.getAttribute(XML_ELEMENT_RENDERER_ATTRIBUTE_RENDEREDCLASS), element.getAttribute(XML_ELEMENT_RENDERER_ATTRIBUTE_RENDERINGCLASS)));
                    break;
                }
                if (!elementName.equalsIgnoreCase(XML_ELEMENT_LOGGINGSERVICE)) break;
                try {
                    String version = element.getAttribute("version");
                    if (version.length() > 0) {
                        loggingServiceInitObject.setUsageVersion(UsageVersion.decode((double)Double.parseDouble(version)));
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                String implementation = element.getAttribute(XML_ELEMENT_LOGGINGSERVICE_ATTRIBUTE_IMPLEMENTATION);
                if (!implementation.equals("") && !implementation.equalsIgnoreCase("log4j")) {
                    throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitializer.exceptionImplementationNotSupported.fmt.txt", (Object)implementation));
                }
                loggingServiceInitObject.setImplementation(1);
                if (element.hasAttribute(XML_ELEMENT_LOGGINGSERVICE_ATTRIBUTE_ISBASICLOGGING) && element.getAttribute(XML_ELEMENT_LOGGINGSERVICE_ATTRIBUTE_ISBASICLOGGING).equalsIgnoreCase(Boolean.TRUE.toString())) {
                    loggingServiceInitObject.setBasicLogging(true);
                }
                int basicLoggingPriority = DEFAULT_BASIC_LOGGING_PRIORITY;
                if (element.hasAttribute(XML_ELEMENT_LOGGINGSERVICE_ATTRIBUTE_BASICLOGGINGPRIORITY)) {
                    basicLoggingPriority = LoggingServiceInitializer2.priorityStringToInt(element.getAttribute(XML_ELEMENT_LOGGINGSERVICE_ATTRIBUTE_BASICLOGGINGPRIORITY));
                }
                loggingServiceInitObject.setBasicLoggingPriority(basicLoggingPriority);
                nodeList = node.getChildNodes();
                for (i = 0; i < nodeList.getLength(); ++i) {
                    childNode = nodeList.item(i);
                    if (childNode.getNodeType() == 3) continue;
                    LoggingServiceInitializer2.parseContext(childNode, loggingServiceInitObject, true);
                }
                for (i = 0; i < nodeList.getLength(); ++i) {
                    childNode = nodeList.item(i);
                    if (childNode.getNodeType() == 3) continue;
                    LoggingServiceInitializer2.parseContext(childNode, loggingServiceInitObject, false);
                }
                break;
            }
        }
    }

    public static int priorityStringToInt(String priorityString) {
        return LoggingServiceInitializer2.priorityStringToInt(priorityString, Level.DEBUG.intLevel());
    }

    public static int priorityStringToInt(String priorityString, int defaultValue) {
        if (priorityString == null) {
            String msg = RB.getStringResource("LoggingServiceInitializer.nullLoggingPriorityString.txt");
            LoggingLog.error(msg);
            return Level.DEBUG.intLevel();
        }
        if (PRIORITY_DEBUG.equalsIgnoreCase(priorityString)) {
            return Level.DEBUG.intLevel();
        }
        if (PRIORITY_INFO.equalsIgnoreCase(priorityString)) {
            return Level.INFO.intLevel();
        }
        if (PRIORITY_WARN.equalsIgnoreCase(priorityString)) {
            return Level.WARN.intLevel();
        }
        if (PRIORITY_ERROR.equalsIgnoreCase(priorityString)) {
            return Level.ERROR.intLevel();
        }
        if (PRIORITY_FATAL.equalsIgnoreCase(priorityString)) {
            return Level.FATAL.intLevel();
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitializer.invalidLoggingPriorityString.fmt.txt", (Object)priorityString);
        LoggingLog.error(msg);
        return defaultValue;
    }

    static final String getXMLDocument() {
        return XML_DOCUMENT;
    }
}

