/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.logging;

import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.MergePolicy;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceException;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.deployment.Consumer;
import com.sas.services.deployment.ConsumerUsage;
import com.sas.services.logging.Context;
import com.sas.services.logging.LoggingLog;
import com.sas.services.logging.LoggingServiceFactory2;
import com.sas.services.logging.LoggingServiceInitializer2;
import com.sas.services.logging.MissingOutputException;
import com.sas.services.logging.Output;
import com.sas.services.logging.RB;
import com.sas.services.logging.Renderer;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

@SASScope
public final class LoggingServiceInitObject2
extends AbstractServiceComponentConfig {
    public static final String PROPERTYCHANGEEVENT_CONTEXT_ADD = "ContextAdd";
    public static final String PROPERTYCHANGEEVENT_CONTEXT_EDIT = "ContextEdit";
    public static final String PROPERTYCHANGEEVENT_CONTEXT_REMOVE = "ContextRemove";
    public static final String PROPERTYCHANGEEVENT_OUTPUT_ADD = "OutputAdd";
    public static final String PROPERTYCHANGEEVENT_OUTPUT_EDIT = "OutputEdit";
    public static final String PROPERTYCHANGEEVENT_OUTPUT_REMOVE = "OutputRemove";
    public static final String PROPERTYCHANGEEVENT_RENDERER_ADD = "RendererAdd";
    public static final String PROPERTYCHANGEEVENT_RENDERER_EDIT = "RendererEdit";
    public static final String PROPERTYCHANGEEVENT_RENDERER_REMOVE = "RendererRemove";
    private static final boolean IS_CONFIGURATION_UPDATEABLE = true;
    static final String IMPLEMENTATION_LOG4J = "log4j";
    private static final int PRIME_NUMBER = 31;
    private static final UsageVersion USAGEVERSION_OLDEST = new UsageVersion(0, 0);
    private static final UsageVersion USAGEVERSION_CURRENT = new UsageVersion(0, 0);
    private static final Logger logger = LogManager.getLogger(LoggingServiceInitObject2.class);
    private int _implementation = 1;
    private boolean _isBasicLogging;
    private int _basicLoggingPriority = Level.DEBUG.intLevel();
    private List<Context> _contexts = new ArrayList<Context>(5);
    private List<Output> _outputs = new ArrayList<Output>(5);
    private List<Renderer> _renderers = new ArrayList<Renderer>(5);
    private final Set<PropertyChangeListener> _propertyChangeListeners = new HashSet<PropertyChangeListener>(5);

    public LoggingServiceInitObject2() {
        super(LoggingServiceInitializer2.getXMLDocument(), true);
        this.setUsageVersionCompatibility(USAGEVERSION_OLDEST, USAGEVERSION_CURRENT);
    }

    public LoggingServiceInitObject2(InputStream configInputStream) throws IllegalArgumentException {
        super(configInputStream, true);
        this.setUsageVersionCompatibility(USAGEVERSION_OLDEST, USAGEVERSION_CURRENT);
    }

    @Override
    protected AbstractServiceComponentConfig createConfiguration(Document document) throws ServiceException {
        return LoggingServiceInitializer2.parse(document);
    }

    @Override
    protected AbstractServiceComponentConfig getConfig(Document serviceConfigDocument) throws ServiceConfigurationException, IllegalArgumentException {
        return serviceConfigDocument != null ? LoggingServiceInitializer2.parse(serviceConfigDocument) : new LoggingServiceInitObject2();
    }

    @Override
    protected DocumentFragment appendDOM(Document document, AbstractServiceComponentConfig serviceConfig) throws ServiceConfigurationException, IllegalArgumentException {
        DocumentFragment documentFragment = null;
        try {
            documentFragment = LoggingServiceInitObject2.appendDOM(document, (LoggingServiceInitObject2)serviceConfig);
        }
        catch (ClassCastException e) {
            throw new ServiceConfigurationException(e, e.getLocalizedMessage());
        }
        return documentFragment;
    }

    private static DocumentFragment appendDOM(Document document, LoggingServiceInitObject2 loggingServiceInitObject) throws ServiceConfigurationException {
        DocumentFragment documentFragment;
        block8: {
            documentFragment = null;
            try {
                String docElementName;
                if (document == null) break block8;
                Element element = document.getDocumentElement();
                String string = docElementName = element != null ? element.getNodeName() : "";
                if (element != null && Strings.equal((String)docElementName, (String)"LoggingService", (boolean)false, (boolean)false)) {
                    Context context2 = null;
                    for (Context context2 : loggingServiceInitObject.getContexts()) {
                        if (context2.getOutputs().size() <= 0) continue;
                        LoggingServiceInitObject2.removeUndefinedOutputsFromContext(context2, loggingServiceInitObject);
                        if (context2.getOutputs().size() > 0) {
                            element.appendChild(context2.newDocumentFragment(document));
                            continue;
                        }
                        logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.contextHasNoOutputs.fmt.log", (Object)context2.getName()));
                    }
                    for (Output output : loggingServiceInitObject.getOutputs()) {
                        element.appendChild(output.newDocumentFragment(document));
                    }
                    for (Renderer renderer : loggingServiceInitObject.getRenderers()) {
                        element.appendChild(renderer.newDocumentFragment(document));
                    }
                    break block8;
                }
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.documentElement.ex.fmt.txt", (Object)docElementName, (Object)"LoggingService"));
            }
            catch (ClassCastException e) {
                throw new ServiceConfigurationException(e);
            }
            catch (MissingOutputException e) {
                throw new ServiceConfigurationException((Throwable)((Object)e));
            }
        }
        return documentFragment;
    }

    private static void removeUndefinedOutputsFromContext(Context context, LoggingServiceInitObject2 loggingServiceInitObject) {
        Set<String> undefinedOutputs;
        if (context.getOutputs().size() > 0 && (undefinedOutputs = LoggingServiceInitObject2.getUndefinedContextOutputs(loggingServiceInitObject, context)).size() > 0) {
            for (String outputName : undefinedOutputs) {
                logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.removeUndefinedOutputFromContext.ex.fmt.txt", (Object)outputName, (Object)context.getName()));
                context.removeOutput(outputName);
            }
        }
    }

    private void replaceOutputID(String oldOutputID, String newOutputID) {
        if (!Strings.equal((String)oldOutputID, (String)newOutputID, (boolean)false, (boolean)false)) {
            for (Context context : new ArrayList<Context>(this._contexts)) {
                for (String outputID : new HashSet<String>(context.getOutputs())) {
                    if (!Strings.equal((String)oldOutputID, (String)outputID, (boolean)false, (boolean)false)) continue;
                    context.removeOutput(oldOutputID);
                    context.addOutput(newOutputID);
                }
            }
        }
    }

    @Override
    protected void mergeConfiguration(AbstractServiceComponentConfig currentConfig, AbstractServiceComponentConfig newConfig) throws ServiceConfigurationException, IllegalArgumentException {
        this.mergeConfiguration(currentConfig, newConfig, this.getDefaultMergePolicy());
    }

    @Override
    protected void mergeConfiguration(AbstractServiceComponentConfig currentConfig, AbstractServiceComponentConfig newConfig, MergePolicy mergePolicy) throws ServiceConfigurationException, IllegalArgumentException {
        LoggingServiceInitObject2 serviceConfig1 = null;
        LoggingServiceInitObject2 serviceConfig2 = null;
        try {
            serviceConfig1 = (LoggingServiceInitObject2)currentConfig;
            serviceConfig2 = (LoggingServiceInitObject2)newConfig;
        }
        catch (ClassCastException e) {
            throw new ServiceConfigurationException(e, Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.invalidConfig.ex.fmt.txt", (Object)LoggingServiceInitObject2.class.getName()));
        }
        LoggingServiceInitObject2.mergeConfiguration(serviceConfig1, serviceConfig2, mergePolicy == null ? this.getDefaultMergePolicy() : mergePolicy);
    }

    private static void mergeConfiguration(LoggingServiceInitObject2 thisConfig, LoggingServiceInitObject2 newConfig, MergePolicy mergePolicy) throws ServiceConfigurationException, IllegalArgumentException {
        if (mergePolicy == null) {
            throw new IllegalArgumentException();
        }
        if (thisConfig == null || newConfig == null) {
            throw new IllegalArgumentException(RB.getStringResource("LoggingServiceInitObject.mustSpecifyConfiguration.ex.txt"));
        }
        HashMap<String, String> resourceIdMap = new HashMap<String, String>(newConfig.getOutputs().size() + newConfig.getContexts().size() + newConfig.getRenderers().size());
        LoggingServiceInitObject2.mergeOutputs(thisConfig, newConfig, mergePolicy, resourceIdMap);
        LoggingServiceInitObject2.mergeContexts(thisConfig, newConfig, mergePolicy, resourceIdMap);
        LoggingServiceInitObject2.mergeRenderers(thisConfig, newConfig, mergePolicy, resourceIdMap);
        thisConfig.getConsumerUsage().merge(newConfig.getConsumerUsage(), resourceIdMap);
    }

    private static void mergeContexts(LoggingServiceInitObject2 thisConfig, LoggingServiceInitObject2 newConfig, MergePolicy mergePolicy, Map<String, String> resourceIdMap) throws ServiceConfigurationException, IllegalArgumentException {
        String newResourceID = null;
        String thisResourceID = null;
        Context thisContext = null;
        for (Context newContext : newConfig.getContexts()) {
            boolean isSame;
            newResourceID = newContext.getResourceID();
            thisContext = thisConfig.getContextUsingUID(newResourceID);
            boolean bl = isSame = thisContext != null;
            if (thisContext == null) {
                thisContext = thisConfig.getContext(newContext.getName());
            }
            if (thisContext == null) {
                thisConfig.addContext(newContext);
                thisResourceID = newContext.getResourceID();
            } else if (isSame || !newContext.hasConflict(thisContext)) {
                thisContext.merge(newContext);
                thisResourceID = thisContext.getResourceID();
            } else if (mergePolicy.isOKToReplace()) {
                thisContext.replace(newContext);
                thisResourceID = thisContext.getResourceID();
            } else {
                LoggingServiceInitObject2.handleContextConflict(newContext, thisContext);
            }
            resourceIdMap.put(newResourceID, thisResourceID);
        }
    }

    private static void mergeOutputs(LoggingServiceInitObject2 thisConfig, LoggingServiceInitObject2 newConfig, MergePolicy mergePolicy, Map<String, String> resourceIdMap) throws ServiceConfigurationException, IllegalArgumentException {
        Output thisOutput = null;
        String newResourceID = null;
        String thisResourceID = null;
        String newID = null;
        String thisID = null;
        for (Output newOutput : newConfig.getOutputs()) {
            boolean isSame;
            newResourceID = newOutput.getResourceID();
            newID = newOutput.getID();
            thisOutput = thisConfig.getOutputUsingUID(newResourceID);
            boolean bl = isSame = thisOutput != null;
            if (thisOutput == null) {
                thisOutput = thisConfig.getOutput(newID);
            }
            if (thisOutput == null) {
                thisConfig.addOutput(newOutput);
                thisResourceID = newResourceID;
            } else {
                thisID = thisOutput.getID();
                if (isSame || !newOutput.hasConflict(thisOutput, false)) {
                    thisOutput.merge(newOutput);
                    thisResourceID = thisOutput.getResourceID();
                } else if (mergePolicy.isOKToReplace()) {
                    thisOutput.replace(newOutput);
                    thisResourceID = thisOutput.getResourceID();
                } else {
                    throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.addOutput.ex.fmt.txt", (Object)newOutput.getID()));
                }
                if (!Strings.equal((String)thisID, (String)newID, (boolean)false, (boolean)false)) {
                    thisConfig.replaceOutputID(thisID, newID);
                }
            }
            resourceIdMap.put(newResourceID, thisResourceID);
        }
    }

    private static void mergeRenderers(LoggingServiceInitObject2 thisConfig, LoggingServiceInitObject2 newConfig, MergePolicy mergePolicy, Map<String, String> resourceIdMap) throws ServiceConfigurationException, IllegalArgumentException {
        String newResourceID = null;
        String thisResourceID = null;
        Renderer thisRenderer = null;
        for (Renderer newRenderer : newConfig.getRenderers()) {
            boolean isSame;
            newResourceID = newRenderer.getResourceID();
            thisRenderer = thisConfig.getRendererUsingUID(newResourceID);
            boolean bl = isSame = thisRenderer != null;
            if (thisRenderer == null) {
                thisRenderer = thisConfig.getRenderer(newRenderer.getRenderedClass());
            }
            if (thisRenderer == null) {
                thisConfig.addRenderer(newRenderer);
                thisResourceID = newRenderer.getResourceID();
            } else if (isSame || !newRenderer.hasConflict(thisRenderer)) {
                thisRenderer.merge(newRenderer);
                thisResourceID = thisRenderer.getResourceID();
            } else if (mergePolicy.isOKToReplace()) {
                thisRenderer.replace(newRenderer);
                thisResourceID = thisRenderer.getResourceID();
            } else {
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.addRenderer.ex.fmt.txt", (Object)newRenderer.getRenderedClass(), (Object)newRenderer.getRenderingClass(), (Object)thisRenderer.getRenderingClass()));
            }
            resourceIdMap.put(newResourceID, thisResourceID);
        }
    }

    private static void handleContextConflict(Context context, Context contextMerged) throws ServiceConfigurationException {
        String contextMergedPriority;
        String contextMergedIsChained;
        String contextIsChained = context.getChained();
        if (!contextIsChained.equalsIgnoreCase(contextMergedIsChained = contextMerged.getChained())) {
            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.addContextIsChained.ex.fmt.txt", (Object)context.getName(), (Object)contextIsChained, (Object)contextMergedIsChained));
        }
        String contextPriority = context.getPriority();
        if (!contextPriority.equalsIgnoreCase(contextMergedPriority = contextMerged.getPriority())) {
            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.addContextPriority.ex.fmt.txt", (Object)context.getName(), (Object)contextPriority, (Object)contextMergedPriority));
        }
        throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.addContext.ex.fmt.txt", (Object)context.getName()));
    }

    @Override
    protected void validateServiceConfigurationCustom(Document serviceConfiguration) throws ServiceException {
        LoggingServiceInitializer2.parse(serviceConfiguration);
    }

    static void validate(Document document) throws ServiceConfigurationException {
        if (document == null) {
            throw new ServiceConfigurationException(RB.getStringResource("IllegalArgument.specifyDocument.ex.txt"));
        }
        Element docElement = document.getDocumentElement();
        String docElementName = docElement.getNodeName();
        if (!"LoggingService".equals(docElementName)) {
            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.invalidConfigDocElement.ex.fmt.txt", (Object)"LoggingService", (Object)docElementName));
        }
    }

    @Override
    protected String getServiceFactoryClassName() {
        return LoggingServiceFactory2.class.getName();
    }

    public List<Context> getContexts() {
        return this._contexts;
    }

    public List<Output> getOutputs() {
        return this._outputs;
    }

    public List<Renderer> getRenderers() {
        return this._renderers;
    }

    public void addContext(String name, String priority, boolean isChained, Vector<String> contextOutputs) {
        this.addContext(new Context(name, priority, Boolean.toString(isChained), contextOutputs));
    }

    public void addContext(String name, String priority, String chained, Vector<String> contextOutputs) {
        this.addContext(new Context(name, priority, chained, contextOutputs));
    }

    public void addOutput(String id, String async, String type, String layoutPattern, Map<String, String> params) throws ServiceConfigurationException {
        this.addOutput(new Output(id, async, type, layoutPattern, params));
    }

    public void addRenderer(String renderedClass, String renderingClass) {
        this.addRenderer(new Renderer(renderedClass, renderingClass));
    }

    public void setImplementation(int implementation) {
        this._implementation = implementation;
    }

    public int getImplementation() {
        return this._implementation;
    }

    public void setBasicLogging(boolean isBasicLogging) {
        this._isBasicLogging = isBasicLogging;
    }

    public boolean isBasicLogging() {
        return this._isBasicLogging;
    }

    public void setBasicLoggingPriority(int priority) {
        this._basicLoggingPriority = priority;
    }

    public void setBasicLoggingPriority(String priorityString) {
        this._basicLoggingPriority = LoggingServiceInitializer2.priorityStringToInt(priorityString);
    }

    public int getBasicLoggingPriority() {
        return this._basicLoggingPriority;
    }

    @Override
    public DocumentFragment appendDOM(Document document) throws ServiceConfigurationException, IllegalArgumentException {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        Element documentElement = document.getDocumentElement();
        try {
            for (Context context : this._contexts) {
                if (context.getOutputs().size() <= 0) continue;
                LoggingServiceInitObject2.removeUndefinedOutputsFromContext(context, this);
                if (context.getOutputs().size() <= 0) continue;
                documentElement.appendChild(context.newDocumentFragment(document));
            }
            for (Output output : this._outputs) {
                documentElement.appendChild(output.newDocumentFragment(document));
            }
            for (Renderer renderer : this._renderers) {
                documentElement.appendChild(renderer.newDocumentFragment(document));
            }
        }
        catch (ClassCastException e) {
            throw new ServiceConfigurationException(e.getLocalizedMessage());
        }
        catch (DOMException e) {
            throw new ServiceConfigurationException(e.getLocalizedMessage());
        }
        catch (MissingOutputException e) {
            throw new ServiceConfigurationException(e.getLocalizedMessage());
        }
        return null;
    }

    public Context newContext(String name, String priority, String chained, Vector<String> outputs) {
        return new Context(name, priority, chained, outputs);
    }

    public boolean addContext(Context context) {
        boolean wasAdded = false;
        if (context != null) {
            boolean isOkToAdd = true;
            String contextName = context.getName();
            String contextID = context.getResourceID();
            for (Context nextContext : this._contexts) {
                if (!contextName.equals(nextContext.getName())) continue;
                isOkToAdd = false;
                wasAdded = contextID.equals(nextContext.getResourceID());
                if (context.isEquivalent(nextContext, false)) {
                    for (String outputID : context.getOutputs()) {
                        nextContext.addOutput(outputID);
                    }
                    LoggingServiceInitObject2.removeUndefinedOutputsFromContext(nextContext, this);
                    break;
                }
                isOkToAdd = false;
                if (!LoggingLog.isDebug()) break;
                LoggingLog.debug(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.duplicateContext.ex.fmt.txt", (Object)contextName));
                break;
            }
            if (isOkToAdd) {
                LoggingServiceInitObject2.removeUndefinedOutputsFromContext(context, this);
                this._contexts.add(context);
                this.addResource(context);
                wasAdded = true;
            }
        }
        return wasAdded;
    }

    private static Set<String> getUndefinedContextOutputs(LoggingServiceInitObject2 serviceConfig, Context context) {
        HashSet<String> undefinedOutputs = new HashSet<String>(5);
        for (String outputName : context.getOutputs()) {
            if (serviceConfig.getOutput(outputName) != null) continue;
            undefinedOutputs.add(outputName);
        }
        return undefinedOutputs;
    }

    public boolean removeContext(Context context) {
        boolean wasRemoved = false;
        if (context != null) {
            try {
                HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
                wasRemoved = this.removeResource(context.getResourceID(), removedConsumedResources) != null;
            }
            catch (ServiceException e) {
                wasRemoved = false;
            }
        }
        return wasRemoved;
    }

    public boolean removeContexts(int[] selIndices) throws ServiceException {
        if (selIndices != null) {
            HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
            int numIndices = selIndices.length;
            int index = -1;
            Context context = null;
            for (int i = numIndices - 1; i > -1; --i) {
                index = selIndices[i];
                context = this._contexts.get(index);
                this.removeResource(context.getResourceID(), removedConsumedResources);
            }
        }
        return true;
    }

    public Context getContext(int index) {
        return this._contexts.get(index);
    }

    public Context getContext(String name) {
        Context context = null;
        if (name != null) {
            int numDefs = this._contexts.size();
            Context aContext = null;
            for (int i = 0; i < numDefs; ++i) {
                aContext = this._contexts.get(i);
                if (!name.equals(aContext.getName())) continue;
                context = aContext;
                break;
            }
        }
        return context;
    }

    public Context getContextUsingUID(String uid) {
        Context context = null;
        if (uid != null) {
            for (Context aContext : this._contexts) {
                if (!uid.equals(aContext.getResourceID())) continue;
                context = aContext;
                break;
            }
        }
        return context;
    }

    @Override
    public ConsumedResourceInterface removeResource(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        ConsumedResourceInterface consumedResource = this.getConsumerUsage().getResourceUsingUID(resourceID);
        ConsumedResourceInterface removedObject = null;
        if (consumedResource != null) {
            switch (consumedResource.getResourceTypeCode()) {
                case 0: {
                    Context removedContext = this.removeContextForID(resourceID, removedConsumedResources);
                    removedObject = removedContext;
                    if (null == removedObject) break;
                    for (String outputID : new ArrayList<String>(removedContext.getOutputs())) {
                        if (this.isOutputUsed(outputID)) continue;
                        this.removeOutputForID(outputID, removedConsumedResources);
                    }
                    break;
                }
                case 1: {
                    removedObject = this.removeOutputForID(resourceID, removedConsumedResources);
                    break;
                }
                case 2: {
                    removedObject = this.removeRendererForID(resourceID, removedConsumedResources);
                    break;
                }
            }
        }
        if (removedObject != null) {
            removedObject = super.removeResource(resourceID, removedConsumedResources);
        }
        return removedObject;
    }

    private boolean isOutputUsed(String outputID) {
        boolean isOutputUsed = false;
        for (Context nextContext : new ArrayList<Context>(this._contexts)) {
            for (String nextOutputID : new ArrayList<String>(nextContext.getOutputs())) {
                if (!outputID.equals(nextOutputID)) continue;
                isOutputUsed = true;
                break;
            }
            if (!isOutputUsed) continue;
            break;
        }
        return isOutputUsed;
    }

    private Set<Context> getContextsForOutput(Output output) {
        HashSet<Context> contexts = new HashSet<Context>(this._contexts.size());
        String outputID = output.getID();
        for (Context context : this._contexts) {
            if (!context.getOutputs().contains(outputID)) continue;
            contexts.add(context);
        }
        return contexts;
    }

    private Context removeContextForID(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) {
        Context removedObject = null;
        if (resourceID != null) {
            Iterator<Context> iter = this._contexts.iterator();
            while (iter.hasNext()) {
                Context nextContext = iter.next();
                if (!resourceID.equals(nextContext.getResourceID())) continue;
                iter.remove();
                removedObject = nextContext;
                removedConsumedResources.add(nextContext);
                if (!logger.isDebugEnabled()) break;
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.removedContext.fmt.log", (Object)nextContext.getName(), (Object)this.getConfigName()));
                break;
            }
        }
        if (removedObject != null) {
            this.notifyPropertyChangeListeners(new PropertyChangeEvent(this, PROPERTYCHANGEEVENT_CONTEXT_REMOVE, removedObject, null));
        }
        return removedObject;
    }

    private Output removeOutputForID(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        Output output;
        Output removedObject = null;
        if (resourceID != null && (output = this.getOutputUsingUID(resourceID)) != null) {
            Iterator<Output> iter = this._outputs.iterator();
            while (iter.hasNext()) {
                if (!resourceID.equals(iter.next().getResourceID())) continue;
                iter.remove();
                removedObject = output;
                removedConsumedResources.add(output);
                this.removeOutputFromContexts(output, removedConsumedResources);
                if (!logger.isDebugEnabled()) break;
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.removedOutput.fmt.log", (Object)output.getID(), (Object)this.getConfigName()));
                break;
            }
            if (removedObject != null) {
                this.notifyPropertyChangeListeners(new PropertyChangeEvent(this, PROPERTYCHANGEEVENT_OUTPUT_REMOVE, removedObject, null));
            }
        }
        return removedObject;
    }

    private void removeOutputFromContexts(Output output, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        if (output != null) {
            String outputID = output.getID();
            for (Context context : new ArrayList<Context>(this._contexts)) {
                context.removeOutput(outputID);
                if (logger.isDebugEnabled()) {
                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.removedOutputFromContext.fmt.log", (Object)outputID, (Object)context.getName(), (Object)this.getConfigName()));
                }
                if (context.getOutputs().size() != 0) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.contextHasNoOutputs.fmt.log", (Object)context.getName(), (Object)this.getConfigName()));
                }
                this.removeResource(context.getResourceID(), removedConsumedResources);
            }
        }
    }

    private Renderer removeRendererForID(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) {
        Renderer removedObject = null;
        if (resourceID != null) {
            Iterator<Renderer> iter = this._renderers.iterator();
            while (iter.hasNext()) {
                Renderer nextRenderer = iter.next();
                if (!resourceID.equals(nextRenderer.getResourceID())) continue;
                removedObject = nextRenderer;
                iter.remove();
                removedConsumedResources.add(nextRenderer);
                if (!logger.isDebugEnabled()) break;
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.removedRenderer.fmt.log", (Object)nextRenderer.getRenderedClass(), (Object)this.getConfigName()));
                break;
            }
            if (removedObject != null) {
                this.notifyPropertyChangeListeners(new PropertyChangeEvent(this, PROPERTYCHANGEEVENT_RENDERER_REMOVE, removedObject, null));
            }
        }
        return removedObject;
    }

    public Output newOutput(String id, String async, String type, String layoutPattern, Map<String, String> params) {
        Output output = new Output(id, async, type, layoutPattern, params);
        return output;
    }

    public boolean addOutput(Output output) throws ServiceConfigurationException {
        boolean wasAdded = false;
        if (output != null) {
            boolean isOkToAdd = true;
            String outputID = output.getID();
            for (Output nextOutput : this._outputs) {
                if (!outputID.equals(nextOutput.getID())) continue;
                isOkToAdd = false;
                wasAdded = !nextOutput.hasConflict(output, true);
                break;
            }
            if (isOkToAdd && (wasAdded = this._outputs.add(output))) {
                this.addResource(output);
                this.notifyPropertyChangeListeners(new PropertyChangeEvent(this, PROPERTYCHANGEEVENT_OUTPUT_ADD, null, output));
            }
        }
        return wasAdded;
    }

    public boolean removeOutput(Output output) {
        boolean wasRemoved = false;
        if (output != null) {
            try {
                HashSet<ConsumedResourceInterface> removedConsumerResources = new HashSet<ConsumedResourceInterface>(5);
                wasRemoved = this.removeResource(output.getResourceID(), removedConsumerResources) != null;
            }
            catch (ServiceException e) {
                wasRemoved = false;
            }
        }
        return wasRemoved;
    }

    public boolean removeOutputs(int[] selIndices) throws ServiceException {
        if (selIndices != null) {
            HashSet<ConsumedResourceInterface> removedConsumerResources = new HashSet<ConsumedResourceInterface>(5);
            int numIndices = selIndices.length;
            Output output = null;
            int index = -1;
            for (int i = numIndices - 1; i > -1; --i) {
                index = selIndices[i];
                output = this._outputs.get(index);
                this.removeResource(output.getResourceID(), removedConsumerResources);
            }
        }
        return true;
    }

    public Output getOutput(int index) {
        return this._outputs.get(index);
    }

    public Output getOutput(String id) {
        Output output = null;
        if (id != null) {
            for (Output anOutput : this._outputs) {
                if (!id.equals(anOutput.getID())) continue;
                output = anOutput;
                break;
            }
        }
        return output;
    }

    public Output getOutputUsingUID(String uid) {
        Output output = null;
        if (uid != null) {
            for (Output nextOutput : this._outputs) {
                if (!uid.equals(nextOutput.getUID())) continue;
                output = nextOutput;
                break;
            }
        }
        return output;
    }

    public Renderer newRenderer(String renderedClass, String renderingClass) {
        return new Renderer(renderedClass, renderingClass);
    }

    public boolean addRenderer(Renderer renderer) {
        boolean wasAdded = false;
        if (renderer != null) {
            boolean isOkToAdd = true;
            String renderedClass = renderer.getRenderedClass();
            String rendererID = renderer.getResourceID();
            if (renderedClass != null) {
                Iterator<Renderer> iter = this._renderers.iterator();
                while (iter.hasNext()) {
                    Renderer aRenderer = iter.next();
                    if (!renderedClass.equals(aRenderer.getRenderedClass())) continue;
                    if (!renderer.getRenderingClass().equals(aRenderer.getRenderingClass())) {
                        if (rendererID.equals(aRenderer.getResourceID())) {
                            iter.remove();
                            break;
                        }
                        wasAdded = true;
                        break;
                    }
                    isOkToAdd = false;
                    if (wasAdded || !LoggingLog.isDebug()) break;
                    LoggingLog.debug(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceInitObject.duplicateRenderer.ex.fmt.txt", (Object)renderedClass));
                    break;
                }
                if (isOkToAdd && (wasAdded = this._renderers.add(renderer))) {
                    this.addResource(renderer);
                    this.notifyPropertyChangeListeners(new PropertyChangeEvent(this, PROPERTYCHANGEEVENT_RENDERER_ADD, null, renderer));
                }
            }
        }
        return wasAdded;
    }

    public boolean removeRenderer(Renderer renderer) {
        boolean wasRemoved = false;
        if (renderer != null) {
            try {
                HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
                wasRemoved = this.removeResource(renderer.getResourceID(), removedConsumedResources) != null;
            }
            catch (ServiceException e) {
                wasRemoved = false;
            }
        }
        return wasRemoved;
    }

    public boolean removeRenderers(int[] selIndices) {
        if (selIndices != null) {
            int numIndices = selIndices.length;
            for (int i = numIndices - 1; i > -1; --i) {
                this.removeRenderer(this._renderers.get(selIndices[i]));
            }
        }
        return true;
    }

    public Renderer getRenderer(int index) {
        return this._renderers.get(index);
    }

    public Renderer getRenderer(String renderedClass) {
        Renderer renderer = null;
        if (renderedClass != null) {
            for (Renderer aRenderer : this._renderers) {
                if (!renderedClass.equals(aRenderer.getRenderedClass())) continue;
                renderer = aRenderer;
                break;
            }
        }
        return renderer;
    }

    public Renderer getRendererUsingUID(String uid) {
        Renderer renderer = null;
        if (uid != null) {
            for (Renderer aRenderer : this._renderers) {
                if (!uid.equals(aRenderer.getUID())) continue;
                renderer = aRenderer;
                break;
            }
        }
        return renderer;
    }

    @Override
    public Set<ConsumedResourceInterface> getResourcesWhichUseResource(Set<ConsumedResourceInterface> consumedResources) {
        HashSet<ConsumedResourceInterface> set = new HashSet<ConsumedResourceInterface>(5);
        if (consumedResources != null) {
            for (ConsumedResourceInterface consumedResource : consumedResources) {
                if (1 != consumedResource.getResourceTypeCode()) continue;
                set.addAll(this.getContextsForOutput((Output)consumedResource));
            }
        }
        return set;
    }

    public void parseDocument(Document document) throws ServiceConfigurationException {
        LoggingServiceInitializer2.parseContext(document, this, false);
    }

    @Override
    public Set<ConsumedResourceInterface> getUnusedResources(Set<String> removedConsumerNames) {
        Set<ConsumedResourceInterface> unusedConsumedResources = super.getUnusedResources(removedConsumerNames);
        HashSet<ConsumedResourceInterface> unusedContexts = new HashSet<ConsumedResourceInterface>(unusedConsumedResources.size());
        HashMap<String, Output> unusedOutputs = new HashMap<String, Output>(unusedConsumedResources.size());
        Output output2 = null;
        Iterator<ConsumedResourceInterface> iter = unusedConsumedResources.iterator();
        while (iter.hasNext()) {
            ConsumedResourceInterface consumedResource = iter.next();
            switch (consumedResource.getResourceTypeCode()) {
                case 0: {
                    unusedContexts.add(consumedResource);
                    break;
                }
                case 1: {
                    output2 = (Output)consumedResource;
                    if (this.isOutputUsedByConsumer(output2, removedConsumerNames)) {
                        iter.remove();
                        break;
                    }
                    unusedOutputs.put(consumedResource.getResourceID(), output2);
                    break;
                }
            }
        }
        Vector<String> contextOutputs = null;
        Context context2 = null;
        for (Context context2 : this._contexts) {
            if (unusedContexts.contains(context2)) continue;
            contextOutputs = context2.getOutputs();
            int numContextOutputs = contextOutputs.size();
            int numUnusedOutputs = 0;
            HashMap<String, Output> usedContextOutputs = new HashMap<String, Output>(numContextOutputs);
            String outputID2 = null;
            String resourceID = null;
            for (String outputID2 : contextOutputs) {
                output2 = this.getOutput(outputID2);
                if (output2 != null) {
                    resourceID = output2.getResourceID();
                    usedContextOutputs.put(resourceID, output2);
                }
                if (unusedOutputs.get(resourceID) == null) continue;
                ++numUnusedOutputs;
            }
            if (numUnusedOutputs != numContextOutputs) continue;
            for (Output output2 : usedContextOutputs.values()) {
                unusedOutputs.remove(output2.getResourceID());
                unusedConsumedResources.remove(output2);
            }
        }
        return unusedConsumedResources;
    }

    public String replaceFileOutputStrings(String oldDirectoryName, String newDirectoryName, String oldFileName, String newFileName) {
        StringBuilder newFilePaths = new StringBuilder();
        for (Output output : this.getOutputs()) {
            StringBuilder sb;
            boolean thisOneChanged = false;
            String filePath = output.getFile();
            if (null == filePath) continue;
            int indexOfLastFileSepChar = Math.max(filePath.lastIndexOf("/"), filePath.lastIndexOf("\\"));
            if (filePath.indexOf(oldFileName) == 0 && indexOfLastFileSepChar == -1 || filePath.indexOf(oldFileName) == indexOfLastFileSepChar + 1) {
                sb = new StringBuilder();
                sb.append(filePath.substring(0, indexOfLastFileSepChar + 1));
                sb.append(newFileName);
                filePath = sb.toString();
                thisOneChanged = true;
            }
            if (filePath.indexOf(oldDirectoryName) == 0 && oldDirectoryName.length() == indexOfLastFileSepChar) {
                sb = new StringBuilder();
                sb.append(newDirectoryName);
                sb.append(File.separatorChar);
                sb.append(filePath.substring(indexOfLastFileSepChar + 1));
                filePath = sb.toString();
                thisOneChanged = true;
            }
            if (!thisOneChanged) continue;
            output.setFile(filePath);
            if (newFilePaths.length() > 0) {
                newFilePaths.append(',');
            }
            newFilePaths.append(filePath);
        }
        return newFilePaths.toString();
    }

    private boolean isOutputUsedByConsumer(Output output, Set<String> removedConsumerNames) {
        boolean isUsed = false;
        String outputID = output.getID();
        HashSet<String> contextConsumerIDs = new HashSet<String>(5);
        ConsumerUsage consumerUsage = this.getConsumerUsage();
        for (Context context : this._contexts) {
            if (!context.getOutputs().contains(outputID)) continue;
            for (Consumer consumer : consumerUsage.getConsumersForResource(context.getResourceID(), true)) {
                if (consumer == null) continue;
                contextConsumerIDs.add(consumer.getID());
            }
        }
        if (contextConsumerIDs.size() > 0) {
            HashSet<String> removedConsumerIDs = new HashSet<String>(removedConsumerNames.size());
            for (String consumerName : removedConsumerNames) {
                Consumer consumer;
                consumer = consumerUsage.getConsumerUsingName(consumerName);
                if (consumer == null) continue;
                removedConsumerIDs.add(consumer.getID());
            }
            for (String consumerID : contextConsumerIDs) {
                if (removedConsumerIDs.contains(consumerID)) continue;
                isUsed = true;
                break;
            }
        }
        return isUsed;
    }

    public boolean addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        return this._propertyChangeListeners.add(propertyChangeListener);
    }

    public boolean removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        return this._propertyChangeListeners.remove(propertyChangeListener);
    }

    private void notifyPropertyChangeListeners(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent != null) {
            int numListeners = this._propertyChangeListeners.size();
            PropertyChangeListener[] listeners = new PropertyChangeListener[numListeners];
            listeners = this._propertyChangeListeners.toArray(listeners);
            for (int i = 0; i < numListeners; ++i) {
                listeners[i].propertyChange(propertyChangeEvent);
            }
        }
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (this == o) {
            isEqual = true;
        } else if (o != null && o.getClass() == this.getClass()) {
            LoggingServiceInitObject2 lsio = (LoggingServiceInitObject2)o;
            isEqual = this._isBasicLogging == lsio._isBasicLogging && this._basicLoggingPriority == lsio._basicLoggingPriority && this._implementation == lsio._implementation && LoggingServiceInitObject2.listsEqual(this._outputs, lsio._outputs) && LoggingServiceInitObject2.listsEqual(this._renderers, lsio._renderers) && LoggingServiceInitObject2.listsEqual(this._contexts, lsio._contexts);
        }
        return isEqual;
    }

    private static boolean listsEqual(List<? extends ConsumedResourceInterface> list1, List<? extends ConsumedResourceInterface> list2) {
        boolean isEqual;
        boolean bl = isEqual = list1.size() == list2.size();
        if (isEqual) {
            Iterator<? extends ConsumedResourceInterface> iter = list1.iterator();
            while (iter.hasNext()) {
                if (list2.contains(iter.next())) continue;
                isEqual = false;
                break;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 5;
        int primeNumber = 31;
        hashCode = 31 * hashCode + this._basicLoggingPriority;
        hashCode = 31 * hashCode + this._implementation;
        hashCode = 31 * hashCode + (this._isBasicLogging ? 1 : 0);
        hashCode = 31 * hashCode + (this._contexts == null ? 0 : this._contexts.hashCode());
        hashCode = 31 * hashCode + (this._outputs == null ? 0 : this._outputs.hashCode());
        hashCode = 31 * hashCode + (this._renderers == null ? 0 : this._renderers.hashCode());
        return hashCode;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LoggingServiceInitObject2 config = (LoggingServiceInitObject2)super.clone();
        config._contexts = new ArrayList<Context>(this._contexts.size());
        for (Context context : this._contexts) {
            config._contexts.add((Context)context.clone());
        }
        config._outputs = new ArrayList<Output>(this._outputs.size());
        for (Output output : this._outputs) {
            config._outputs.add((Output)output.clone());
        }
        config._renderers = new ArrayList<Renderer>(this._renderers.size());
        for (Renderer renderer : this._renderers) {
            config._renderers.add((Renderer)renderer.clone());
        }
        return config;
    }
}

