/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.search;

import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.DetailsProcessorInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.search.RB;
import java.rmi.RemoteException;
import java.util.Comparator;
import java.util.Date;

public enum SortOrder {
    NAME("NAME"),
    TYPE("TYPE"),
    DESCRIPTION("DESC"),
    CREATED_DATE("CREATEDDATE"),
    MODIFIED_DATE("MODIFIEDDATE"),
    PATH("PATH");

    public static final String SORT_BY_NAME;
    public static final String SORT_BY_TYPE;
    public static final String SORT_BY_DESC;
    public static final String SORT_BY_CREATEDATE;
    public static final String SORT_BY_MODIFIEDDATE;
    public static final String SORT_BY_PATH;
    private static boolean _sortingEnabled;
    private String sortValue;

    private SortOrder(String sortValue) {
        this.sortValue = sortValue;
    }

    public String getStringValue() {
        return this.sortValue;
    }

    public static SortOrder[] getDefaultOrder() {
        return new SortOrder[]{NAME, TYPE};
    }

    public static boolean isSortingEnabled() {
        return _sortingEnabled;
    }

    public static void setSortingEnabled(boolean sortingAllowed) {
        _sortingEnabled = sortingAllowed;
    }

    public static SortOrder getSortOrder(String sortItem) {
        if (sortItem.equalsIgnoreCase(NAME.getStringValue())) {
            return NAME;
        }
        if (sortItem.equalsIgnoreCase(TYPE.getStringValue())) {
            return TYPE;
        }
        if (sortItem.equalsIgnoreCase(DESCRIPTION.getStringValue())) {
            return DESCRIPTION;
        }
        if (sortItem.equalsIgnoreCase(CREATED_DATE.getStringValue())) {
            return CREATED_DATE;
        }
        if (sortItem.equalsIgnoreCase(MODIFIED_DATE.getStringValue())) {
            return MODIFIED_DATE;
        }
        if (sortItem.equalsIgnoreCase(PATH.getStringValue())) {
            return PATH;
        }
        return null;
    }

    public static Comparator<PublicObjectInterface> getComparator(SortOrder[] order) {
        return new ObjectComparator(order);
    }

    static {
        SORT_BY_NAME = RB.getStringResource("SortOrder.NameSort.txt");
        SORT_BY_TYPE = RB.getStringResource("SortOrder.TypeSort.txt");
        SORT_BY_DESC = RB.getStringResource("SortOrder.DescriptionSort.txt");
        SORT_BY_CREATEDATE = RB.getStringResource("SortOrder.CreatedDateSort.txt");
        SORT_BY_MODIFIEDDATE = RB.getStringResource("SortOrder.ModifiedDateSort.txt");
        SORT_BY_PATH = RB.getStringResource("SortOrder.PathSort.txt");
        _sortingEnabled = true;
    }

    private static class ObjectComparator
    implements Comparator<PublicObjectInterface> {
        private SortOrder[] _order;

        ObjectComparator(SortOrder[] order) {
            boolean sortingByPath;
            this._order = order == null ? SortOrder.getDefaultOrder() : ((sortingByPath = this.isSortByPathOption(order)) ? new SortOrder[]{PATH, TYPE} : order);
        }

        private boolean isSortByPathOption(SortOrder[] order) {
            for (int i = 0; i < order.length; ++i) {
                if (!PATH.equals((Object)order[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compare(PublicObjectInterface object1, PublicObjectInterface object2) {
            try {
                if (!this.isSortByPathOption(this._order)) {
                    boolean isFolder1 = FolderUtil.isFolder(object1);
                    boolean isFolder2 = FolderUtil.isFolder(object2);
                    if (isFolder1 && !isFolder2) {
                        return -1;
                    }
                    if (!isFolder1 && isFolder2) {
                        return 1;
                    }
                }
                for (int i = 0; i < this._order.length; ++i) {
                    int compare = 0;
                    block1 : switch (this._order[i].ordinal()) {
                        case 0: {
                            compare = object1.getName().compareToIgnoreCase(object2.getName());
                            break;
                        }
                        case 1: {
                            TypeDescriptorInterface typeDesc2;
                            TypeDescriptorInterface typeDesc1 = object1.getTypeDescriptor();
                            if (typeDesc1 == null) {
                                return -1;
                            }
                            String type1 = typeDesc1.getTypeName();
                            int index = type1.indexOf(46);
                            if (index > 0) {
                                type1 = type1.substring(0, index - 1);
                            }
                            if ((typeDesc2 = object2.getTypeDescriptor()) == null) {
                                return 1;
                            }
                            String type2 = typeDesc2.getTypeName();
                            index = type2.indexOf(46);
                            if (index > 0) {
                                type2 = type2.substring(0, index - 1);
                            }
                            compare = type1.compareToIgnoreCase(type2);
                            break;
                        }
                        case 2: {
                            DetailsProcessorInterface descDetails1 = (DetailsProcessorInterface)object1.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
                            if (descDetails1 == null) {
                                return -1;
                            }
                            DetailsProcessorInterface descDetails2 = (DetailsProcessorInterface)object2.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
                            if (descDetails2 == null) {
                                return 1;
                            }
                            String desc1 = descDetails1.getDescription();
                            String desc2 = descDetails2.getDescription();
                            if (desc1 == null || desc2 == null) break;
                            compare = desc1.compareTo(desc2);
                            break;
                        }
                        case 3: {
                            DetailsProcessorInterface createDetails1 = (DetailsProcessorInterface)object1.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
                            DetailsProcessorInterface createDetails2 = (DetailsProcessorInterface)object2.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
                            Date createDate1 = createDetails1.getCreateDate();
                            Date createDate2 = createDetails2.getCreateDate();
                            if (createDate1 == null || createDate2 == null) break;
                            compare = createDate1.compareTo(createDate2);
                            break;
                        }
                        case 4: {
                            DetailsProcessorInterface modifyDetails1 = (DetailsProcessorInterface)object1.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
                            DetailsProcessorInterface modifyDetails2 = (DetailsProcessorInterface)object2.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
                            Date modifyDate1 = modifyDetails1.getModifyDate();
                            Date modifyDate2 = modifyDetails2.getModifyDate();
                            if (modifyDate1 == null || modifyDate2 == null) break;
                            compare = modifyDate1.compareTo(modifyDate2);
                            break;
                        }
                        case 5: {
                            String[] leftElements = this.getObjectPath(object1).split("/");
                            String[] rightElements = this.getObjectPath(object2).split("/");
                            SASStringComparator stringComparator = SASCollatorFactory.createCollator();
                            int n = 0;
                            while (true) {
                                if (n >= leftElements.length) {
                                    if (n >= rightElements.length) {
                                        compare = 0;
                                        break block1;
                                    }
                                    compare = -1;
                                    break block1;
                                }
                                if (n >= rightElements.length) {
                                    compare = 1;
                                    break block1;
                                }
                                compare = stringComparator.compare(leftElements[n], rightElements[n]);
                                if (compare != 0) break block1;
                                ++n;
                            }
                        }
                    }
                    if (compare == 0) continue;
                    return compare;
                }
                return 0;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private String getObjectPath(PublicObjectInterface object) throws ServiceException, RemoteException {
            PathUrl url = object.getPathUrl();
            if (url == null) {
                PublicObjectContainerInterface parent = object.getContainer();
                if (parent == null) {
                    return object.getName();
                }
                return this.getObjectPath(parent) + "/" + object.getName();
            }
            String path = url.getDisplayPath();
            return path;
        }

        public boolean equals(PublicObjectInterface object1, PublicObjectInterface object2) {
            return this.compare(object1, object2) == 0;
        }
    }
}

