/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.search;

import com.sas.services.information.FilterComponent;
import com.sas.services.information.search.RB;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.information.search.SearchOperator;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.ResourceBundle;

public class ObjectNameFilter
implements SearchFilter,
Serializable {
    private static final long serialVersionUID = 968015756127016566L;
    protected static final String METADATA_NAME = "Name";
    protected static final String METADATA_DESC = "Desc";
    protected String _name = null;
    protected boolean _includeDescription = false;
    protected SearchOperator _searchOperator = null;
    protected String _filterDescription = null;

    public ObjectNameFilter(String name, boolean includeDescription) {
        this(name, includeDescription, ObjectNameFilter.getDefaultOperator());
    }

    public ObjectNameFilter(String name, boolean includeDescription, SearchOperator searchOperator) {
        this._name = name;
        this._includeDescription = includeDescription;
        this._searchOperator = searchOperator;
        this.setOperatorDetails(this._searchOperator);
    }

    public static SearchOperator getDefaultOperator() {
        return SearchOperator.CONTAINS;
    }

    @Override
    public String getFilterType() {
        return RB.getStringResource("ObjectNameFilter.FilterName.txt");
    }

    @Override
    public String getFilterDescription() {
        return this._filterDescription;
    }

    public String getName() {
        return this._name;
    }

    public boolean isIncludingDescription() {
        return this._includeDescription;
    }

    public SearchOperator getSearchOperator() {
        return this._searchOperator;
    }

    @Override
    public FilterComponent getFilterComponent() {
        FilterComponent comp = new FilterComponent();
        comp.setAggregation(1);
        int relation = this._searchOperator == null ? ObjectNameFilter.getDefaultOperator().getFilterOperator() : this._searchOperator.getFilterOperator();
        comp.addComponent(new FilterComponent(METADATA_NAME, relation, this._name));
        if (this.isIncludingDescription()) {
            comp.addComponent(new FilterComponent(METADATA_DESC, 1, this._name));
        }
        return comp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof ObjectNameFilter) {
            ObjectNameFilter filter = (ObjectNameFilter)obj;
            return this._name != null && this._name.equals(filter.getName()) && this._searchOperator == filter.getSearchOperator() && this._includeDescription == filter.isIncludingDescription();
        }
        return false;
    }

    private void setOperatorDetails(SearchOperator searchOperator) {
        this._filterDescription = searchOperator.equals((Object)SearchOperator.EQUALS) ? Message.format((ResourceBundle)RB.getResources(), (String)"ObjectNameFilter.FilterDesc2.fmt.txt", (Object)this._name) : (searchOperator.equals((Object)SearchOperator.STARTSWITH) ? Message.format((ResourceBundle)RB.getResources(), (String)"ObjectNameFilter.FilterDesc3.fmt.txt", (Object)this._name) : Message.format((ResourceBundle)RB.getResources(), (String)"ObjectNameFilter.FilterDesc1.fmt.txt", (Object)this._name));
    }
}

