/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.search;

import com.sas.services.information.AssociationPathComponent;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.search.RB;
import com.sas.services.information.search.SearchFilter;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.Map;
import java.util.ResourceBundle;

public class ExtendedAttributesFilter
implements SearchFilter,
Serializable {
    private static final long serialVersionUID = 7687799639921115213L;
    protected static final String EXTENSIONS_ASSOCIATION_NAME = "Extensions";
    protected static final String EXTENSIONS_ASSOCIATION_TYPE = "Extension";
    protected static final String ATTRIBUTE_VALUE = "Value";
    protected static final String ATTRIBUTE_NAME = "Name";
    protected Map<String, String> _extensions = null;

    public ExtendedAttributesFilter(Map<String, String> extensions) {
        this._extensions = extensions;
    }

    @Override
    public String getFilterType() {
        return RB.getStringResource("ExtendedAttributesFilter.FilterName.txt");
    }

    @Override
    public String getFilterDescription() {
        if (this._extensions != null && this._extensions.size() > 0) {
            return Message.format((ResourceBundle)RB.getResources(), (String)"ExtendedAttributesFilter.FilterDesc.fmt.txt", (Object)this.getExtensionsToDisplay());
        }
        return null;
    }

    private String getExtensionsToDisplay() {
        String sep = RB.getStringResource("Common.Separator.txt");
        StringBuilder sb = new StringBuilder();
        if (this._extensions != null) {
            for (String extension : this._extensions.keySet()) {
                if (sb.length() > 0) {
                    sb.append(sep);
                }
                sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ExtendedAttributesFilter.Name.fmt.txt", (Object)extension));
                String value = this._extensions.get(extension);
                if (value == null) continue;
                sb.append(" ");
                sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ExtendedAttributesFilter.Value.fmt.txt", (Object)value));
            }
        }
        if (sb.length() == 0) {
            sb.append(RB.getStringResource("Common.NoFilters.txt"));
        }
        return sb.toString();
    }

    public Map<String, String> getExtendedAttributes() {
        return this._extensions;
    }

    @Override
    public FilterComponent getFilterComponent() {
        if (this._extensions == null || this._extensions.isEmpty()) {
            return null;
        }
        FilterComponent comp = new FilterComponent();
        AssociationPathComponent ac1 = new AssociationPathComponent();
        ac1.setAssociationPath(EXTENSIONS_ASSOCIATION_NAME, EXTENSIONS_ASSOCIATION_TYPE);
        FilterComponent attrComp = new FilterComponent();
        attrComp.setAggregation(1);
        ac1.setAttributeCriteria(attrComp);
        for (String name : this._extensions.keySet()) {
            FilterComponent extensionComp = new FilterComponent();
            extensionComp.setAggregation(0);
            extensionComp.addComponent(new FilterComponent(ATTRIBUTE_NAME, 1, name));
            String value = this._extensions.get(name);
            if (value != null && value.length() > 0) {
                extensionComp.addComponent(new FilterComponent(ATTRIBUTE_VALUE, 1, value));
            }
            attrComp.addComponent(extensionComp);
        }
        comp.addAssociationPathComponent(ac1);
        return comp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof ExtendedAttributesFilter) {
            ExtendedAttributesFilter filter = (ExtendedAttributesFilter)obj;
            return this.extensionsEqual(this._extensions, filter.getExtendedAttributes());
        }
        return false;
    }

    private boolean extensionsEqual(Map<String, String> extensions1, Map<String, String> extensions2) {
        if (extensions1 == null && extensions2 == null) {
            return true;
        }
        if (extensions1 == null && extensions2 != null || extensions1 != null && extensions2 == null) {
            return false;
        }
        if (extensions1.size() != extensions2.size()) {
            return false;
        }
        try {
            for (String name : extensions1.keySet()) {
                if (!extensions2.containsKey(name)) continue;
                String value1 = extensions1.get(name);
                String value2 = extensions2.get(name);
                if (value1 == null || value2 == null || value1.equalsIgnoreCase(value2)) continue;
                return false;
            }
        }
        catch (Exception re) {
            return false;
        }
        return true;
    }
}

