/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.sasfolders;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.sasfolders.FolderNode;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.services.information.sasfolders.UserHomeFolderNotFoundException;
import java.rmi.RemoteException;

public class UsersFolderNode
extends FolderNode {
    public UsersFolderNode(UserFolderType folderType, ServerInterface server) throws ServiceException, RemoteException {
        super(UsersFolderNode.getHomeFolder(folderType, server));
    }

    private static BrowseMetadataInterface getHomeFolder(UserFolderType folderType, ServerInterface server) throws ServiceException, RemoteException {
        Filter filter = new Filter();
        filter.setOMRFlags(Integer.MIN_VALUE);
        FolderInterface myFolder = server.getHomeFolder(null, folderType, filter);
        if (myFolder == null) {
            throw new UserHomeFolderNotFoundException();
        }
        Filter browseFilter = new Filter();
        String template = "<Templates><Tree Name=\"\" PublicType=\"\" UsageVersion=\"\" Desc=\"\" MetadataCreated=\"\" MetadataUpdated=\"\"/></Templates>";
        browseFilter.setOMRTemplate(template);
        return server.browseFetch(myFolder.getEntityKey(), browseFilter);
    }

    @Override
    public PathUrl getPathUrl() throws ServiceException, RemoteException {
        if (this._path != null) {
            return this._path;
        }
        MetadataInterface meta = SASFoldersUtil.getSmartObject(this._server, this);
        if (meta == null) {
            return null;
        }
        this._path = meta.getPathUrl();
        return this._path;
    }
}

