/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.impl.PropertyImpl;
import com.sas.services.ServiceException;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.servers.AbstractConnectionBuilder;
import com.sas.services.information.metadata.servers.ServerBuilder;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public final class HadoopServerBuilder
extends ServerBuilder<ServerComponentInterface, ServerComponent, HadoopServerBuilder> {
    private static final double USAGE_VERSION = 1000000.0;
    private List<Connection> connections = new ArrayList<Connection>();

    public static HadoopServerBuilder builder() {
        return new HadoopServerBuilder();
    }

    private HadoopServerBuilder() {
        super(ServerComponent.class, "Server.Hadoop", 1000000.0, "HADOOP", "HADOOP");
        this.serviceType = "DBMS Server";
        this.prototypeName = "Server.Hadoop.Prototype.Name.xmlKey.txt";
    }

    public Connection connection() {
        Connection connection = (Connection)new Connection().buildName(this.name, this.connections.size() + 1);
        this.connections.add(connection);
        return connection;
    }

    @Override
    public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
        if (this.connections.isEmpty()) {
            throw new IllegalStateException("No connection is defined.");
        }
        super.validate(user);
        for (Connection connection : this.connections) {
            connection.validate(user);
        }
        Connection.checkForDuplicateNames(this.connections);
    }

    @Override
    protected void createObject() throws RemoteException, MdException, ServiceException {
        super.createObject();
        for (Connection connection : this.connections) {
            connection.buildAndConnect(this.user, (DeployedComponent)this.built);
        }
    }

    public final class Connection
    extends AbstractConnectionBuilder<SASClientConnectionInterface, SASClientConnection, Connection> {
        public static final String INSTALL = "INSTALL";
        public static final String SERVER = "SERVER";
        public static final String DATABASE = "DATABASE";
        public static final String CONFIGURATIONXML = "ConfigurationXML";
        public static final String DFSHTTPADDRESS = "DFSHttpAddress";
        public static final String DFSSECONDARYHTTPADDRESS = "DFSSecondaryHttpAddress";
        public static final String JOBTRACKERHTTPADDRESS = "JobTrackerHttpAddress";
        private int port;

        private Connection() {
            super(SASClientConnection.class, null, 0.0, "HadoopProtocol", "TCP");
            this.port = 0;
            this.prototypeName = "Connection.Hadoop.Name.xmlKey.txt";
        }

        public Connection port(int port) {
            this.port = port;
            return this;
        }

        public Connection server(String server) {
            this.option(SERVER, server);
            HadoopServerBuilder.this.associatedMachine(server);
            return this;
        }

        @Override
        protected void loadPrototypeProperties() throws RemoteException, MdException {
            super.loadPrototypeProperties();
            PropertyImpl property = new PropertyImpl();
            property.setName("Connection.Hadoop.Property.Configuration.Name.xmlKey.txt");
            property.setIsRequired(1);
            property.setIsUpdateable(1);
            property.setIsVisible(1);
            property.setPropertyName(CONFIGURATIONXML);
            property.setSQLType(12);
            this.prototypeProperties.put(property.getPropertyName().toUpperCase(), property);
            property = new PropertyImpl();
            property.setName("Connection.Hadoop.Property.DFSViewer.Name.xmlKey.txt");
            property.setIsUpdateable(1);
            property.setIsVisible(1);
            property.setPropertyName(DFSHTTPADDRESS);
            property.setPropertyRole("hadoopcfg:dfs.http.address");
            property.setSQLType(12);
            this.prototypeProperties.put(property.getPropertyName().toUpperCase(), property);
            property = new PropertyImpl();
            property.setName("Connection.Hadoop.Property.SecDFSViewer.Name.xmlKey.txt");
            property.setIsUpdateable(1);
            property.setIsVisible(1);
            property.setPropertyName(DFSSECONDARYHTTPADDRESS);
            property.setPropertyRole("hadoopcfg:dfs.secondary.http.address");
            property.setSQLType(12);
            this.prototypeProperties.put(property.getPropertyName().toUpperCase(), property);
            property = new PropertyImpl();
            property.setName("Connection.Hadoop.Property.JobTracker.Name.xmlKey.txt");
            property.setIsUpdateable(1);
            property.setIsVisible(1);
            property.setPropertyName(JOBTRACKERHTTPADDRESS);
            property.setPropertyRole("hadoopcfg:mapred.job.tracker.http.address");
            property.setSQLType(12);
            this.prototypeProperties.put(property.getPropertyName().toUpperCase(), property);
        }

        public HadoopServerBuilder end() {
            return HadoopServerBuilder.this;
        }

        @Override
        public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
            super.validate(user);
            if (!this.options.containsKey(SERVER)) {
                throw new IllegalStateException("SERVER option must be specified");
            }
        }

        @Override
        protected void createObject() throws RemoteException, MdException, ServiceException {
            super.createObject();
            ((SASClientConnection)this.built).setPort(this.port);
            PropertySet advancedProps = this.createMetadata("AdvancedProperties", PropertySet.class);
            advancedProps.setPropertySetName("AdvancedProperties");
            advancedProps.setOwningObject((Root)this.built);
            AssociationList properties = ((SASClientConnection)this.built).getProperties();
            ArrayList<Property> propertiesToMove = new ArrayList<Property>();
            for (Property property : properties) {
                String propName = property.getPropertyName();
                if (!propName.equalsIgnoreCase(CONFIGURATIONXML) && !propName.equalsIgnoreCase(DFSHTTPADDRESS) && !propName.equalsIgnoreCase(DFSSECONDARYHTTPADDRESS) && !propName.equalsIgnoreCase(JOBTRACKERHTTPADDRESS)) continue;
                propertiesToMove.add(property);
            }
            for (Property property : propertiesToMove) {
                property.setAssociatedObject(null);
                property.setAssociatedPropertySet(advancedProps);
            }
        }
    }
}

