/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.prompt;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AbstractPrompt;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Prompt;
import com.sas.metadata.remote.PromptGroup;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.PromptDefinitionEnum;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupEnum;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.shared.SharedPromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.prompt.AbstractPromptImpl;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.metadata.prompt.MetadataDescriptorResolver;
import com.sas.services.information.metadata.prompt.OMRPromptDefinitionInterface;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.information.metadata.prompt.RB;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContext;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.TransformerFactoryFactory;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import com.sas.util.ValidateArg;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope
public final class PromptsPersistUtil {
    private static final String SESSIONCONTEXT = "sessionContext";
    static final String USERCONTEXT = "userContext";
    private static final String ROOT = "root";
    private static final String NAME = "name";
    private static final String UNNAMED = "unnamed";
    private static final String FOLDER = "folder";
    private static final String RB_KEY = "PromptsPersistUtil.";
    static final String SBIPURL = "sbipUrl";
    static final String DEFINITION = "definition";
    private static final String REPOSITORY = "repository";
    private static final String wrongType = "PromptsPersistUtil.wrongObjectType.fmt.log";

    private PromptsPersistUtil() {
    }

    public static PromptDefinitionInterface getDefinitionFromFolder(PathUrl sbipUrl, UserContextInterface userContext) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        ValidateArg.notNull((Object)sbipUrl, (String)SBIPURL);
        PromptDefinitionInterface definition = null;
        if (!"Prompt".equals(sbipUrl.getType())) {
            throw new ServiceException(Message.format((String)RB.getStringResource(wrongType), (Object)"Prompt", (Object)sbipUrl));
        }
        CommonLoggerInterface logger = PromptsPersistUtil.getLogger();
        InformationServiceInterface infoService = UserContext.getInformationService();
        OMRPromptDefinitionInterface prompt = (OMRPromptDefinitionInterface)infoService.getObjectByPath(userContext, sbipUrl);
        if (null == prompt) {
            String msg = new MessageFormat(RB.getStringResource("PromptsPersistUtil.definitionNotFound.fmt.log")).format(new Object[]{sbipUrl.getName()});
            logger.error(msg);
            logger.error("SBIP URL: " + sbipUrl.toString());
            throw new ServiceException(msg);
        }
        logger.debug("Found definition named:", sbipUrl.getName());
        definition = prompt.getPromptDefinition();
        return definition;
    }

    static PersistenceInterface newPromptObject(LoggerFactoryInterface logFactory, String xml, UserContextInterface userContext, PromptsReadingContext readingContext) throws SAXException, IOException, ParserConfigurationException {
        SessionContextInterface session;
        BufferedReader bis = new BufferedReader(new StringReader(xml));
        PromptsReadingContext myReadingContext = null;
        myReadingContext = null == readingContext ? PersistenceFactoryWithServices.newReadingContext(userContext) : readingContext;
        PersistenceInterface retVal = PromptUtil.newObjectFromXML((Reader)bis, (LoggerFactoryInterface)new Log4JFactory2(), (PromptsReadingContext)myReadingContext);
        if (null == readingContext) {
            myReadingContext.destroy();
        }
        if (null != (session = userContext.getSessionContext())) {
            CommonLoggerInterface logger = PromptsPersistUtil.getLogger();
            if (myReadingContext.getMissingResources().isEmpty()) {
                session.removeAttribute("com.sas.util.xmlpersist.MISSING_RESOURCES");
                logger.debug("newPromptObject(), no missing resources detected.");
            } else {
                Map map = myReadingContext.getMissingResources();
                session.setAttribute("com.sas.util.xmlpersist.MISSING_RESOURCES", Collections.unmodifiableMap(map));
                logger.info(RB.getStringResource("PromptsPersistUtil.missingResourcesDetected.log"));
            }
        }
        return retVal;
    }

    static void resolveDescriptors(BaseOMRPromptInterface prompt, List list, UserContextInterface userContext, CommonLoggerInterface logger) throws RemoteException, ServiceException {
        logger.debug("resolveDescriptors() Number of metadata descriptors is:", Integer.toString(list.size()));
        prompt.removeAllValueSources();
        if (!list.isEmpty()) {
            for (MetadataDescriptor descriptor : list) {
                logger.debug("Descriptor contains a value source.");
                MetadataInterface out = MetadataDescriptorResolver.resolve(descriptor, userContext);
                if (null == out) continue;
                if (out.isObjectAlive()) {
                    prompt.addValueSource(out);
                    logger.debug("resolveDescriptors(), added value source named:", out.getName());
                    continue;
                }
                logger.warn(Message.format((String)RB.getStringResource("PromptsPersistUtil.objectNotFound.fmt.log"), (Object)out.getName()));
            }
        }
    }

    static void resolveDescriptorsAsJOMAObjects(AbstractPrompt prompt, List list, UserContextInterface userContext, CommonLoggerInterface logger, MdFactory mdFactory) throws RemoteException, ServiceException, MdException {
        HashMap<String, String> retVal = new HashMap<String, String>();
        logger.debug("resolveDescriptorsAsJOMAObjects() is running.");
        prompt.getReferencedPrompts().clear();
        prompt.getValueSources().clear();
        logger.debug("Number of metadata descriptors is:", Integer.toString(list.size()));
        if (!list.isEmpty()) {
            for (MetadataDescriptor descriptor : list) {
                MetadataInterface out = MetadataDescriptorResolver.resolve(descriptor, userContext);
                if (null == out) continue;
                CMetadata cMeta = (CMetadata)out.getRepositoryEntity();
                String key = out.getReposId();
                retVal.put(key, cMeta.getCMetadataType());
                logger.debug("Found metadata obj named:", out.getName());
                logger.debug("Repos id is:", key);
                logger.debug("joma type is:", cMeta.getCMetadataType());
            }
        }
        PromptsPersistUtil.linkResources(prompt, retVal, mdFactory, logger);
    }

    static void linkResources(AbstractPrompt prompt, Map map, MdFactory mdFactory, CommonLoggerInterface logger) throws MdException, RemoteException {
        logger.debug("linkResources() for private prompts to valueSources and public prompts.");
        MdObjectStore objectStore = (MdObjectStore)prompt.getObjectStore();
        if (!map.isEmpty()) {
            List objectList = mdFactory.getOMIUtil().getMetadata((MdStore)objectStore, map, null, 8);
            for (CMetadata resource : objectList) {
                if (null == resource) continue;
                if (resource instanceof AbstractPrompt) {
                    prompt.getReferencedPrompts().add((Object)resource);
                    continue;
                }
                PromptsPersistUtil.addValueSource(prompt, resource, mdFactory, logger);
            }
        }
    }

    public static PromptGroup setPromptGroupOnOMRObject(PromptGroupInterface group, Root root, SessionContextInterface sessionContext, MdFactory mdFactory) throws MdException, RemoteException {
        ValidateArg.notNull((Object)root, (String)ROOT);
        ValidateArg.notNull((Object)sessionContext, (String)SESSIONCONTEXT);
        ValidateArg.notNull((Object)group, (String)"group");
        CommonLoggerInterface logger = PromptsPersistUtil.getLogger();
        String name = group.getPromptGroupLabel(Locale.getDefault());
        if (null == name || "".equals(name)) {
            name = UNNAMED;
        }
        PromptGroup omrGroup = null;
        AbstractPrompt abstractPrompt = null;
        if (!root.getPrompts().isEmpty()) {
            abstractPrompt = (AbstractPrompt)root.getPrompts().get(0);
        }
        if (null != abstractPrompt) {
            if (abstractPrompt instanceof Prompt) {
                PromptsPersistUtil.delete(abstractPrompt);
            } else {
                omrGroup = (PromptGroup)abstractPrompt;
                omrGroup.setName(name);
                logger.debug("found an existing PromptGroup on the supplied Root object");
            }
        }
        if (null == omrGroup) {
            omrGroup = (PromptGroup)mdFactory.createComplexMetadataObject((MdObjectStore)root.getObjectStore(), null, name, "PromptGroup", root.getRepositoryID(), null);
            omrGroup.setPublicType("Embedded:PromptGroup");
            omrGroup.setUsageVersion(new UsageVersion(1, 0).encode());
            logger.debug("Creating a new PromptGroup for the supplied Root object");
        }
        PromptsPersistUtil.updatePromptGroupWithGroup(omrGroup, group, sessionContext, mdFactory);
        root.getPrompts().add(0, (Object)omrGroup);
        logger.debug("Added/replaced OMR prompt group to Root named:", root.getName());
        return omrGroup;
    }

    public static void updatePromptGroupWithGroup(PromptGroup omrGroup, PromptGroupInterface group, SessionContextInterface sessionContext, MdFactory mdFactory) throws RemoteException, MdException {
        Log4JFactory2 logFactory = new Log4JFactory2();
        CommonLoggerInterface logger = PromptsPersistUtil.getLogger();
        PromptGroupEnum e = PromptGroupEnum.valueOf((String)group.getDefinitionElementName());
        int num = -1;
        if (null != e) {
            num = e.getOrdinal();
            omrGroup.setGroupType(num);
            logger.debug("Creating OMR prompt of type:", e.toString());
        }
        if (num == -1) {
            logger.warn("No PromptGroupEnum exists for {0}", group.getDefinitionElementName());
        }
        try {
            Map map = PromptsPersistUtil.getXML((PersistenceInterface)group, (LoggerFactoryInterface)logFactory, null);
            String xml = (String)map.get("XML");
            PromptsPersistUtil.resolveDescriptorsAsJOMAObjects((AbstractPrompt)omrGroup, (List)map.get("descriptors"), sessionContext.getUserContext(), logger, mdFactory);
            omrGroup.setGroupInfo(xml);
        }
        catch (RemoteException e1) {
            throw new MdException((Throwable)e1);
        }
        catch (ServiceException e1) {
            throw new MdException((Throwable)((Object)e1));
        }
        catch (IllegalStateException e1) {
            throw new MdException((Throwable)e1);
        }
    }

    public static PromptGroupInterface getPromptGroupFromOMRObject(Root root, SessionContextInterface sessionContext) throws MdException, RemoteException {
        PromptGroupInterface retVal = null;
        ValidateArg.notNull((Object)root, (String)ROOT);
        ValidateArg.notNull((Object)sessionContext, (String)SESSIONCONTEXT);
        CommonLoggerInterface logger = PromptsPersistUtil.getLogger();
        AssociationList list = root.getPrompts();
        if (!list.isEmpty()) {
            logger.debug("Found an item in prompts list");
            AbstractPrompt out = (AbstractPrompt)list.get(0);
            if (out instanceof PromptGroup) {
                PromptGroup omrGroup = (PromptGroup)out;
                retVal = PromptsPersistUtil.getPromptGroupFromPromptGroupObject(omrGroup, sessionContext);
            }
        } else {
            logger.info("getPromptGroupFromOMRObject()...");
            logger.info(RB.getStringResource("PromptsPersistUtil.groupNotFoundInList.log"));
        }
        return retVal;
    }

    public static PromptGroupInterface getPromptGroupFromPromptGroupObject(PromptGroup omrGroup, SessionContextInterface sessionContext) throws MdException, RemoteException {
        PromptGroupInterface promptGroup = null;
        CommonLoggerInterface logger = PromptsPersistUtil.getLogger();
        String xml = omrGroup.getGroupInfo();
        try {
            UserContextInterface userContext = sessionContext.getUserContext();
            PromptsReadingContext rc = PromptsPersistUtil.getReadingContextWithServer((Root)omrGroup, userContext, logger);
            promptGroup = (PromptGroupInterface)PromptsPersistUtil.newPromptObject(PersistenceFactoryWithServices.newLoggerFactory(sessionContext), xml, userContext, rc);
            rc.destroy();
        }
        catch (IllegalStateException e) {
            throw new MdException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
        catch (SAXException e) {
            throw new MdException((Throwable)e);
        }
        catch (IOException e) {
            throw new MdException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MdException((Throwable)e);
        }
        if (null != promptGroup) {
            logger.debug("getPromptGroupFromPromptGroupObject()- Got a real PromptGroupInterface to return.");
        }
        return promptGroup;
    }

    public static Prompt setPromptDefinitionOnOMRObject(PromptDefinitionInterface definition, Root root, SessionContextInterface sessionContext, MdFactory mdFactory) throws MdException, RemoteException {
        ValidateArg.notNull((Object)root, (String)ROOT);
        ValidateArg.notNull((Object)sessionContext, (String)SESSIONCONTEXT);
        ValidateArg.notNull((Object)definition, (String)DEFINITION);
        CommonLoggerInterface logger = PromptsPersistUtil.getLogger();
        String name = definition.getPromptName();
        if (null == name || "".equals(name)) {
            name = UNNAMED;
        }
        Prompt omrDefinition = null;
        AbstractPrompt abstractPrompt = null;
        if (!root.getPrompts().isEmpty()) {
            abstractPrompt = (AbstractPrompt)root.getPrompts().get(0);
        }
        if (null != abstractPrompt) {
            if (abstractPrompt instanceof PromptGroup) {
                PromptsPersistUtil.delete(abstractPrompt);
            } else {
                omrDefinition = (Prompt)abstractPrompt;
                omrDefinition.setName(name);
                logger.debug("found an existing Prompt on the supplied Root object");
            }
        }
        if (null == omrDefinition) {
            omrDefinition = (Prompt)mdFactory.createComplexMetadataObject((MdObjectStore)root.getObjectStore(), null, name, "Prompt", root.getRepositoryID(), null);
            omrDefinition.setPublicType("Embedded:Prompt");
            omrDefinition.setUsageVersion(new UsageVersion(1, 0).encode());
            logger.debug("Creating a new Prompt for the supplied Root object");
        }
        PromptsPersistUtil.updatePromptWithDefinition(omrDefinition, definition, sessionContext, mdFactory);
        root.getPrompts().add(0, (Object)omrDefinition);
        logger.debug("Added/replaced OMR prompt to Root named:", root.getName());
        return omrDefinition;
    }

    public static void updatePromptWithDefinition(Prompt omrDefinition, PromptDefinitionInterface definition, SessionContextInterface sessionContext, MdFactory mdFactory) throws RemoteException, MdException {
        Log4JFactory2 logFactory = new Log4JFactory2();
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)PromptsPersistUtil.class.getName(), (LoggerFactoryInterface)logFactory);
        try {
            Map map = PromptsPersistUtil.getXML((PersistenceInterface)definition, (LoggerFactoryInterface)logFactory, null);
            String xml = (String)map.get("XML");
            PromptsPersistUtil.resolveDescriptorsAsJOMAObjects((AbstractPrompt)omrDefinition, (List)map.get("descriptors"), sessionContext.getUserContext(), logger, mdFactory);
            omrDefinition.setPromptInfo(xml);
            omrDefinition.setUsageVersion(new UsageVersion(1, 0).encode());
        }
        catch (RemoteException e1) {
            throw new MdException((Throwable)e1);
        }
        catch (ServiceException e1) {
            throw new MdException((Throwable)((Object)e1));
        }
        catch (IllegalStateException e1) {
            throw new MdException((Throwable)e1);
        }
    }

    public static PromptDefinitionInterface getPromptDefinitionFromSmartObject(OMRPromptDefinitionInterface prompt, PromptsReadingContext readingContext, SessionContextInterface sessionContext) throws RemoteException, ServiceException {
        PromptDefinitionInterface retVal = null;
        ValidateArg.notNull((Object)prompt, (String)"prompt");
        ValidateArg.notNull((Object)sessionContext, (String)SESSIONCONTEXT);
        CommonLoggerInterface logger = PromptsPersistUtil.getLogger();
        logger.debug("getPromptDefinitionFromSmartObject()- supplied prompt is:", prompt.getName());
        String xml = prompt.getPromptInfo();
        UserContextInterface userContext = sessionContext.getUserContext();
        try {
            retVal = (PromptDefinitionInterface)PromptsPersistUtil.newPromptObject(PersistenceFactoryWithServices.newLoggerFactory(sessionContext), xml, userContext, readingContext);
        }
        catch (SAXException e) {
            throw new ServiceException(e);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException(e);
        }
        if (null != retVal) {
            logger.debug("getPromptDefinitionFromSmartObject()- Returning a PromptDefinitionInterface named:", retVal.getPromptName());
        }
        return retVal;
    }

    public static PromptDefinitionInterface getPromptDefinitionFromOMRObject(Root root, SessionContextInterface sessionContext) throws MdException, RemoteException {
        PromptDefinitionInterface retVal = null;
        ValidateArg.notNull((Object)root, (String)ROOT);
        ValidateArg.notNull((Object)sessionContext, (String)SESSIONCONTEXT);
        CommonLoggerInterface logger = PromptsPersistUtil.getLogger();
        AssociationList list = root.getPrompts();
        if (!list.isEmpty()) {
            logger.debug("Found an item in prompts list");
            AbstractPrompt out = (AbstractPrompt)list.get(0);
            if (out instanceof Prompt) {
                retVal = PromptsPersistUtil.getPromptDefinitionFromPromptObject((Prompt)out, sessionContext);
            }
        } else {
            logger.info("getPromptDefinitionFromOMRObject()...");
            logger.info(RB.getStringResource("PromptsPersistUtil.definitionNotFoundInList.log"));
        }
        return retVal;
    }

    public static PromptDefinitionInterface getPromptDefinitionFromPromptObject(Prompt omrDefn, SessionContextInterface sessionContext) throws MdException, RemoteException {
        PromptDefinitionInterface retVal = null;
        CommonLoggerInterface logger = PromptsPersistUtil.getLogger();
        if (omrDefn != null) {
            String xml = omrDefn.getPromptInfo();
            try {
                UserContextInterface userContext = sessionContext.getUserContext();
                PromptsReadingContext rc = PromptsPersistUtil.getReadingContextWithServer((Root)omrDefn, userContext, logger);
                retVal = (PromptDefinitionInterface)PromptsPersistUtil.newPromptObject(PersistenceFactoryWithServices.newLoggerFactory(sessionContext), xml, userContext, rc);
                rc.destroy();
            }
            catch (IllegalStateException e) {
                throw new MdException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new MdException((Throwable)e);
            }
            catch (SAXException e) {
                throw new MdException((Throwable)e);
            }
            catch (IOException e) {
                throw new MdException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new MdException((Throwable)e);
            }
            if (null != retVal) {
                logger.debug("getPromptDefinitionFromPromptObject()- Returning a real PromptDefinitionInterface.");
            }
        }
        return retVal;
    }

    private static PromptsReadingContext getReadingContextWithServer(Root root2, UserContextInterface userContext2, CommonLoggerInterface logger) throws RemoteException, MdException {
        PromptsReadingContext retVal = null;
        String reposId = "A0000001." + root2.getRepositoryID();
        List serverList = userContext2.getServers();
        ServerInterface server = null;
        for (ServerInterface next : serverList) {
            String reposName = next.getRepositoryName(reposId);
            if (reposName == null) continue;
            server = next;
            break;
        }
        if (server == null) {
            String msg = Message.format((String)RB.getStringResource("PromptsPersistUtil.serverNotFound.fmt.log"), (Object)reposId);
            logger.warn(msg, reposId);
            throw new MdException(msg);
        }
        retVal = PersistenceFactoryWithServices.newReadingContext(userContext2);
        retVal.setServer(server);
        logger.debug("found a server matching this reposId:", reposId);
        return retVal;
    }

    public static void deleteAllPromptsFromOMR(Root root, SessionContextInterface sessionContext) throws MdException, RemoteException {
        ValidateArg.notNull((Object)root, (String)ROOT);
        ValidateArg.notNull((Object)sessionContext, (String)SESSIONCONTEXT);
        CommonLoggerInterface logger = PromptsPersistUtil.getLogger();
        logger.debug("deleteAllPromptsFromOMR()");
        if (!root.getPrompts().isEmpty()) {
            ArrayList<AbstractPrompt> objList = new ArrayList<AbstractPrompt>();
            AssociationList list = root.getPrompts();
            for (AbstractPrompt element : list) {
                objList.add(element);
            }
            for (Root root2 : objList) {
                logger.debug("deleting abstract prompt:", root2.getName());
                root2.delete();
            }
            list.clear();
        } else {
            logger.debug("No prompts found in this Root object.");
        }
    }

    public static OMRPromptDefinitionInterface saveDefinitionToFolder(PromptDefinitionInterface definition, UserContextInterface userContext, String sbipUrl) throws RemoteException, ServiceException {
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        ValidateArg.notNull((Object)sbipUrl, (String)SBIPURL);
        PathUrl pdUrl = new PathUrl(sbipUrl);
        if (!"Prompt".equals(pdUrl.getType())) {
            throw new ServiceException(Message.format((String)RB.getStringResource(wrongType), (Object)"Prompt", (Object)sbipUrl));
        }
        PromptsPersistUtil.checkInstance(definition);
        InformationServiceInterface infoService = UserContext.getInformationService();
        OMRPromptDefinitionInterface prompt = (OMRPromptDefinitionInterface)infoService.getObjectByPath(userContext, pdUrl);
        FolderInterface folder = null;
        if (null == prompt) {
            folder = PromptsPersistUtil.getFolderFromInfoService(sbipUrl, infoService, userContext);
        }
        prompt = PromptsPersistUtil.saveDefinition(definition, userContext, folder, pdUrl.getName(), null, prompt, null);
        prompt.update();
        return prompt;
    }

    public static OMRPromptDefinitionInterface saveDefinitionToFolder(PromptDefinitionInterface definition, UserContextInterface userContext, PathUrl sbipUrl) throws RemoteException, ServiceException {
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        ValidateArg.notNull((Object)sbipUrl, (String)SBIPURL);
        if (!"Prompt".equals(sbipUrl.getType())) {
            throw new ServiceException(Message.format((String)RB.getStringResource(wrongType), (Object)"Prompt", (Object)sbipUrl));
        }
        PromptsPersistUtil.checkInstance(definition);
        InformationServiceInterface infoService = UserContext.getInformationService();
        OMRPromptDefinitionInterface prompt = (OMRPromptDefinitionInterface)infoService.getObjectByPath(userContext, sbipUrl);
        FolderInterface folder = null;
        if (null == prompt) {
            folder = PromptsPersistUtil.getFolderFromInfoService(sbipUrl.toString(), infoService, userContext);
        }
        prompt = PromptsPersistUtil.saveDefinition(definition, userContext, folder, sbipUrl.getName(), null, prompt, null);
        prompt.update();
        return prompt;
    }

    public static OMRPromptDefinitionInterface saveDefinitionToFolder(PromptDefinitionInterface definition, UserContextInterface userContext, FolderInterface folder, String name) throws RemoteException, ServiceException {
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        ValidateArg.notNull((Object)name, (String)NAME);
        ValidateArg.notNull((Object)folder, (String)FOLDER);
        PromptsPersistUtil.checkInstance(definition);
        RepositoryInterface repos = folder.getRepository();
        PromptsPersistUtil.checkForNull(repos, "folder.getRepository()");
        OMRPromptDefinitionInterface prompt = (OMRPromptDefinitionInterface)folder.getItemByType(name, "Prompt");
        prompt = PromptsPersistUtil.saveDefinition(definition, userContext, folder, name, repos, prompt, null);
        prompt.update();
        return prompt;
    }

    private static OMRPromptDefinitionInterface saveDefinition(PromptDefinitionInterface definition, UserContextInterface userContext, FolderInterface folder, String name, RepositoryInterface repos, OMRPromptDefinitionInterface prompt, PromptsWritingContext writingContext) throws RemoteException, ServiceException {
        ValidateArg.notNull((Object)definition, (String)DEFINITION);
        CommonLoggerInterface logger = PromptsPersistUtil.getLogger();
        InformationServiceInterface infoService = UserContext.getInformationService();
        if (name == null || name.trim().length() == 0) {
            name = UNNAMED;
        }
        if (null == prompt) {
            logger.debug("saveDefinition()- Making a new definition smart object named:", name);
            if (null != folder) {
                logger.debug("make a new public prompt into path:", folder.getPath());
                if (null == repos) {
                    repos = folder.getRepository();
                    logger.debug("... in repository named:", repos.getISName());
                }
                prompt = (OMRPromptDefinitionInterface)infoService.newMetadataInFolder(folder, repos, "Prompt", name);
            } else if (null != repos) {
                logger.debug("Make a new private prompt in repository named:", repos.getISName());
                logger.debug("The new private prompt is named:", name);
                prompt = (OMRPromptDefinitionInterface)infoService.newMetadataInFolder(folder, repos, "Prompt", name);
            }
        } else {
            prompt.removeAllValueSources();
        }
        String xml = PromptsPersistUtil.convertJavaPrompt2SmartObject((PersistenceInterface)definition, null, prompt, userContext, writingContext);
        PromptDefinitionEnum e = PromptDefinitionEnum.valueOf((String)definition.getDefinitionElementName());
        int num = -1;
        if (null != e) {
            num = e.getOrdinal();
            prompt.setPromptType(num);
            logger.debug("Creating OMR prompt of type:", e.toString());
        }
        prompt.setPromptInfo(xml);
        if (prompt instanceof AbstractPromptImpl) {
            PromptsPersistUtil.setMicroVersion(definition.getVersion(), (AbstractPromptImpl)((Object)prompt));
        }
        logger.debug("Prompt entity URL is:", prompt.getEntityURL());
        return prompt;
    }

    private static void setMicroVersion(String version, AbstractPromptImpl prompt) {
        try {
            UsageVersion defUV = UsageVersion.parseVersion((String)version);
            int microVersion = defUV.getMajorVersion() * 10 + defUV.getMinorVersion();
            prompt.setMicroVersion(microVersion);
        }
        catch (ParseException e1) {
            PromptsPersistUtil.getLogger().error("setMicroVersion(): exception parsing a version string", (Throwable)e1);
        }
    }

    private static FolderInterface getFolderFromInfoService(String sbipUrl, InformationServiceInterface infoService, UserContextInterface userContext) throws ServiceException, RemoteException {
        String folderPath = sbipUrl.substring(0, sbipUrl.lastIndexOf(47)) + "(" + "Folder" + ")";
        PathUrl folderUrl = new PathUrl(folderPath);
        FolderInterface folder = (FolderInterface)infoService.getObjectByPath(userContext, folderUrl);
        if (null == folder) {
            throw new ServiceException("No folder was found at " + folderPath);
        }
        return folder;
    }

    private static String convertJavaPrompt2SmartObject(PersistenceInterface input, LoggerFactoryInterface logFactory, BaseOMRPromptInterface prompt, UserContextInterface userContext, PromptsWritingContext writingContext) throws ServiceException, RemoteException {
        Map map = PromptsPersistUtil.getXML(input, logFactory, writingContext);
        String retVal = (String)map.get("XML");
        PromptsPersistUtil.resolveDescriptors(prompt, (List)map.get("descriptors"), userContext, PromptsPersistUtil.getLogger());
        return retVal;
    }

    static Map getXML(PersistenceInterface input, LoggerFactoryInterface logFactory, PromptsWritingContext wc) throws ServiceException {
        DocumentBuilderFactory factory = TransformerFactoryFactory.newDocumentBuilderFactory();
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
            if (null == wc) {
                wc = PersistenceFactoryWithServices.newWritingContext((PersistenceInterface)input, (LoggerFactoryInterface)logFactory);
            }
            Element element = input.write((Node)doc, (IntegratedWritingContext)wc);
            PersistHelper.removeUnreferencedPersistenceIDs((Element)element, (PromptsWritingContext)wc);
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (BackingStoreException e) {
            throw new ServiceException(e, e.getMessage());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("XML", XmlUtil.documentToString((Document)doc));
        map.put("descriptors", wc.getMetadataDescriptors());
        return map;
    }

    public static boolean deletePromptFromFolder(PathUrl sbipUrl, UserContextInterface userContext) throws ServiceException, RemoteException {
        boolean retVal = false;
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        ValidateArg.notNull((Object)sbipUrl, (String)SBIPURL);
        CommonLoggerInterface logger = PromptsPersistUtil.getLogger();
        logger.debug("Attempting deletePromptFromFolder() for:", sbipUrl.toString());
        ServerInterface server = userContext.getServer(sbipUrl.getServer());
        PromptsPersistUtil.checkForNull(server, "serverInterface");
        BaseOMRPromptInterface o = (BaseOMRPromptInterface)server.getObjectByPath(sbipUrl);
        if (null != o) {
            o.delete();
            o.update();
            retVal = true;
            logger.debug("Deleted the prompt.");
        } else {
            logger.debug("server.getObjectByPath() returned null.");
        }
        if (!retVal) {
            logger.info(RB.getStringResource("PromptsPersistUtil.promptNotDeleted.log"));
            logger.info(sbipUrl.toString());
        }
        return retVal;
    }

    public static PromptGroupInterface getGroupFromFolder(PathUrl sbipUrl, UserContextInterface userContext) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        ValidateArg.notNull((Object)sbipUrl, (String)SBIPURL);
        PromptGroupInterface group = null;
        if (!"PromptGroup".equals(sbipUrl.getType())) {
            throw new ServiceException(Message.format((String)RB.getStringResource(wrongType), (Object)"PromptGroup", (Object)sbipUrl));
        }
        Log4JFactory2 logFactory = new Log4JFactory2();
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)PromptsPersistUtil.class.getName(), (LoggerFactoryInterface)logFactory);
        InformationServiceInterface infoService = UserContext.getInformationService();
        OMRPromptGroupInterface prompt = (OMRPromptGroupInterface)infoService.getObjectByPath(userContext, sbipUrl);
        if (null != prompt) {
            logger.debug("Found group named:", sbipUrl.getName());
            group = prompt.getPromptGroup();
            if (null != group) {
                logger.debug("Completed construction of group.");
            }
        } else {
            String msg = new MessageFormat(RB.getStringResource("PromptsPersistUtil.groupNotFound.fmt.log")).format(new Object[]{sbipUrl.getName()});
            logger.error(msg);
            logger.error("SBIP URL: " + sbipUrl.toString());
            throw new ServiceException(msg);
        }
        return group;
    }

    public static OMRPromptGroupInterface saveGroupToFolder(PromptGroupInterface group, UserContextInterface userContext, String sbipUrl) throws RemoteException, ServiceException {
        ValidateArg.notNull((Object)sbipUrl, (String)SBIPURL);
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        PathUrl pdUrl = new PathUrl(sbipUrl);
        if (!"PromptGroup".equals(pdUrl.getType())) {
            throw new ServiceException(Message.format((String)RB.getStringResource(wrongType), (Object)"PromptGroup", (Object)sbipUrl));
        }
        PromptsPersistUtil.checkInstance(group);
        InformationServiceInterface infoService = UserContext.getInformationService();
        OMRPromptGroupInterface prompt = (OMRPromptGroupInterface)infoService.getObjectByPath(userContext, pdUrl);
        FolderInterface folder = null;
        if (null == prompt) {
            folder = PromptsPersistUtil.getFolderFromInfoService(sbipUrl, infoService, userContext);
        }
        prompt = PromptsPersistUtil.saveGroup(group, userContext, folder, pdUrl.getName(), null, prompt, null);
        prompt.update();
        return prompt;
    }

    public static OMRPromptGroupInterface saveGroupToFolder(PromptGroupInterface group, UserContextInterface userContext, PathUrl sbipUrl) throws RemoteException, ServiceException {
        ValidateArg.notNull((Object)sbipUrl, (String)SBIPURL);
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        if (!"PromptGroup".equals(sbipUrl.getType())) {
            throw new ServiceException(Message.format((String)RB.getStringResource(wrongType), (Object)"PromptGroup", (Object)sbipUrl));
        }
        PromptsPersistUtil.checkInstance(group);
        InformationServiceInterface infoService = UserContext.getInformationService();
        OMRPromptGroupInterface prompt = (OMRPromptGroupInterface)infoService.getObjectByPath(userContext, sbipUrl);
        FolderInterface folder = null;
        if (null == prompt) {
            folder = PromptsPersistUtil.getFolderFromInfoService(sbipUrl.toString(), infoService, userContext);
        }
        prompt = PromptsPersistUtil.saveGroup(group, userContext, folder, sbipUrl.getName(), null, prompt, null);
        prompt.update();
        return prompt;
    }

    public static OMRPromptGroupInterface saveGroupToFolder(PromptGroupInterface group, UserContextInterface userContext, FolderInterface folder, String name) throws RemoteException, ServiceException {
        ValidateArg.notNull((Object)folder, (String)FOLDER);
        ValidateArg.notNull((Object)name, (String)NAME);
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        PromptsPersistUtil.checkInstance(group);
        RepositoryInterface repos = folder.getRepository();
        PromptsPersistUtil.checkForNull(repos, "folder.getRepository()");
        OMRPromptGroupInterface prompt = (OMRPromptGroupInterface)folder.getItemByType(name, "PromptGroup");
        prompt = PromptsPersistUtil.saveGroup(group, userContext, folder, name, repos, prompt, null);
        prompt.update();
        return prompt;
    }

    private static void checkInstance(Object object) throws ServiceException {
        if (object instanceof SharedPromptGroupInterface || object instanceof SharedPromptDefinitionInterface) {
            throw new ServiceException(RB.getStringResource("PromptsPersistUtil.noSavingSharedPrompts.log"));
        }
    }

    private static OMRPromptGroupInterface saveGroup(PromptGroupInterface group, UserContextInterface userContext, FolderInterface folder, String name, RepositoryInterface repos, OMRPromptGroupInterface prompt, PromptsWritingContext writingContext) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)group, (String)"group");
        Log4JFactory2 logFactory = new Log4JFactory2();
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)PromptsPersistUtil.class.getName(), (LoggerFactoryInterface)logFactory);
        if (name == null || name.trim().length() == 0) {
            name = UNNAMED;
        }
        InformationServiceInterface infoService = UserContext.getInformationService();
        if (null == prompt) {
            logger.debug("saveGroupToFolder() Making a new smart object named:", name);
            if (null != folder) {
                logger.debug("make a new public prompt group into path:", folder.getPath());
                if (null == repos) {
                    repos = folder.getRepository();
                    logger.debug("... in repository named:", repos.getISName());
                }
                prompt = (OMRPromptGroupInterface)infoService.newMetadataInFolder(folder, repos, "PromptGroup", name);
            } else if (null != repos) {
                logger.debug("Make a new private prompt group in repository named:", repos.getISName());
                logger.debug("The new private prompt group is named:", name);
                prompt = (OMRPromptGroupInterface)infoService.newMetadataInFolder(folder, repos, "PromptGroup", name);
            }
        } else {
            prompt.removeAllValueSources();
        }
        String xml = PromptsPersistUtil.convertJavaPrompt2SmartObject((PersistenceInterface)group, (LoggerFactoryInterface)logFactory, prompt, userContext, writingContext);
        PromptGroupEnum e = PromptGroupEnum.valueOf((String)group.getDefinitionElementName());
        int num = -1;
        if (null != e) {
            num = e.getOrdinal();
            prompt.setGroupType(num);
            logger.debug("Creating OMR prompt of type:", e.toString());
        }
        prompt.setGroupInfo(xml);
        if (prompt instanceof AbstractPromptImpl) {
            PromptsPersistUtil.setMicroVersion(group.getVersion(), (AbstractPromptImpl)((Object)prompt));
        }
        logger.debug("Prompt entity URL is:", prompt.getEntityURL());
        return prompt;
    }

    private static void checkForNull(Object input, String msg) throws ServiceException {
        if (null == input) {
            throw new ServiceException("An object required within a method was null. " + msg);
        }
    }

    private static void delete(AbstractPrompt prompt) throws MdException, RemoteException {
        prompt.getReferencedPrompts().clear();
        prompt.getPromptReferences().clear();
        prompt.getValueSources().clear();
        prompt.delete();
    }

    private static CommonLoggerInterface getLogger() {
        Log4JFactory2 logFactory = new Log4JFactory2();
        return LoggerRepository2.getLogger((String)PromptsPersistUtil.class.getName(), (LoggerFactoryInterface)logFactory);
    }

    static void addValueSource(AbstractPrompt abstractPrompt, CMetadata jomaObject, MdFactory mdFactory, CommonLoggerInterface logger) throws MdException, RemoteException {
        ClassifierMap map = null;
        logger.debug("running addValueSource()");
        Transformation out = abstractPrompt.getValueSource();
        if (null != out && out instanceof ClassifierMap) {
            map = (ClassifierMap)out;
        } else {
            MdObjectStore store = (MdObjectStore)abstractPrompt.getObjectStore();
            map = (ClassifierMap)mdFactory.createComplexMetadataObject(store, null, jomaObject.getName(), "ClassifierMap", abstractPrompt.getRepositoryID());
            abstractPrompt.setValueSource((Transformation)map);
            logger.debug("made a new classifier map and set it as value source ");
        }
        if (null != map) {
            if (jomaObject instanceof Classifier) {
                if (!map.getClassifierSources().contains((Object)jomaObject)) {
                    map.getClassifierSources().add((Object)jomaObject);
                    logger.debug("added a Classifier source named: ", jomaObject.getName());
                }
            } else if (!map.getTransformationSources().contains((Object)jomaObject)) {
                map.getTransformationSources().add((Object)jomaObject);
                logger.debug("added a Transformation source named: ", jomaObject.getName());
            }
        }
    }

    public static OMRPromptGroupInterface newGroupSmartObject(PromptGroupInterface group, UserContextInterface userContext, RepositoryInterface repository, String name, PromptsWritingContext writingContext) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        ValidateArg.notNull((Object)repository, (String)REPOSITORY);
        OMRPromptGroupInterface prompt = PromptsPersistUtil.saveGroup(group, userContext, null, name, repository, null, writingContext);
        return prompt;
    }

    public static OMRPromptGroupInterface updateGroupSmartObject(PromptGroupInterface group, UserContextInterface userContext, OMRPromptGroupInterface smartObject, PromptsWritingContext writingContext) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        ValidateArg.notNull((Object)smartObject, (String)"smartObject");
        OMRPromptGroupInterface prompt = PromptsPersistUtil.saveGroup(group, userContext, null, smartObject.getName(), smartObject.getRepository(), smartObject, writingContext);
        return prompt;
    }

    public static OMRPromptDefinitionInterface newDefinitionSmartObject(PromptDefinitionInterface definition, UserContextInterface userContext, RepositoryInterface repository, String name, PromptsWritingContext writingContext) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        ValidateArg.notNull((Object)repository, (String)REPOSITORY);
        OMRPromptDefinitionInterface prompt = PromptsPersistUtil.saveDefinition(definition, userContext, null, name, repository, null, writingContext);
        return prompt;
    }

    public static OMRPromptDefinitionInterface updateDefinitionSmartObject(PromptDefinitionInterface definition, UserContextInterface userContext, OMRPromptDefinitionInterface smartObject, PromptsWritingContext writingContext) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        ValidateArg.notNull((Object)smartObject, (String)"smartObject");
        OMRPromptDefinitionInterface prompt = PromptsPersistUtil.saveDefinition(definition, userContext, null, smartObject.getName(), smartObject.getRepository(), smartObject, writingContext);
        return prompt;
    }

    public static boolean isMetadataResourceAvailable(UserContextInterface userContext, PathUrl pathUrl) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)userContext, (String)USERCONTEXT);
        ValidateArg.notNull((Object)pathUrl, (String)"pathUrl");
        InformationServiceInterface infoService = UserContext.getInformationService();
        MetadataInterface smartObj = infoService.getObjectByPath(userContext, pathUrl);
        return null != smartObj;
    }
}

