/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.prompt;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.PromptGroup;
import com.sas.metadata.remote.impl.PromptGroupImpl;
import com.sas.metadata.remote.impl.PromptGroupImpl_Stub;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.prompt.AbstractPromptImpl;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.information.metadata.prompt.RB;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.PromptsReadingContext;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.logging.log4j.Level;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class OMRPromptGroup
extends AbstractPromptImpl
implements OMRPromptGroupInterface,
MultiLocaleProperties,
SubstitutionProperties {
    private static final long serialVersionUID = -5144211240231173647L;
    private boolean isLocalizationActive;
    private PromptGroupInterface promptGroup;

    public OMRPromptGroup(PromptGroup arg0) throws RemoteException {
        super(arg0, OMRPromptGroup.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPromptGroup() throws RemoteException {
        super(OMRPromptGroup.class);
    }

    public OMRPromptGroup(Object arg0, Class arg1) throws RemoteException {
        super(arg0, arg1);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPromptGroup(PromptGroupImpl arg0) throws RemoteException {
        super(arg0, OMRPromptGroup.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPromptGroup(PromptGroupImpl_Stub arg0) throws RemoteException {
        super(arg0, OMRPromptGroup.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPromptGroup(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(OMRPromptGroup.class);
        ValidateArg.notNull((Object)repos, (String)"repos");
        if (null == name || "".equals(name)) {
            name = "unnamed";
        }
        try {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            PromptGroup group = (PromptGroup)omirepository.createMetadata(name, "PromptGroup");
            group.setName(name);
            group.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = group;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            if (parent != null) {
                group.setPublicType("PromptGroup");
                try {
                    parent.addItem(this);
                }
                catch (ServiceException ex) {
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), this.getClass().getName(), (Throwable)((Object)ex));
                }
            } else {
                group.setPublicType("Embedded:PromptGroup");
            }
        }
        catch (ServiceException ex) {
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), this.getClass().getName(), (Throwable)((Object)ex));
        }
    }

    @Override
    public String getType() {
        return "PromptGroup";
    }

    @Override
    public String getGroupInfo() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        String groupInfo = null;
        if (null != this._repositoryObject) {
            groupInfo = ((PromptGroup)this._repositoryObject).getGroupInfo();
        }
        return groupInfo;
    }

    @Override
    public void setGroupInfo(String groupInfo) throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ((PromptGroup)this._repositoryObject).setGroupInfo(groupInfo);
    }

    @Override
    public void setGroupType(int type) throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ((PromptGroup)this._repositoryObject).setGroupType(type);
    }

    @Override
    public int getGroupType() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (null != this._repositoryObject) {
            return ((PromptGroup)this._repositoryObject).getGroupType();
        }
        return -1;
    }

    @Override
    public PromptGroupInterface getPromptGroup() throws RemoteException, ServiceException {
        return this.getPromptGroup(null);
    }

    @Override
    public PromptGroupInterface getPromptGroup(PromptsReadingContext readingContext) throws RemoteException, ServiceException {
        this.checkPulse(true);
        PromptGroupInterface retVal = null;
        String xml = this.getGroupInfo();
        if (null == xml) {
            throw new ServiceException(RB.getStringResource("OMRPromptGroup.noInfo.log"));
        }
        retVal = (PromptGroupInterface)this.getPromptFromXML(readingContext, xml);
        return retVal;
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        this.checkReadCompatible();
        PropertyList list = this.getDefaultLocalizableProperties();
        try {
            PromptGroupInterface promptGroup = this.getPromptGroup();
            if (promptGroup != null) {
                list.addProperty("Group", ((LocalizableProperties)promptGroup).getLocalizableProperties());
            }
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        return list;
    }

    public Collection getLocales() throws UnexpectedLocalizationException {
        try {
            PromptGroupInterface promptGroup = this.getPromptGroup();
            if (promptGroup != null) {
                return ((MultiLocaleProperties)promptGroup).getLocales();
            }
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        return new ArrayList();
    }

    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        this.checkReadCompatible();
        PropertyList list = new PropertyList();
        try {
            PromptGroupInterface promptGroup = this.getPromptGroup();
            if (promptGroup != null) {
                list.addProperty("Group", ((MultiLocaleProperties)promptGroup).getLocalizableProperties(locale));
            }
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        return list;
    }

    public void beginLocalization() throws UnexpectedLocalizationException {
        this.checkCompatible();
        try {
            this.promptGroup = this.getPromptGroup();
            this.isLocalizationActive = true;
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        this.checkCompatible();
        this.setDefaultLocalizableProperties(map);
        boolean isLocalizationActiveCopy = this.isLocalizationActive;
        if (!this.isLocalizationActive) {
            this.beginLocalization();
        }
        if (this.promptGroup != null) {
            ((LocalizableProperties)this.promptGroup).setLocalizableProperties(map.getNestedProperties("Group"));
        }
        if (!isLocalizationActiveCopy) {
            this.endLocalization();
        }
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        this.checkCompatible();
        boolean isLocalizationActiveCopy = this.isLocalizationActive;
        if (!this.isLocalizationActive) {
            this.beginLocalization();
        }
        if (this.promptGroup != null) {
            ((MultiLocaleProperties)this.promptGroup).setLocalizableProperties(locale, map.getNestedProperties("Group"));
        }
        if (!isLocalizationActiveCopy) {
            this.endLocalization();
        }
    }

    public void endLocalization() throws UnexpectedLocalizationException {
        this.checkCompatible();
        try {
            if (this.promptGroup != null) {
                PromptsPersistUtil.updateGroupSmartObject(this.promptGroup, this.getRepository().getUserContext(), this, null);
            }
            this.promptGroup = null;
            this.isLocalizationActive = false;
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
    }

    private void checkReadCompatible() {
        try {
            if (!this.isReadCompatible()) {
                throw new IllegalStateException("Prompt group with usage version " + this.getUsageVersion() + " is not supported.");
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Unexpected remote exception", e);
        }
    }

    private void checkCompatible() {
        try {
            if (!this.isCompatible()) {
                throw new IllegalStateException("Prompt group with usage version " + this.getUsageVersion() + " is not supported.");
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Unexpected remote exception", e);
        }
    }

    public PropertyList getSubstitutionProperties() throws UnexpectedSubstitutionException {
        this.checkReadCompatible();
        PropertyList retVal = new PropertyList();
        try {
            PropertyList retVal0;
            this.logMessage(Level.DEBUG, "getSubstitutionProperties() was called.", this.getClass().getName(), null);
            PromptGroupInterface group = this.getPromptGroup();
            if (null != group && group instanceof SubstitutionProperties && null != (retVal0 = ((SubstitutionProperties)group).getSubstitutionProperties()) && !retVal0.isEmpty()) {
                retVal.addComment("Nested properties for the named OMRPromptGroup");
                retVal.addProperty(this.getName(), retVal0);
                this.logMessage(Level.DEBUG, "getSubstitutionProperties(), returning a list for " + this.getName(), this.getClass().getName(), null);
            }
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new UnexpectedSubstitutionException((Throwable)((Object)e));
        }
        return retVal;
    }

    public void setSubstitutionProperties(@NotNull PropertyMap map) throws UnexpectedSubstitutionException {
        this.checkCompatible();
        try {
            this.logMessage(Level.DEBUG, "setSubstitutionProperties() was called.", this.getClass().getName(), null);
            if (map.containsNestedProperty(this.getName())) {
                this.logMessage(Level.DEBUG, "setSubstitutionProperties(), proceeding for " + this.getName(), this.getClass().getName(), null);
                PromptGroupInterface group = this.getPromptGroup();
                if (null != group && group instanceof SubstitutionProperties) {
                    ((SubstitutionProperties)group).setSubstitutionProperties(map.getNestedProperties(this.getName()));
                    PromptsPersistUtil.updateGroupSmartObject(group, this.getRepository().getUserContext(), this, null);
                }
            }
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new UnexpectedSubstitutionException((Throwable)((Object)e));
        }
    }
}

