/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.prompt;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.metadata.LogicalServerFilter;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PhysicalTableFilter;
import com.sas.services.information.metadata.prompt.CubeFilter;
import com.sas.services.information.metadata.prompt.RB;
import com.sas.services.user.UserContext;
import com.sas.services.user.UserContextInterface;
import com.sas.util.ValidateArg;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.impl.PersistHelper;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SASScope
public final class MetadataDescriptorResolver {
    private static final String RB_KEY = "MetadataDescriptorResolver.";

    private MetadataDescriptorResolver() {
    }

    public static MetadataInterface resolve(MetadataDescriptor descriptor, UserContextInterface userContext) throws RemoteException, ServiceException {
        MetadataInterface retVal = null;
        ValidateArg.notNull((Object)descriptor, (String)"descriptor");
        ValidateArg.notNull((Object)userContext, (String)"userContext");
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)MetadataDescriptorResolver.class.getName(), (LoggerFactoryInterface)new Log4JFactory2());
        if (null != descriptor.getMetadataObject() && descriptor.getMetadataObject() instanceof MetadataInterface) {
            retVal = (MetadataInterface)descriptor.getMetadataObject();
            logger.debug("Retrieved metadata object from descriptor.getMetadaObject():", retVal.getName());
            return retVal;
        }
        String sbipUrl = MetadataDescriptorResolver.getSbipUrl(descriptor);
        if (null != sbipUrl) {
            retVal = MetadataDescriptorResolver.searchFromUrl(sbipUrl, logger, userContext);
            return retVal;
        }
        FilterInterface filter = MetadataDescriptorResolver.newFilter(descriptor, logger);
        if (null != filter) {
            ArrayList<String> protocols = new ArrayList<String>();
            protocols.add("omi");
            filter.setProtocols(protocols);
            InformationServiceInterface is = UserContext.getInformationService();
            List out = is.search(userContext, filter);
            if (null != out && !out.isEmpty()) {
                logger.debug("Found metadata object. List size is:", Integer.toString(out.size()));
                retVal = (MetadataInterface)out.get(0);
                if (null != retVal && null != retVal.getName()) {
                    logger.debug("Metadata object name is:", retVal.getName());
                }
            } else {
                logger.debug("Nothing found by search of repositories. Returning null.");
            }
        } else {
            String nameMsg = new MessageFormat(RB.getStringResource("MetadataDescriptorResolver.descriptorName.fmt.log")).format(new Object[]{descriptor.getName()});
            String nameType = new MessageFormat(RB.getStringResource("MetadataDescriptorResolver.descriptorType.fmt.log")).format(new Object[]{descriptor.getType()});
            logger.info(RB.getStringResource("MetadataDescriptorResolver.noDescriptorResolution.log"));
            logger.info(nameMsg);
            logger.info(nameType);
        }
        return retVal;
    }

    private static FilterInterface newFilter(MetadataDescriptor descriptor, CommonLoggerInterface logger) {
        FilterInterface filter = null;
        String type = descriptor.getType();
        if (null != type) {
            if (logger.isDebugEnabled()) {
                logger.debug("descriptor name is:", descriptor.getName());
                logger.debug("descriptor type is:", descriptor.getType());
            }
            if (type.equals("PHYSICAL_TABLE")) {
                filter = MetadataDescriptorResolver.newTableFilter(descriptor, logger);
            } else if (type.equals("INFORMATION_MAP")) {
                filter = MetadataDescriptorResolver.newInfoMapFilter(descriptor, logger);
            } else if (type.equals("OLAP_CUBE")) {
                filter = MetadataDescriptorResolver.newCubeFilter(descriptor, logger);
            } else if (type.equals("LOGICAL_SERVER")) {
                filter = MetadataDescriptorResolver.newLogicalServerFilter(descriptor, logger);
            }
        }
        return filter;
    }

    private static FilterInterface newTableFilter(MetadataDescriptor descriptor, CommonLoggerInterface logger) {
        logger.debug("creating filter for physical table.");
        PhysicalTableFilter filter = new PhysicalTableFilter();
        filter.setName(descriptor.getName());
        Map map = descriptor.getAdditionalInfo();
        if (null != map && map.containsKey("LIBREF")) {
            String libref = (String)map.get("LIBREF");
            logger.debug("Libref is:", libref);
            filter.setLibref(libref);
        }
        return filter;
    }

    private static FilterInterface newInfoMapFilter(MetadataDescriptor descriptor, CommonLoggerInterface logger) {
        logger.debug("creating filter for information map.");
        Filter filter = new Filter();
        FilterComponent fc1 = new FilterComponent("Name", 0, descriptor.getName());
        FilterComponent fc2 = new FilterComponent("TransformRole", 0, "InformationMap");
        fc1.setAggregation(0);
        fc1.addComponent(fc2);
        filter.setFilterComponent(fc1);
        filter.setType("Transform");
        return filter;
    }

    private static FilterInterface newLogicalServerFilter(MetadataDescriptor descriptor, CommonLoggerInterface logger) {
        logger.debug("creating filter for logical server.");
        LogicalServerFilter filter = new LogicalServerFilter();
        FilterComponent fc1 = new FilterComponent("Name", 0, descriptor.getName());
        fc1.setAggregation(0);
        filter.setFilterComponent(fc1);
        return filter;
    }

    private static String getSbipUrl(MetadataDescriptor descriptor) {
        String retVal = null;
        Map map = descriptor.getAdditionalInfo();
        if (null != map && map.containsKey("SBIP_URL")) {
            retVal = (String)map.get("SBIP_URL");
        }
        return retVal;
    }

    private static MetadataInterface searchFromUrl(String sbipUrl, CommonLoggerInterface logger, UserContextInterface userContext) throws ServiceException, RemoteException {
        PathUrl url = null;
        if (sbipUrl.startsWith("SBIP://")) {
            url = new PathUrl(sbipUrl);
        } else if (sbipUrl.startsWith("URL::")) {
            sbipUrl = PersistHelper.parseSBIPUrl((String)sbipUrl);
        }
        if (null == url) {
            url = PathUrl.newPathUrlFromAbsolutePath(userContext.getAuthServer(), sbipUrl);
        }
        logger.debug("Searching with this URL:", sbipUrl);
        InformationServiceInterface infoService = UserContext.getInformationService();
        MetadataInterface retVal = infoService.getObjectByPath(userContext, url);
        if (null != retVal) {
            logger.debug("Found the metadata object at that SBIP URL.");
        } else {
            String msg = new MessageFormat(RB.getStringResource("MetadataDescriptorResolver.notFound.fmt.log")).format(new Object[]{sbipUrl});
            logger.info(msg);
        }
        return retVal;
    }

    private static Filter newCubeFilter(MetadataDescriptor descriptor, CommonLoggerInterface logger) {
        logger.debug("creating filter for a cube.");
        CubeFilter f = new CubeFilter();
        f.setName(descriptor.getName());
        Map map = descriptor.getAdditionalInfo();
        if (null != map && map.containsKey("LOGICAL_SERVER")) {
            String name = (String)map.get("LOGICAL_SERVER");
            logger.debug("Server name is: ", name);
            f.setLogicalServerName(name);
        }
        return f;
    }
}

