/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.favorites.impl;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.favorites.FavoritesContainer;
import com.sas.services.information.metadata.favorites.FavoritesGroup;
import com.sas.services.information.metadata.favorites.impl.RB;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.search.SortOrder;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;

public abstract class AbstractFavoritesContainer
extends Metadata
implements FavoritesContainer {
    private static final String CAPACITY_PROPERTY_NAME = "MaxCapacity";
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public AbstractFavoritesContainer() throws RemoteException {
    }

    public AbstractFavoritesContainer(Class theClass) throws RemoteException {
        super(theClass);
    }

    public AbstractFavoritesContainer(Object o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public AbstractFavoritesContainer(Object o) throws RemoteException {
        super(o);
    }

    @Override
    public void addFavorite(MetadataInterface favorite) throws ServiceException, RemoteException {
        this.addFavorite(favorite, -1);
    }

    @Override
    public void insertFavorite(MetadataInterface favorite, int index) throws ServiceException, RemoteException {
        this.addFavorite(favorite, index);
    }

    private void addFavorite(MetadataInterface favorite, int index) throws ServiceException, RemoteException {
        this.checkWriteAllowed();
        if (this._repositoryObject != null) {
            com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this._repositoryObject;
            Root favoriteItem = (Root)favorite.getRepositoryEntity();
            if (favoriteItem instanceof PrimaryType) {
                try {
                    AssociationList favoritesList = container.getFavorites();
                    if (!favoritesList.contains(favoriteItem)) {
                        if (index < 0) {
                            favoritesList.add(favoriteItem);
                        } else {
                            favoritesList.add(index, favoriteItem);
                        }
                        int maxCapacity = this.getMaxCapacity();
                        if (maxCapacity > -1) {
                            this.ensureProperSize(maxCapacity);
                        }
                        container.touch();
                    }
                }
                catch (MdException e) {
                    throw new ServiceException(e, e.getMessage());
                }
            }
        }
    }

    @Override
    public boolean containsFavorite(MetadataInterface favorite) throws ServiceException, RemoteException {
        this.checkReadAllowed();
        if (this._repositoryObject != null) {
            com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this._repositoryObject;
            Root favoriteItem = (Root)favorite.getRepositoryEntity();
            try {
                AssociationList members = container.getFavorites();
                return members.contains(favoriteItem);
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() throws ServiceException, RemoteException {
        return this.getFavoriteCount() == 0 && this.getFavoritesGroups().size() == 0;
    }

    @Override
    public int getFavoriteCount() throws ServiceException, RemoteException {
        this.checkReadAllowed();
        if (this._repositoryObject != null) {
            com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this._repositoryObject;
            try {
                return container.getFavorites().size();
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
        return 0;
    }

    @Override
    public int getTotalFavoriteCount() throws ServiceException, RemoteException {
        this.checkReadAllowed();
        int count = 0;
        if (this._repositoryObject != null) {
            count += this.getFavoriteCount();
            List<FavoritesGroup> groups = this.getFavoritesGroups();
            for (FavoritesGroup group : groups) {
                count += group.getTotalFavoriteCount();
            }
        }
        return count;
    }

    @Override
    public int getFavoriteIndex(MetadataInterface favorite) throws ServiceException, RemoteException {
        this.checkReadAllowed();
        if (this._repositoryObject != null) {
            com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this._repositoryObject;
            Root favoriteItem = (Root)favorite.getRepositoryEntity();
            String id = favoriteItem.getId();
            try {
                AssociationList members = container.getFavorites();
                int index = 0;
                for (Root member : members) {
                    if (id.equalsIgnoreCase(member.getId())) {
                        return index;
                    }
                    ++index;
                }
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
        return -1;
    }

    @Override
    public void removeAllFavorites() throws ServiceException, RemoteException {
        this.checkWriteAllowed();
        if (this._repositoryObject != null) {
            try {
                com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this._repositoryObject;
                container.getFavorites().clear();
                container.touch();
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
    }

    @Override
    public void removeFavorite(MetadataInterface favorite) throws ServiceException, RemoteException {
        this.checkWriteAllowed();
        if (favorite instanceof FavoritesGroup) {
            this.removeFavoritesGroup((FavoritesGroup)favorite);
        } else if (this._repositoryObject != null) {
            com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this._repositoryObject;
            Object favoriteItem = favorite.getRepositoryEntity();
            if (favoriteItem instanceof PrimaryType) {
                try {
                    if (!container.getFavorites().remove((Object)((PrimaryType)favoriteItem))) {
                        try {
                            String msg = "The favorite \"" + favorite.getName() + "\" did not exist in the container prior to removing it.";
                            this.logMessage(Level.DEBUG, msg, "com.sas.services.information.metadata.favorites", null);
                        }
                        catch (Exception msg) {}
                    } else {
                        container.touch();
                    }
                }
                catch (MdException e) {
                    throw new ServiceException(e, e.getMessage());
                }
            }
        }
    }

    @Override
    public List<MetadataInterface> getFavorites() throws ServiceException, RemoteException {
        this.checkReadAllowed();
        if (this._repositoryObject != null) {
            ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>();
            com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this._repositoryObject;
            try {
                AssociationList members = container.getFavorites();
                if (!members.isEmpty()) {
                    for (Root member : members) {
                        MetadataInterface mi;
                        if (!(member instanceof PrimaryType) || (mi = this._repository.factoryProcess(member)) == null) continue;
                        results.add(mi);
                    }
                }
                return results;
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<MetadataInterface> getFavorites(SortOrder[] order) throws ServiceException, RemoteException {
        this.checkReadAllowed();
        List<MetadataInterface> favorites = this.getFavorites();
        if (!favorites.isEmpty()) {
            if (order == null) {
                order = SortOrder.getDefaultOrder();
            }
            Collections.sort(favorites, SortOrder.getComparator(order));
        }
        return favorites;
    }

    @Override
    public List<FavoritesGroup> getFavoritesGroups() throws ServiceException, RemoteException {
        this.checkReadAllowed();
        if (this._repositoryObject != null) {
            ArrayList<FavoritesGroup> results = new ArrayList<FavoritesGroup>();
            com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this._repositoryObject;
            try {
                AssociationList subgroups = container.getSubContainers();
                if (!subgroups.isEmpty()) {
                    for (Root subgroup : subgroups) {
                        FavoritesGroup group;
                        if (!(subgroup instanceof com.sas.metadata.remote.FavoritesContainer) || (group = (FavoritesGroup)this._repository.factoryProcess(subgroup)) == null) continue;
                        results.add(group);
                    }
                }
                return results;
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public int getFavoritesGroupIndex(FavoritesGroup subGroup) throws ServiceException, RemoteException {
        this.checkReadAllowed();
        if (this._repositoryObject != null) {
            com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this._repositoryObject;
            Root subGroupItem = (Root)subGroup.getRepositoryEntity();
            String id = subGroupItem.getId();
            try {
                AssociationList groups = container.getFavoritesContainers();
                int index = 0;
                for (Root group : groups) {
                    if (id.equalsIgnoreCase(group.getId())) {
                        return index;
                    }
                    ++index;
                }
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
        return -1;
    }

    @Override
    public void addFavoritesGroup(FavoritesGroup subGroup) throws ServiceException, RemoteException {
        this.addFavoritesGroup(subGroup, -1);
    }

    @Override
    public void insertFavoritesGroup(FavoritesGroup subGroup, int index) throws ServiceException, RemoteException {
        this.addFavoritesGroup(subGroup, index);
    }

    private void addFavoritesGroup(FavoritesGroup subGroup, int index) throws ServiceException, RemoteException {
        this.checkWriteAllowed();
        if (this._repositoryObject != null) {
            com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this._repositoryObject;
            Root subGroupItem = (Root)subGroup.getRepositoryEntity();
            if (subGroupItem instanceof com.sas.metadata.remote.FavoritesContainer) {
                try {
                    if (this.hasDuplicateFavoritesGroup(subGroupItem.getName(), subGroup)) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractFavoritesContainer.Duplicate.fmt.txt", (Object)subGroupItem.getName());
                        throw new ServiceException(msg);
                    }
                    if (index < 0) {
                        container.getSubContainers().add((Object)subGroupItem);
                    } else {
                        container.getSubContainers().add(index, (Object)subGroupItem);
                    }
                    container.touch();
                }
                catch (MdException e) {
                    throw new ServiceException(e, e.getMessage());
                }
            }
        }
    }

    @Override
    public void removeFavoritesGroup(FavoritesGroup subGroup) throws ServiceException, RemoteException {
        this.checkWriteAllowed();
        if (this._repositoryObject != null) {
            com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this._repositoryObject;
            Object groupItem = subGroup.getRepositoryEntity();
            if (groupItem instanceof com.sas.metadata.remote.FavoritesContainer) {
                try {
                    if (!container.getSubContainers().remove(groupItem)) {
                        try {
                            String msg = "The favorites group \"" + subGroup.getName() + "\" did not exist in the container prior to removing it.";
                            this.logMessage(Level.DEBUG, msg, "com.sas.services.information.metadata.favorites", null);
                        }
                        catch (Exception msg) {}
                    } else {
                        container.touch();
                    }
                }
                catch (MdException e) {
                    throw new ServiceException(e, e.getMessage());
                }
            }
        }
    }

    @Override
    public void removeAllFavoritesGroups() throws ServiceException, RemoteException {
        this.checkWriteAllowed();
        List<FavoritesGroup> subGroups = this.getFavoritesGroups();
        for (FavoritesGroup group : subGroups) {
            this.removeFavoritesGroup(group);
        }
    }

    @Override
    public void removeAll() throws ServiceException, RemoteException {
        this.checkWriteAllowed();
        this.removeAllFavoritesGroups();
        this.removeAllFavorites();
    }

    @Override
    public boolean hasDuplicateFavoritesGroup(String name) throws ServiceException, RemoteException {
        return this.hasDuplicateFavoritesGroup(name, null);
    }

    private boolean hasDuplicateFavoritesGroup(String name, FavoritesGroup groupToExclude) throws ServiceException, RemoteException {
        int cnt;
        this.checkReadAllowed();
        if (name == null) {
            return false;
        }
        boolean result = false;
        int testedObjects = 0;
        List<FavoritesGroup> groups = this.getFavoritesGroups();
        for (FavoritesGroup group : groups) {
            if (name.equalsIgnoreCase(group.getName())) {
                result = true;
                break;
            }
            ++testedObjects;
        }
        if (!result && this._repositoryFlag == 2 && testedObjects < (cnt = this.countAssociatedObjects("SubContainers"))) {
            String selectName = XMLUtil.normalize(name);
            StringBuilder sb = new StringBuilder();
            sb.append("<XMLSelect search=\"*[@Name='" + selectName + "' and @PublicType='");
            sb.append("FavoritesGroup");
            if (groupToExclude != null) {
                sb.append("' and @Id NE '");
                sb.append(groupToExclude.getIdentifier());
            }
            sb.append("'][ParentContainer/FavoritesContainer[@Id='");
            sb.append(this.getReposId());
            sb.append("']]\" />");
            Filter filter = new Filter();
            filter.setExplicitSearchString("omi", sb.toString());
            filter.setType("FavoritesContainer");
            int count = ((OMIRepositoryInterface)this._repository).getCountNoSecurity(filter, null);
            if (count > 0) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public void moveFavorite(MetadataInterface favorite, int newPosition) throws ServiceException, RemoteException {
        this.checkWriteAllowed();
        if (this._repositoryObject != null) {
            com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this._repositoryObject;
            try {
                int currentPosition = this.getFavoriteIndex(favorite);
                if (currentPosition == -1) {
                    throw new IllegalArgumentException("Object not found in list");
                }
                Root favoriteItem = (Root)favorite.getRepositoryEntity();
                AssociationList members = container.getFavorites();
                members.remove(currentPosition);
                members.set(newPosition, favoriteItem);
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
    }

    @Override
    public int getMaxCapacity() throws ServiceException, RemoteException {
        this.checkReadAllowed();
        List props = this.getObjectProperties();
        for (PropertyInterface prop : props) {
            if (!CAPACITY_PROPERTY_NAME.equalsIgnoreCase(prop.getName())) continue;
            return Integer.parseInt(prop.getValue());
        }
        return -1;
    }

    @Override
    public void setMaxCapacity(int capacity) throws ServiceException, RemoteException {
        this.checkWriteAllowed();
        List props = this.getObjectProperties();
        for (PropertyInterface prop : props) {
            if (!CAPACITY_PROPERTY_NAME.equalsIgnoreCase(prop.getName())) continue;
            String existingValue = prop.getValue();
            if (capacity != Integer.parseInt(existingValue)) {
                prop.setValue(String.valueOf(capacity));
                this.ensureProperSize(capacity);
            }
            return;
        }
        OMIRepositoryInterface repository = (OMIRepositoryInterface)this.getRepository();
        PropertyInterface capacityProperty = (PropertyInterface)repository.newMetadata(null, CAPACITY_PROPERTY_NAME, "Property");
        capacityProperty.setValue(String.valueOf(capacity));
        this.addObjectProperty(capacityProperty);
        this.ensureProperSize(capacity);
    }

    private void ensureProperSize(int capacity) throws ServiceException, RemoteException {
        if (capacity == -1) {
            return;
        }
        int currentSize = this.getFavoriteCount();
        if (currentSize > capacity) {
            this.logMessage(Level.DEBUG, "Removing older favorites due to change in maximum capacity.");
            List<MetadataInterface> favorites = this.getFavorites();
            MetadataInterface[] objects = favorites.toArray(new MetadataInterface[favorites.size()]);
            int currentIndex = 0;
            while (currentSize > 0 && currentSize > capacity && currentIndex <= currentSize) {
                MetadataInterface item = objects[currentIndex++];
                this.removeFavorite(item);
                this.logMessage(Level.DEBUG, "Removed favorite: " + item.toString());
                --currentSize;
            }
        }
    }

    @Override
    public PublicObjectInterface getChildAt(int index) throws ServiceException, RemoteException {
        List favorites = this.getChildren();
        if (favorites == null || favorites.size() == 0) {
            throw new ArrayIndexOutOfBoundsException("The favorites container is empty.");
        }
        return (PublicObjectInterface)favorites.get(index);
    }

    @Override
    public int getChildCount() throws ServiceException, RemoteException {
        List favorites = this.getChildren();
        return favorites.size();
    }

    @Override
    public List getChildren() throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>();
        results.addAll(this.getFavoritesGroups());
        results.addAll(this.getFavorites());
        return results;
    }

    @Override
    public List getChildren(String type) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PublicObjectInterface newChild(String type, String name) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    protected void checkReadAllowed() throws VersionIncompatibleException, RemoteException {
        if (!this.isReadCompatible()) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
    }

    protected void checkWriteAllowed() throws VersionIncompatibleException, RemoteException {
        if (!this.isCompatible()) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
    }
}

