/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.favorites;

import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.favorites.FavoritesContainer;
import com.sas.services.information.metadata.favorites.FavoritesFolder;
import com.sas.services.information.metadata.favorites.FavoritesGroup;
import com.sas.services.information.metadata.favorites.RB;
import com.sas.services.session.RemoteSessionContextStateChangedListener;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionContextStateChangedEvent;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FavoritesFactory
implements RemoteSessionContextStateChangedListener {
    private static final String LOGGING_CONTEXT = "com.sas.services.information.metadata.favorites";
    private static final String FAVORITES_FOLDER_NAME = "Favorites";
    private static final String MY_FAVORITES_FOLDER_NAME = "My Favorites";
    private static final String HISTORY_FOLDER_NAME = "History";
    private static Map<SessionContextInterface, FavoritesFactory> _instanceCache = Collections.synchronizedMap(new HashMap());
    private SessionContextInterface _session;
    private Logger _logger;

    private FavoritesFactory(SessionContextInterface session) throws ServiceException, RemoteException {
        this._session = session;
        this.initializeFactory();
    }

    private void initializeFactory() throws IllegalStateException, RemoteException {
        block4: {
            this._logger = LogManager.getLogger((String)LOGGING_CONTEXT);
            try {
                this._session.setAttribute(FavoritesFactory.class.getName(), this);
            }
            catch (IllegalStateException e) {
                if (this._logger != null) {
                    this._logger.warn(RB.getStringResource("FavoritesFactory.AddToSessionError.txt"), (Throwable)e);
                }
            }
            catch (RemoteException e) {
                if (this._logger == null) break block4;
                this._logger.warn(RB.getStringResource("FavoritesFactory.AddToSessionError.txt"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FavoritesFactory getInstance(SessionContextInterface session) throws ServiceException, RemoteException {
        if (session == null) {
            throw new IllegalArgumentException(RB.getStringResource("FavoritesFactory.InvalidSession.txt"));
        }
        Map<SessionContextInterface, FavoritesFactory> map = _instanceCache;
        synchronized (map) {
            if (_instanceCache.containsKey(session)) {
                return _instanceCache.get(session);
            }
            FavoritesFactory instance = new FavoritesFactory(session);
            _instanceCache.put(session, instance);
            return instance;
        }
    }

    public SessionContextInterface getSession() {
        return this._session;
    }

    public FavoritesFolder createFavoritesFolder(String name, FolderInterface folder) throws ServiceException, RemoteException {
        InformationServiceInterface is = (InformationServiceInterface)DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}, null));
        if (is != null) {
            RepositoryInterface ri = folder.getRepository();
            return (FavoritesFolder)is.newMetadataInFolder(folder, ri, "FavoritesFolder", name);
        }
        return null;
    }

    public FavoritesGroup createFavoritesGroup(String name, FavoritesContainer container) throws ServiceException, RemoteException {
        RepositoryInterface ri;
        FavoritesGroup favoritesGroup;
        if (container.hasDuplicateFavoritesGroup(name)) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesFactory.Duplicate.fmt.txt", (Object)name));
        }
        InformationServiceInterface is = (InformationServiceInterface)DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}, null));
        if (is != null && (favoritesGroup = (FavoritesGroup)is.newMetadata(null, name, ri = container.getRepository(), "FavoritesGroup")) != null) {
            favoritesGroup.setFavoritesContainer(container);
            return favoritesGroup;
        }
        return null;
    }

    public FavoritesFolder getUserFavorites() throws ServiceException, RemoteException {
        ServerInterface server = this._session.getUserContext().getAuthServer();
        FolderInterface appDataFolder = server.getHomeFolder(null, UserFolderType.APPFOLDER, null);
        if (appDataFolder != null) {
            MetadataInterface mi = appDataFolder.getItemByType(MY_FAVORITES_FOLDER_NAME, "FavoritesFolder");
            if (mi instanceof FavoritesFolder) {
                return (FavoritesFolder)mi;
            }
            if (mi == null) {
                FavoritesFolder folder = this.createFavoritesFolder(MY_FAVORITES_FOLDER_NAME, appDataFolder);
                if (folder != null && folder.getState() == 1) {
                    folder.update();
                }
                return folder;
            }
        }
        return null;
    }

    public FavoritesFolder getApplicationFavorites(String contextName) throws ServiceException, RemoteException {
        return this.getApplicationFavoritesFolder(contextName, FAVORITES_FOLDER_NAME);
    }

    public FavoritesFolder getApplicationHistory(String applicationName) throws ServiceException, RemoteException {
        return this.getApplicationFavoritesFolder(applicationName, HISTORY_FOLDER_NAME);
    }

    private FavoritesFolder getApplicationFavoritesFolder(String applicationName, String containerName) throws ServiceException, RemoteException {
        ServerInterface server = this._session.getUserContext().getAuthServer();
        FolderInterface appDataFolder = server.getHomeFolder(null, UserFolderType.APPFOLDER, null);
        if (appDataFolder != null) {
            FolderInterface appFolder = appDataFolder.getSubfolder(applicationName);
            if (appFolder == null) {
                appFolder = appDataFolder.makeSubfolder(applicationName);
            }
            if (appFolder != null) {
                MetadataInterface mi = appFolder.getItemByType(containerName, "FavoritesFolder");
                if (mi instanceof FavoritesFolder) {
                    return (FavoritesFolder)mi;
                }
                if (mi == null) {
                    FavoritesFolder folder = this.createFavoritesFolder(containerName, appFolder);
                    if (folder != null && folder.getState() == 1) {
                        folder.update();
                    }
                    return folder;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contextStateChanged(SessionContextStateChangedEvent event) throws RemoteException {
        if (event.getStateChange() == 2) {
            SessionContextInterface session = event.getSessionContext();
            Map<SessionContextInterface, FavoritesFactory> map = _instanceCache;
            synchronized (map) {
                if (_instanceCache.containsKey(session)) {
                    _instanceCache.remove(session);
                    this._session = null;
                    this._logger = null;
                }
            }
        }
    }
}

