/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.dav;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.information.RepositoryData;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.dav.DAVItem;
import com.sas.services.util.TransformerFactoryFactory;
import com.sas.services.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DAVEvent
extends DAVItem {
    private transient Document eventDoc = null;
    private boolean parseDone = false;

    public DAVEvent(RepositoryInterface repos, String reposId) {
        super(repos, reposId);
        this._objectClass = "event";
    }

    public DAVEvent(RepositoryData entity) {
        super(entity);
        this._objectClass = "event";
    }

    public Document getEventDocument() {
        if (!this.parseDone) {
            this.parseXMLContent();
            this.parseDone = true;
        }
        return this.eventDoc;
    }

    public String getEventDocumentAsString() {
        Document doc = this.getEventDocument();
        if (doc != null) {
            return XMLUtil.convertNodeToString(doc);
        }
        return "";
    }

    private void parseXMLContent() {
        try {
            DocumentBuilderFactory factory = null;
            DocumentBuilder builder = null;
            factory = TransformerFactoryFactory.newDocumentBuilderFactory();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
            this.eventDoc = builder.parse(new ByteArrayInputStream(this.getContentsAsBytes()));
            this.eventDoc.getDocumentElement().normalize();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setEventDocumentFromString(String eventDocString) {
        try {
            this.eventDoc = XMLUtil.convertStringToDocument(eventDocString);
            this.setContentType("text/xml; charset=utf-8");
            this.setContents(XMLUtil.convertNodeToString(this.eventDoc).getBytes("UTF-8"));
            NodeList nl = this.eventDoc.getElementsByTagNameNS("http://www.sas.com/xml/namespace/services.events-1.1", "Header");
            if (nl.getLength() > 0) {
                Element hdrElem = (Element)nl.item(0);
                NodeList nl2 = hdrElem.getChildNodes();
                for (int j = 0; j < nl2.getLength(); ++j) {
                    Node n2 = nl2.item(j);
                    if (n2.getNodeType() != 1 || !n2.getNodeName().equals("Properties") && !n2.getLocalName().equals("Properties")) continue;
                    this.promoteProperties((Element)n2);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setEventDocument(Document eventDoc) {
        try {
            try {
                this.setContentType("text/xml; charset=utf-8");
                this.setContents(XMLUtil.convertNodeToString(eventDoc).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            NodeList nl = eventDoc.getElementsByTagNameNS("http://www.sas.com/xml/namespace/services.events-1.1", "Header");
            if (nl.getLength() > 0) {
                Element hdrElem = (Element)nl.item(0);
                NodeList nl2 = hdrElem.getChildNodes();
                for (int j = 0; j < nl2.getLength(); ++j) {
                    Node n2 = nl2.item(j);
                    if (!n2.getNodeName().equals("Properties") && !n2.getLocalName().equals("Properties")) continue;
                    this.promoteProperties((Element)n2);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.eventDoc = eventDoc;
    }

    public void promoteProperties(Element root) {
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String ns;
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element propElem = (Element)n;
            String propName = propElem.getLocalName();
            if (propName == null) {
                propName = propElem.getNodeName();
            }
            propName = (ns = propElem.getNamespaceURI()) == null ? "{http://www.sas.com/xml/namespace/services.webdav.eventx-1.1}" + propName : '{' + ns + '}' + propName;
            if (!n.hasChildNodes() || n.getChildNodes().getLength() != 1) continue;
            String propValue = this.getPropValue((Element)n);
            this.setAttribute(propName, propValue);
        }
    }

    private String getPropValue(Element elem) {
        int p2;
        String _value = XMLUtil.convertNodeToString((Node)elem, true);
        int p1 = _value.indexOf(62);
        _value = p1 < (p2 = _value.lastIndexOf(60)) ? _value.substring(p1 + 1, p2) : "";
        return _value;
    }

    public String findPropertyValue(String expr) {
        String _expr = expr.trim();
        try {
            NodeList resultList;
            DocumentBuilderFactory factory = null;
            TransformerFactory tFactory = TransformerFactoryFactory.newFactory();
            DocumentBuilder builder = null;
            factory = TransformerFactoryFactory.newDocumentBuilderFactory();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
            HashMap<String, String> prefixMap = new HashMap<String, String>();
            while (_expr.startsWith("declare namespace ")) {
                _expr = _expr.substring(18).trim();
                int ptr = _expr.indexOf(61);
                String prefix = _expr.substring(0, ptr).trim();
                _expr = _expr.substring(ptr + 1).trim();
                ptr = _expr.indexOf(34);
                int ptr2 = _expr.indexOf(34, ptr + 1);
                String nsURI = _expr.substring(ptr + 1, ptr2);
                _expr = _expr.substring(ptr2 + 1);
                prefixMap.put(prefix, nsURI);
            }
            Document xslDoc = builder.newDocument();
            Element copyOfElement = xslDoc.createElementNS("http://www.w3.org/1999/XSL/Transform", "xsl:copy-of");
            copyOfElement.setAttribute("select", _expr);
            Element responseElement = xslDoc.createElement("Response");
            responseElement.appendChild(copyOfElement);
            Element outputElement = xslDoc.createElementNS("http://www.w3.org/1999/XSL/Transform", "xsl:output");
            outputElement.setAttribute("method", "xml");
            outputElement.setAttribute("indent", "yes");
            Element templateElement = xslDoc.createElementNS("http://www.w3.org/1999/XSL/Transform", "xsl:template");
            templateElement.setAttribute("match", "/");
            templateElement.appendChild(responseElement);
            Element stylesheetElement = xslDoc.createElementNS("http://www.w3.org/1999/XSL/Transform", "xsl:stylesheet");
            stylesheetElement.setAttribute("version", "2.0");
            stylesheetElement.appendChild(outputElement);
            stylesheetElement.appendChild(templateElement);
            xslDoc.appendChild(stylesheetElement);
            for (Map.Entry me : prefixMap.entrySet()) {
                stylesheetElement.setAttribute("xmlns:" + (String)me.getKey(), (String)me.getValue());
            }
            stylesheetElement.setAttribute("xmlns:sas-event", "http://www.sas.com/xml/namespace/services.events-1.1");
            stylesheetElement.setAttribute("xmlns:sas-alerts-sp", "http://www.sas.com/xml/namespace/services.alerts.sp-1.1");
            stylesheetElement.setAttribute("xmlns:sas-publish", "http://www.sas.com/xml/namespace/services.publish-1.1");
            DOMSource xslDomSource = new DOMSource(xslDoc);
            Transformer transformer = tFactory.newTransformer(xslDomSource);
            Document xmlDoc = this.getEventDocument();
            if (xmlDoc == null) {
                return "";
            }
            DOMSource xmlDomSource = new DOMSource(xmlDoc);
            DOMResult domResult = new DOMResult();
            transformer.transform(xmlDomSource, domResult);
            Node results = domResult.getNode();
            if (results instanceof Document && (resultList = ((Document)results).getElementsByTagName("Response")).getLength() > 0) {
                NodeList answers = resultList.item(0).getChildNodes();
                if (answers.getLength() > 0) {
                    if (answers.item(0) instanceof Element) {
                        return this.getPropValue((Element)answers.item(0));
                    }
                    return answers.item(0).getNodeValue();
                }
                Node answer = resultList.item(0);
                if (answer.hasAttributes()) {
                    NamedNodeMap attrs = answer.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Node attr = attrs.item(i);
                        if (attr.getPrefix().equals("xmlns")) continue;
                        return attr.getNodeValue();
                    }
                }
            }
            return "";
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return "";
    }
}

