/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.dataexplorer;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.GroupInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.dataexplorer.RB;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.util.Names;
import com.sas.services.util.TransformerFactoryFactory;
import com.sas.text.Message;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@SASScope
public class OMRUtils {
    private static String prefix = "SBIP://";
    private static String folder = "(Folder)";
    private static String RB_KEY = "OMRUtils.";

    public static String getRepositoryIdOf(String objectId) {
        if (null == objectId) {
            return null;
        }
        int period = objectId.indexOf(46);
        if (period < 1) {
            return null;
        }
        if (objectId.startsWith("A0000001.")) {
            return objectId.substring(period + 1);
        }
        return objectId.substring(0, period);
    }

    public static void checkPermissions(MetadataInterface source, String permission, MetadataInterface parent) throws ServiceException, RemoteException {
        if (null != source) {
            LogManager.getLogger(source.getClass()).debug("checkPermissions: source: " + source + ", permission: " + permission);
        }
        if (OMRUtils.isTempObj(source) && null != parent && !OMRUtils.isTempObj(parent)) {
            LogManager.getLogger((String)"com.sas.services.information.metadata.dataexplorer.OMRUtils").debug("checkPermissions: source: " + source + ", is temporary object, using parent = " + parent);
            if ("WriteMetadata".equals(permission) && parent instanceof FolderInterface) {
                permission = "WriteMemberMetadata";
            }
            source = parent;
        } else if (!(null != source && source.isObjectAlive() || null == parent)) {
            LogManager.getLogger((String)"com.sas.services.information.metadata.dataexplorer.OMRUtils").debug("checkPermissions: source: " + source + ", is not alive, using parent = " + parent);
            if ("WriteMetadata".equals(permission) && parent instanceof FolderInterface) {
                permission = "WriteMemberMetadata";
            }
            source = parent;
        }
        if (null != source && !source.isAuthorized(permission)) {
            throw new ServiceException(RB.getStringResource(RB_KEY, "assertPermission.txt"));
        }
    }

    public static boolean isTempObj(MetadataInterface obj) throws RemoteException {
        if (null == obj) {
            return true;
        }
        String id = obj.getReposId();
        if (null == id) {
            return true;
        }
        return id.indexOf(".$") > -1;
    }

    public static String makeFullObjectId(String objectId, String type) {
        if (null == objectId) {
            return null;
        }
        if (!objectId.endsWith(type)) {
            return objectId + "/" + type;
        }
        return objectId;
    }

    public static MetadataInterface getMetaDataObjectFromId(String id, RepositoryInterface repository) throws MdException {
        if (null == repository) {
            throw new MdException(Message.format((String)RB.getStringResource(RB_KEY, "repositoryNotSet.fmt"), (Object)"getMetaDataObjectFromId()"));
        }
        try {
            return repository.fetch(OMRUtils.makeFullObjectId(id, "Transformation"));
        }
        catch (Exception e) {
            try {
                repository.getServer().warn("com.sas.services.information.metadata.dataexplorer.OMRUtils", "getMetaDataObjectFormId: unable to fetch metadata using id=" + id + ", message = " + e.getLocalizedMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static MetadataInterface getMetaDataObjectFromId(String id, ServerInterface server) throws RemoteException, MdException, ServiceException {
        if (null == server) {
            throw new MdException(Message.format((String)RB.getStringResource(RB_KEY, "serverNotSet.fmt"), (Object)"getMetaDataObjectFromId()"));
        }
        return server.fetch(OMRUtils.makeFullObjectId(id, "Transformation"), false);
    }

    public static boolean changePropertyValueFromIDtoURL(MetadataInterface source, Transformation trans, RepositoryInterface repository, String propertyNameWithID, String propertyNameWithURL) throws RemoteException, MdException, ServiceException {
        boolean result = false;
        Property propWithId = OMRUtils.getPropertyByName(trans, propertyNameWithID);
        Property propWithURL = OMRUtils.getPropertyByName(trans, propertyNameWithURL, true, repository);
        if (propWithURL != null && propWithURL.getDefaultValue() != null && propWithURL.getDefaultValue().trim().length() > 0) {
            return false;
        }
        if (null != propWithId) {
            String id = propWithId.getDefaultValue();
            MetadataInterface mdata = OMRUtils.getMetaDataObjectFromId(id, repository);
            if (null == mdata) {
                if (null != source) {
                    LogManager.getLogger(source.getClass()).warn(Message.format((String)RB.getStringResource("Transformation.convert2.property.fmt.txt"), (Object)source.getReposId(), (Object)propertyNameWithID, (Object)id));
                }
                result = false;
            } else {
                String path = mdata.getPathUrl().getAbsolutePath();
                String desc = propWithId.getDesc();
                if (null != source) {
                    LogManager.getLogger(source.getClass()).warn(Message.format((String)RB.getStringResource("Transformation.convert.property.fmt.txt"), (Object)source.getReposId(), (Object)propertyNameWithID, (Object)id, (Object)propertyNameWithURL, (Object)path));
                }
                propWithURL.setDefaultValue(path);
                propWithURL.setDesc(desc);
                result = true;
            }
            OMRUtils.removeProperty(trans, propWithId);
        }
        return result;
    }

    public static Property getPropertyByName(Transformation trans, String propertyName) throws RemoteException, MdException, ServiceException {
        Property result = null;
        if (null == propertyName || propertyName.trim().length() == 0) {
            return null;
        }
        AssociationList properties = trans.getProperties();
        for (Property prop : properties) {
            if (!propertyName.equals(prop.getName())) continue;
            result = prop;
            break;
        }
        return result;
    }

    public static Property getPropertyByName(Transformation trans, String propertyName, boolean create, RepositoryInterface repos) throws RemoteException, MdException, ServiceException {
        Property result = OMRUtils.getPropertyByName(trans, propertyName);
        if (null == result && null != repos && create) {
            AssociationList properties = trans.getProperties();
            if (null == properties || properties.isEmpty()) {
                trans.setProperties(new AssociationList("Properties"));
            }
            PropertyType string = OMRUtils.getStringPropertyType(repos);
            MetadataInterface mdata = repos.newMetadata(null, propertyName, "Property");
            result = (Property)mdata.getRepositoryEntity();
            result.setOwningType(string);
            trans.getProperties().add((Object)result);
        }
        return result;
    }

    public static void removePropertyByName(Transformation trans, String propertyName) throws RemoteException, MdException, ServiceException {
        Property prop = OMRUtils.getPropertyByName(trans, propertyName);
        if (null == prop) {
            return;
        }
        OMRUtils.removeProperty(trans, prop);
    }

    public static void removeProperty(Transformation trans, Property property) throws RemoteException, MdException, ServiceException {
        if (null == trans || null == property) {
            return;
        }
        AssociationList list = trans.getProperties();
        list.remove((Object)property);
        property.delete();
    }

    public static String getLocationString(AssociationList list, String repositoryName) throws MdException, RemoteException {
        String location = null;
        if (list.size() > 0) {
            Tree element = (Tree)list.get(0);
            location = element.getName();
            while (element.getParentTree() != null) {
                element = element.getParentTree();
                location = element.getName() + "/" + location;
            }
            location = prefix + repositoryName + "/" + location + folder;
        }
        return location;
    }

    public static String getLocationString(AssociationList list, ServerInterface server) throws MdException, ServiceException, RemoteException {
        String location = null;
        if (list.size() > 0) {
            Tree element = (Tree)list.get(0);
            location = element.getName();
            while (element.getParentTree() != null) {
                element = element.getParentTree();
                location = element.getName() + "/" + location;
            }
            PathUrl path = PathUrl.newPathUrlFromAbsolutePath(server, location);
            location = path.toString();
        }
        return location;
    }

    public static FolderInterface getFolderForPath(SessionContextInterface session, PathUrl path, boolean create) throws RemoteException, ServiceException {
        RepositoryInterface repository = session.getUserContext().getRepository(path.getRepository());
        ServerInterface server = session.getUserContext().getAuthServer();
        if (server == null) {
            return null;
        }
        return OMRUtils.getFolderForPath(server, path, create);
    }

    public static FolderInterface getFolderForPath(ServerInterface server, PathUrl path, boolean create) throws RemoteException, ServiceException {
        String pathString = null;
        ArrayList<String> folderHierarchy = new ArrayList<String>();
        folderHierarchy.add(path.getRootTree());
        pathString = path.getPath() == null ? path.getName() : path.getPath() + "/" + path.getName();
        if (pathString != null) {
            OMRUtils.createFolderHierarchy(folderHierarchy, pathString);
        }
        String folderName = (String)folderHierarchy.get(0);
        FolderInterface targetFolder = server.getRootFolder();
        int size = folderHierarchy.size();
        for (int i = 0; i < size; ++i) {
            MetadataInterface item;
            folderName = (String)folderHierarchy.get(i);
            if (i + 1 == size && (item = targetFolder.getItem(folderName)) != null) {
                return targetFolder;
            }
            FolderInterface tempFolder = targetFolder.getSubfolder(folderName);
            if (tempFolder == null) {
                boolean match = false;
                if ("Users".equals(targetFolder.getName())) {
                    List subfolders = targetFolder.getSubfolders();
                    for (FolderInterface folder : subfolders) {
                        match = folder.getName().equalsIgnoreCase(folderName);
                        if (!match) continue;
                        tempFolder = folder;
                        break;
                    }
                    if (match) {
                        targetFolder = tempFolder;
                        continue;
                    }
                }
                if (create) {
                    if (Names.validateOMRObjectName(folderName, true)) {
                        FolderInterface t = targetFolder.makeSubfolder(folderName);
                        targetFolder.update();
                        targetFolder = t;
                        continue;
                    }
                    return null;
                }
                return null;
            }
            targetFolder = tempFolder;
        }
        return targetFolder;
    }

    public static FolderInterface getFolderForPath(RepositoryInterface repository, PathUrl path, boolean create) throws RemoteException, ServiceException {
        return OMRUtils.getFolderForPath(repository.getServer(), path, create);
    }

    private static void createFolderHierarchy(List list, String pathName) {
        int index = -1;
        do {
            if ((index = pathName.indexOf("/")) != -1) {
                list.add(pathName.substring(0, index));
                pathName = pathName.substring(index + 1);
                continue;
            }
            list.add(pathName.substring(0));
            pathName = null;
        } while (pathName != null);
    }

    public static PropertyType getStringPropertyType(RepositoryInterface repos) throws RemoteException, MdException {
        try {
            Filter filter = new Filter("Name", 0, "VisualDataExplorer Property Types");
            filter.setType("Group");
            List theList = repos.search(filter);
            GroupInterface group = null;
            PropertyType stringPropertyType = null;
            if (null == theList || theList.size() < 1) {
                group = (GroupInterface)repos.newMetadata(null, "VisualDataExplorer Property Types", "Group");
                repos.addEntity(group);
            } else {
                group = (GroupInterface)theList.get(0);
            }
            List members = group.getMembers();
            for (MetadataInterface type : members) {
                if (!"String".equals(type.getName())) continue;
                stringPropertyType = (PropertyType)type.getRepositoryEntity();
                break;
            }
            if (null == stringPropertyType) {
                MetadataInterface type = repos.newMetadata(null, "String", "PropertyType");
                stringPropertyType = (PropertyType)type.getRepositoryEntity();
                stringPropertyType.setSQLType(12);
                group.addMember(type);
                repos.addEntity(type);
            }
            return stringPropertyType;
        }
        catch (Exception e) {
            throw new MdException((Throwable)e);
        }
    }

    public static Document XMLString2Doc(String xml) throws Exception {
        DocumentBuilderFactory factory = TransformerFactoryFactory.newDocumentBuilderFactory();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        return factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
    }

    public static String XMLDoc2String(Document doc) throws Exception {
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactoryFactory.newFactory();
        Transformer t = tf.newTransformer();
        t.transform(source, result);
        return writer.toString();
    }
}

