/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.configpersist;

import com.sas.services.information.metadata.configpersist.DOMDOCException;
import com.sas.services.util.TransformerFactoryFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMDoc
implements Document {
    private static final int NODE_LIST_INIT = 8;
    String fileNameQualified;
    public Document doc;
    public String fileEncoding = "UTF-8";
    protected int version = 0;
    protected boolean includeHeaders = true;
    protected Writer out;
    public static final String RB_KEY = "DOMDoc.";
    protected Logger _logger = LogManager.getLogger((String)this.getClass().getName());
    public int numOfSpaces = 0;
    public String spaces = "                                                                                                                                                                                                                                                          ";
    public String tabs = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    public int max = 250;
    public int indentIncrement = 1;
    public boolean tabBased = false;

    Document loadXML(String filename, boolean validating) {
        return this.loadXML(filename, validating, (Exception[])null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document loadXML(String filename, boolean validating, Exception[] rcException, boolean suppressException) {
        FileInputStream s = null;
        try {
            s = new FileInputStream(filename);
            Document document = this.loadXML(s, validating, rcException, suppressException);
            return document;
        }
        catch (FileNotFoundException e) {
            this._logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException ioex) {
                    this._logger.warn(ioex.getMessage(), (Throwable)ioex);
                    s = null;
                }
            }
        }
        return null;
    }

    Document loadXML(File f, boolean validating) {
        return this.loadXML(f, validating, null, false);
    }

    Document loadXML(File f, boolean validating, Exception[] rcException, boolean suppressException) {
        try {
            return this.loadXML(new FileInputStream(f), validating, rcException, suppressException);
        }
        catch (FileNotFoundException e) {
            this._logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    Document loadXML(Reader xmlDoc, boolean validating, Exception[] rcException, boolean suppressException) {
        Document d = this.loadXML(new InputSource(xmlDoc), validating, rcException, suppressException);
        try {
            xmlDoc.close();
        }
        catch (IOException eInputStream) {
            this._logger.warn(eInputStream.getMessage(), (Throwable)eInputStream);
        }
        return d;
    }

    Document loadXML(InputStream xmlDoc, boolean validating, Exception[] rcException, boolean suppressException) {
        Document d = this.loadXML(new InputSource(xmlDoc), validating, rcException, suppressException);
        try {
            xmlDoc.close();
        }
        catch (IOException eInputStream) {
            this._logger.warn(eInputStream.getMessage(), (Throwable)eInputStream);
        }
        return d;
    }

    Document loadXML(InputSource xmlDoc, boolean validating, Exception[] rcException, boolean suppressException) {
        if (xmlDoc == null) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = this.getDocumentFactoryClass();
            try {
                factory.setValidating(validating);
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                IDEEntityResolver resolver = new IDEEntityResolver();
                docBuilder.setEntityResolver(resolver);
                this.doc = docBuilder.parse(xmlDoc);
                return this.domVersionCheck();
            }
            catch (ParserConfigurationException e) {
                throw new DOMDOCException("ParserConfigurationException:" + e.getLocalizedMessage());
            }
            catch (SAXException e) {
                throw new DOMDOCException("SAXException:" + e.getLocalizedMessage());
            }
        }
        catch (IOException e) {
            this._logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private DocumentBuilderFactory getDocumentFactoryClass() {
        DocumentBuilderFactory factory = null;
        try {
            factory = TransformerFactoryFactory.newDocumentBuilderFactory();
        }
        catch (FactoryConfigurationError err) {
            throw new IllegalStateException(err.getLocalizedMessage());
        }
        return factory;
    }

    private Document domVersionCheck() {
        Element e;
        String s;
        Node comment = this.doc.getFirstChild();
        if (comment instanceof Comment && (s = comment.getNodeValue()).startsWith("DOMDoc version ")) {
            s = s.substring(14, s.length() - 1);
            float v = Float.valueOf(s).floatValue();
            this.version = Math.round(v *= 10.0f);
        }
        if ((e = this.doc.getDocumentElement()) == null) {
            return null;
        }
        this.removeEmptyText(e, 0);
        return this.doc;
    }

    public boolean loadDocument(Reader reader, boolean ValidateOnParse) {
        this.doc = this.loadXML(reader, ValidateOnParse, null, false);
        this.fileNameQualified = null;
        return this.doc != null;
    }

    public boolean loadDocument(Reader reader, boolean ValidateOnParse, boolean suppressException) {
        this.doc = this.loadXML(reader, ValidateOnParse, null, suppressException);
        this.fileNameQualified = null;
        return this.doc != null;
    }

    public boolean loadDocument(InputStream stream, boolean ValidateOnParse) {
        this.doc = this.loadXML(stream, ValidateOnParse, null, false);
        this.fileNameQualified = null;
        return this.doc != null;
    }

    public boolean loadDocument(InputStream stream, boolean ValidateOnParse, boolean suppressException) {
        this.doc = this.loadXML(stream, ValidateOnParse, null, suppressException);
        this.fileNameQualified = null;
        return this.doc != null;
    }

    public void initFromDocument(Document d) {
        this.doc = d;
    }

    public boolean loadDocument(String fullyQualifiedFileName, boolean ValidateOnParse) {
        this.doc = this.loadXML(fullyQualifiedFileName, ValidateOnParse, null, false);
        this.fileNameQualified = fullyQualifiedFileName;
        return this.doc != null;
    }

    public boolean loadDocument(String fullyQualifiedFileName, boolean ValidateOnParse, boolean suppressException) {
        this.doc = this.loadXML(fullyQualifiedFileName, ValidateOnParse, null, suppressException);
        this.fileNameQualified = fullyQualifiedFileName;
        return this.doc != null;
    }

    public void newDocument(boolean validating) {
        try {
            DocumentBuilderFactory factory = this.getDocumentFactoryClass();
            factory.setValidating(validating);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            ProcessingInstruction procString = this.doc.createProcessingInstruction("xml", "version=\"1.0\"");
            this.doc.appendChild(procString);
        }
        catch (ParserConfigurationException e) {
            this._logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocument(File outputFile) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            fos = new FileOutputStream(outputFile);
            osw = new OutputStreamWriter((OutputStream)fos, this.fileEncoding);
            this.writeDocument(osw, true);
            osw.close();
        }
        catch (IOException e) {
            this._logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException ioex) {
                    this._logger.debug(ioex.getMessage(), (Throwable)ioex);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioex) {
                    this._logger.debug(ioex.getMessage(), (Throwable)ioex);
                }
            }
        }
    }

    private boolean isVersionNode(Node check) {
        String s;
        boolean versionComment = false;
        if (check instanceof Comment && (s = ((Comment)check).getData()).trim().startsWith("DOMDoc version")) {
            ((Comment)check).setData("DOMDoc version 1.0");
            versionComment = true;
        }
        if (!versionComment) {
            this.write(this.doc.createComment("DOMDoc version 1.0"));
        }
        return versionComment;
    }

    public void writeDocument(Writer osw, boolean isFile) {
        this.writeDocument(osw, isFile, true);
    }

    public void writeDocument(Writer osw, boolean isFile, boolean includeHeaders) {
        this.includeHeaders = includeHeaders;
        try {
            this.out = osw;
            NodeList nl = this.doc.getChildNodes();
            boolean versionWritten = false;
            int nlLength = nl.getLength();
            for (int i = 0; i < nlLength; ++i) {
                Node n = nl.item(i);
                if (i == 0) {
                    if (!(n instanceof ProcessingInstruction) && isFile) {
                        this.write(this.doc.createProcessingInstruction("xml", "version=\"1.0\""));
                        this.out.write("\n");
                        this.isVersionNode(n);
                        versionWritten = true;
                    }
                    this.write(n);
                    continue;
                }
                if (i == 1) {
                    if (isFile && !versionWritten) {
                        this.isVersionNode(n);
                    }
                    this.write(n);
                    continue;
                }
                this.write(n);
            }
            if (!includeHeaders) {
                this.out.write("\n");
            }
        }
        catch (IOException e) {
            this._logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void writeDocument() {
        String s = this.fileNameQualified == null || this.fileNameQualified.equals("") ? "newtest.xml" : this.fileNameQualified;
        this.writeDocument(s);
    }

    public void writeDocument(String fullyQualifiedFileName) {
        if (fullyQualifiedFileName.equals("")) {
            fullyQualifiedFileName = "newtest.xml";
        }
        File file = new File(fullyQualifiedFileName);
        this.writeDocument(file);
    }

    public void printDocument() {
    }

    public Class DOMDoctype() {
        return this.doc.getClass();
    }

    @Override
    public Attr createAttribute(String s) {
        return this.doc.createAttribute(s);
    }

    @Override
    public CDATASection createCDATASection(String s) {
        return this.doc.createCDATASection(s);
    }

    @Override
    public Comment createComment(String s) {
        return this.doc.createComment(s);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return this.doc.createDocumentFragment();
    }

    @Override
    public Element createElement(String s) {
        return this.doc.createElement(s);
    }

    @Override
    public EntityReference createEntityReference(String s) {
        return this.doc.createEntityReference(s);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String s, String t) {
        return this.doc.createProcessingInstruction(s, t);
    }

    @Override
    public Text createTextNode(String s) {
        return this.doc.createTextNode(s);
    }

    @Override
    public DocumentType getDoctype() {
        return this.doc.getDoctype();
    }

    @Override
    public Element getDocumentElement() {
        return this.doc.getDocumentElement();
    }

    @Override
    public NodeList getElementsByTagName(String s) {
        return this.doc.getElementsByTagName(s);
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.doc.getImplementation();
    }

    @Override
    public Node appendChild(Node n) {
        return this.doc.appendChild(n);
    }

    @Override
    public Node cloneNode(boolean b) {
        return this.doc.cloneNode(b);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.doc.getAttributes();
    }

    @Override
    public NodeList getChildNodes() {
        return this.doc.getChildNodes();
    }

    @Override
    public Node getFirstChild() {
        return this.doc.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        return this.doc.getLastChild();
    }

    @Override
    public Node getNextSibling() {
        return this.doc.getNextSibling();
    }

    @Override
    public String getNodeName() {
        return this.doc.getNodeName();
    }

    @Override
    public short getNodeType() {
        return this.doc.getNodeType();
    }

    @Override
    public String getNodeValue() {
        return this.doc.getNodeValue();
    }

    @Override
    public Document getOwnerDocument() {
        return this.doc.getOwnerDocument();
    }

    @Override
    public Node getParentNode() {
        return this.doc.getParentNode();
    }

    @Override
    public Node getPreviousSibling() {
        return this.doc.getPreviousSibling();
    }

    @Override
    public boolean hasChildNodes() {
        return this.doc.hasChildNodes();
    }

    @Override
    public Node insertBefore(Node n, Node m) {
        return this.doc.insertBefore(n, m);
    }

    @Override
    public Node removeChild(Node n) {
        return this.doc.removeChild(n);
    }

    @Override
    public Node replaceChild(Node n, Node m) {
        return this.doc.replaceChild(n, m);
    }

    @Override
    public void setNodeValue(String s) {
        this.doc.setNodeValue(s);
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return this.doc.isSupported(feature, version);
    }

    public Vector getNodesByTag(Node nodeToSearch, String TagName, boolean depthSearch) {
        Vector<Node> retval = new Vector<Node>(8);
        NodeList nl = nodeToSearch.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            if (depthSearch) {
                Vector temp = this.getNodesByTag(n, TagName, depthSearch);
                if (temp != null && temp.size() > 0) {
                    retval.addAll(temp);
                }
                temp = null;
            }
            if (!((Element)n).getTagName().equals(TagName)) continue;
            retval.add(n);
        }
        return retval;
    }

    public void removeEmptyText(Node e, int level) {
        ++level;
        NodeList nl = e.getChildNodes();
        int nlLength = nl.getLength();
        int myVersion = this.version;
        for (int i = nlLength - 1; i >= 0; --i) {
            String s;
            Node n = nl.item(i);
            if (n == null) continue;
            if (n instanceof Element) {
                this.removeEmptyText(n, ++level);
                continue;
            }
            if (!(n instanceof Text)) continue;
            if (n instanceof CDATASection) {
                s = ((CDATASection)n).getData();
                if (myVersion >= 1) {
                    s = s.substring(s.indexOf(46) + 1, s.lastIndexOf(46));
                    ((CDATASection)n).setData(s);
                    continue;
                }
                s = s.trim();
                ((CDATASection)n).setData(s);
                continue;
            }
            s = ((Text)n).getData();
            if ((s = s.trim()).equals("\t")) {
                e.removeChild(n);
                continue;
            }
            if (s.equals(" ")) {
                e.removeChild(n);
                continue;
            }
            if (!s.equals("")) continue;
            e.removeChild(n);
        }
    }

    public static String toURI(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.toURL().toString();
        }
        catch (MalformedURLException ex) {
            Logger logger = LogManager.getLogger((String)DOMDoc.class.getName());
            logger.warn(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public void write(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                try {
                    this.out.write("<?xml version=\"1.0\" encoding=\"" + this.fileEncoding + "\"?>\n");
                }
                catch (IOException e) {
                    this._logger.warn(e.getMessage(), (Throwable)e);
                }
                this.write(((Document)node).getDocumentElement());
                try {
                    this.out.flush();
                }
                catch (IOException e) {
                    this._logger.warn(e.getMessage(), (Throwable)e);
                }
                break;
            }
            case 1: {
                NodeList children = node.getChildNodes();
                try {
                    this.out.write(this.getSpace() + '<');
                    this.out.write(node.getNodeName());
                }
                catch (IOException e) {
                    this._logger.warn(e.getMessage(), (Throwable)e);
                }
                Attr[] attrs = this.attrArray(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    try {
                        this.out.write(32);
                        this.out.write(attr.getNodeName());
                        this.out.write("=\"");
                        this.out.write(attr.getNodeValue());
                        this.out.write(34);
                        continue;
                    }
                    catch (IOException e) {
                        this._logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    if (children == null || children.getLength() == 0) {
                        this.out.write("/>");
                        break;
                    }
                    this.out.write(">");
                    this.increment();
                    int len = children.getLength();
                    boolean prevChildWasText = false;
                    boolean currChildIsText = false;
                    for (int i = 0; i < len; ++i) {
                        boolean bl = currChildIsText = children.item(i).getNodeType() == 3;
                        if (!currChildIsText && !prevChildWasText) {
                            this.out.write("\n");
                        }
                        prevChildWasText = currChildIsText;
                        this.write(children.item(i));
                    }
                    this.decrement();
                    if (!prevChildWasText) {
                        this.out.write('\n' + this.getSpace());
                    }
                    this.out.write("</");
                    this.out.write(node.getNodeName());
                    this.out.write(">");
                }
                catch (IOException e) {
                    this._logger.warn(e.getMessage(), (Throwable)e);
                }
                break;
            }
            case 5: {
                try {
                    this.out.write(38);
                    this.out.write(node.getNodeName());
                    this.out.write(59);
                }
                catch (IOException e) {
                    this._logger.warn(e.getMessage(), (Throwable)e);
                }
                break;
            }
            case 4: {
                try {
                    this.out.write("<![CDATA[.");
                    this.out.write(node.getNodeValue());
                    this.out.write(".]]>");
                }
                catch (IOException e) {
                    this._logger.warn(e.getMessage(), (Throwable)e);
                }
                break;
            }
            case 3: {
                try {
                    this.out.write(node.getNodeValue());
                }
                catch (IOException e) {
                    this._logger.warn(e.getMessage(), (Throwable)e);
                }
                break;
            }
            case 7: {
                if (this.includeHeaders) {
                    try {
                        this.out.write("<?");
                        this.out.write(node.getNodeName());
                    }
                    catch (Exception e) {
                        this._logger.warn(e.getMessage(), (Throwable)e);
                    }
                    String data = node.getNodeValue();
                    if (data != null && data.length() > 0) {
                        try {
                            this.out.write(32);
                            this.out.write(data);
                        }
                        catch (Exception e) {
                            this._logger.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                    try {
                        this.out.write("?>\n");
                    }
                    catch (IOException e) {
                        this._logger.warn(e.getMessage(), (Throwable)e);
                    }
                    break;
                }
            }
            case 8: {
                if (!this.includeHeaders) break;
                try {
                    this.out.write("<!--");
                    this.out.write(node.getNodeValue());
                    this.out.write("-->\n");
                    break;
                }
                catch (IOException e) {
                    this._logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this._logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void setFormatOptions(int initialIndent, int indentIncrement, boolean tabBased) {
        this.numOfSpaces = initialIndent;
        this.indentIncrement = indentIncrement;
        this.tabBased = tabBased;
    }

    public String getSpace() {
        return this.numOfSpaces <= 0 ? "" : (!this.tabBased ? this.spaces.substring(0, this.numOfSpaces) : this.tabs.substring(0, this.numOfSpaces));
    }

    public void increment() {
        if (this.numOfSpaces + this.indentIncrement < this.max) {
            this.numOfSpaces += this.indentIncrement;
        }
    }

    public void decrement() {
        if (this.numOfSpaces - this.indentIncrement >= 0) {
            this.numOfSpaces -= this.indentIncrement;
        }
    }

    protected Attr[] attrArray(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        return array;
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        return this.doc.createAttributeNS(namespaceURI, qualifiedName);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) {
        return this.doc.createElementNS(namespaceURI, qualifiedName);
    }

    @Override
    public Element getElementById(String tagname) {
        return this.doc.getElementById(tagname);
    }

    @Override
    public String getLocalName() {
        return this.doc.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.doc.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.doc.getPrefix();
    }

    @Override
    public boolean hasAttributes() {
        return this.doc.hasAttributes();
    }

    @Override
    public void normalize() {
        this.doc.normalize();
    }

    @Override
    public void setPrefix(String prefix) {
        this.doc.setPrefix(prefix);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.doc.getElementsByTagNameNS(namespaceURI, localName);
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) {
        return this.doc.importNode(importedNode, deep);
    }

    @Override
    public String getInputEncoding() {
        return this.doc.getInputEncoding();
    }

    @Override
    public String getXmlEncoding() {
        return this.doc.getXmlEncoding();
    }

    @Override
    public boolean getXmlStandalone() {
        return this.doc.getXmlStandalone();
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.doc.setXmlStandalone(xmlStandalone);
    }

    @Override
    public String getXmlVersion() {
        return this.doc.getXmlVersion();
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        this.doc.setXmlVersion(xmlVersion);
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.doc.getStrictErrorChecking();
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.doc.setStrictErrorChecking(strictErrorChecking);
    }

    @Override
    public String getDocumentURI() {
        return this.doc.getDocumentURI();
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.doc.setDocumentURI(documentURI);
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        return this.doc.adoptNode(source);
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.doc.getDomConfig();
    }

    @Override
    public void normalizeDocument() {
        this.doc.normalizeDocument();
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return this.doc.renameNode(n, namespaceURI, qualifiedName);
    }

    @Override
    public String getBaseURI() {
        return this.doc.getBaseURI();
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return this.doc.compareDocumentPosition(other);
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.doc.getTextContent();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.doc.setTextContent(textContent);
    }

    @Override
    public boolean isSameNode(Node other) {
        return this.doc.isSameNode(other);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this.doc.lookupPrefix(namespaceURI);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.doc.isDefaultNamespace(namespaceURI);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.doc.lookupNamespaceURI(prefix);
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return this.doc.isEqualNode(arg);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return this.doc.getFeature(feature, version);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.doc.setUserData(key, data, handler);
    }

    @Override
    public Object getUserData(String key) {
        return this.doc.getUserData(key);
    }

    public class IDEEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN") || systemId.equals("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd")) {
                InputStream input = IDEEntityResolver.class.getResourceAsStream("/com/sas/ide/jspdtds/web-app_2_2.dtd");
                if (input == null) {
                    return null;
                }
                InputSource isrc = new InputSource(input);
                return isrc;
            }
            if (publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN") || systemId.equals("http://java.sun.com/dtd/web-app_2_3.dtd")) {
                InputStream input = this.getClass().getResourceAsStream("/com/sas/ide/jspdtds/web-app_2_3.dtd");
                if (input == null) {
                    return null;
                }
                InputSource isrc = new InputSource(input);
                return isrc;
            }
            if (publicId.equals("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN")) {
                InputStream input = this.getClass().getResourceAsStream("/com/sas/ide/jspdtds/web-jsptaglib_1_1.dtd");
                if (input == null) {
                    return null;
                }
                InputSource isrc = new InputSource(input);
                return isrc;
            }
            if (publicId.equals("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN")) {
                InputStream input = this.getClass().getResourceAsStream("/com/sas/ide/jspdtds/web-jsptaglib_1_2.dtd");
                if (input == null) {
                    return null;
                }
                InputSource isrc = new InputSource(input);
                return isrc;
            }
            return null;
        }
    }
}

