/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.businessruleflow;

import com.sas.services.information.metadata.businessruleflow.RB;
import com.sas.services.information.metadata.businessruleflow.TermInterface;
import com.sas.services.information.metadata.businessruleflow.TermUtil;
import java.util.HashMap;
import java.util.Map;

public class Term
implements TermInterface {
    private static final long serialVersionUID = 100L;
    private String _id;
    private String _name;
    private String _dataType;
    private String _description;
    private static Map<String, String> _dataTypeNames = new HashMap<String, String>();

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setDataType(String dataType) {
        boolean isknownType = false;
        for (TermUtil.DataType type : TermUtil.DataType.values()) {
            if (!dataType.equals(type.getDataType())) continue;
            this._dataType = dataType;
            isknownType = true;
        }
        if (!isknownType) {
            this._dataType = "Unknown";
        }
    }

    @Override
    public String getDataType() {
        return this._dataType;
    }

    @Override
    public void setDescription(String desc) {
        this._description = desc;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getDisplayableDataType() {
        String dataTypeIndex = _dataTypeNames.get(this._dataType);
        return RB.getStringResource(dataTypeIndex);
    }

    static {
        _dataTypeNames.put(TermUtil.DataType.DATATYPE_STRING.getDataType(), "BrmSmartObject.DataType.String.txt");
        _dataTypeNames.put(TermUtil.DataType.DATATYPE_DATAGRID.getDataType(), "BrmSmartObject.DataType.Datagrid.txt");
        _dataTypeNames.put(TermUtil.DataType.DATATYPE_BOOLEAN.getDataType(), "BrmSmartObject.DataType.Boolean.txt");
        _dataTypeNames.put(TermUtil.DataType.DATATYPE_DATE.getDataType(), "BrmSmartObject.DataType.Date.txt");
        _dataTypeNames.put(TermUtil.DataType.DATATYPE_DATETIME.getDataType(), "BrmSmartObject.DataType.Datetime.txt");
        _dataTypeNames.put(TermUtil.DataType.DATATYPE_INTEGER.getDataType(), "BrmSmartObject.DataType.Integer.txt");
        _dataTypeNames.put(TermUtil.DataType.DATATYPE_REAL.getDataType(), "BrmSmartObject.DataType.Decimal.txt");
        _dataTypeNames.put(TermUtil.DataType.DATATYPE_UNKNOWN.getDataType(), "BrmSmartObject.DataType.Unknown.txt");
    }
}

