/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.businessruleflow;

import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.metadata.remote.impl.TransformationImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryData;
import com.sas.services.information.RepositoryDef;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.ContentInterface;
import com.sas.services.information.metadata.DocumentInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRProperty;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.metadata.businessruleflow.BRMDAVUnavailableException;
import com.sas.services.information.metadata.businessruleflow.BusinessRuleFlowInterface;
import com.sas.services.information.metadata.businessruleflow.DataSet;
import com.sas.services.information.metadata.businessruleflow.DataSetInterface;
import com.sas.services.information.metadata.businessruleflow.RB;
import com.sas.services.information.metadata.businessruleflow.Term;
import com.sas.services.information.metadata.businessruleflow.TermInterface;
import com.sas.services.information.metadata.businessruleflow.XMLUtil;
import com.sas.services.information.metadata.dav.DAVItem;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.TransformerFactoryFactory;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BusinessRuleFlowSmartObject
extends Metadata
implements BusinessRuleFlowInterface {
    public static UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private static final long serialVersionUID = 1L;
    private DAVRepositoryInterface _davRepos;
    private String _davReposId;
    private MetadataInterface _davContent;

    public BusinessRuleFlowSmartObject() throws RemoteException {
    }

    public BusinessRuleFlowSmartObject(Transformation o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public BusinessRuleFlowSmartObject(TransformationImpl o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public BusinessRuleFlowSmartObject(TransformationImpl_Stub o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public BusinessRuleFlowSmartObject(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        if (null == repos || null == name || !(repos instanceof OMIRepositoryInterface)) {
            throw new IllegalArgumentException();
        }
        try {
            OMIRepositoryInterface omiRepos = (OMIRepositoryInterface)repos;
            Transformation transf = (Transformation)omiRepos.createMetadata(name, "Transformation");
            transf.setPublicType("BusinessRuleFlow");
            transf.setTransformRole("BusinessRuleFlow");
            transf.setUsageVersion(CURRENT_VERSION.encode());
            transf.setName(name);
            this._repositoryObject = transf;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            this.setDAVReposID(this.getDavPath() + name + "/item");
            this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
            if (parent != null) {
                try {
                    parent.addItem(this);
                }
                catch (ServiceException ex) {
                    transf.delete();
                    this.logThrowable(Level.WARN, ex.getMessage(), this.getClass().toString(), (Throwable)((Object)ex));
                }
            }
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, ex.getMessage(), this.getClass().toString(), (Throwable)((Object)ex));
        }
    }

    @Override
    public String getDavPath() throws ServiceException, RemoteException {
        List objectProps = this.getObjectProperties();
        for (Object object : objectProps) {
            OMRProperty prop = (OMRProperty)object;
            if (!prop.getName().equals("davpath")) continue;
            return prop.getValue();
        }
        return null;
    }

    @Override
    public void setDavPath(String path) throws ServiceException, RemoteException {
        this.addObjectProperty("davpath", "davpath", path, "String");
    }

    @Override
    public String getType() throws RemoteException {
        return "BusinessRuleFlow";
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        this.logMessage(Level.DEBUG, "delete rule flow object");
        super.delete();
    }

    @Override
    public void setDAVRepository(DAVRepositoryInterface davRepos) throws ServiceException, RemoteException {
        this._davRepos = davRepos;
        this.logMessage(Level.DEBUG, "Set DAV repository " + this._davRepos.getHttpUrl());
    }

    private RepositoryDef getDavRepositoryDef() throws RemoteException, ServiceException {
        RepositoryInterface repo = this.getRepository();
        ServerInterface server = repo.getServer();
        RootFolderInterface root = server.getRootFolder();
        List docs = root.getDocuments();
        DocumentInterface repoMapping = null;
        for (Object object : docs) {
            DocumentInterface doc = (DocumentInterface)object;
            if (!doc.getName().equals("Report Repository Content Mapping")) continue;
            repoMapping = doc;
            break;
        }
        if (null == repoMapping || null == repoMapping.getURI() || repoMapping.getURI().length() <= 0) {
            throw new BRMDAVUnavailableException(RB.getStringResource("BrmSmartObject.getdav.ex.txt"));
        }
        String uri = repoMapping.getURI();
        try {
            URL url = new URI(uri).toURL();
            String port = url.getPort() == -1 ? String.valueOf(url.getDefaultPort()) : String.valueOf(url.getPort());
            String davroot = url.getPath();
            davroot = this.trimBasePath(davroot);
            RepositoryDef def = new RepositoryDef(url.getHost(), port, null, davroot, "dav");
            if ("https".equalsIgnoreCase(url.getProtocol())) {
                def.setIsSecure(true);
            }
            return def;
        }
        catch (MalformedURLException ex) {
            throw new ServiceException(ex);
        }
        catch (URISyntaxException es) {
            throw new ServiceException(es);
        }
    }

    private String trimBasePath(String davroot) {
        if (davroot != null) {
            int index;
            if (davroot.endsWith("/")) {
                davroot = davroot.substring(0, davroot.length() - 1);
            }
            if ((index = davroot.lastIndexOf(47)) != -1) {
                davroot = davroot.substring(0, index + 1);
            }
        }
        return davroot;
    }

    private DAVRepositoryInterface getDAVRepository() throws ServiceException, RemoteException {
        if (this._davRepos == null) {
            UserContextInterface userContext = this.getRepository().getUserContext();
            RepositoryDef def = this.getDavRepositoryDef();
            if (def.getDomain() == null) {
                RepositoryInterface omiRepo = this.getRepository();
                def.setDomain(omiRepo.getDomain());
            }
            this._davRepos = (DAVRepositoryInterface)BusinessRuleFlowSmartObject.getInformationService().connect(userContext, def);
        }
        return this._davRepos;
    }

    protected void setDAVReposID(String id) throws ServiceException, RemoteException {
        this._davReposId = id;
        this.logMessage(Level.DEBUG, "DAV repoID: " + this._davReposId);
    }

    protected MetadataInterface getDAVContent() throws ServiceException, RemoteException {
        this.logMessage(Level.DEBUG, "Get DAV Content");
        if (null == this._davContent) {
            this.setDAVReposID(this.getDavPath() + this.getName() + "/item");
            this._davContent = this.getDAVRepository().fetch(this._davReposId);
        }
        if (null != this._davContent) {
            this.logMessage(Level.DEBUG, "Get DAV Content: " + this._davContent.getEntityURL());
        }
        return this._davContent;
    }

    protected RepositoryData getRepoData() throws ServiceException, RemoteException {
        this.logMessage(Level.DEBUG, "Get DAV Repo data");
        if (null == this._davContent) {
            this.setDAVReposID(this.getDavPath() + this.getName() + "/item");
        }
        return this.getDAVRepository().fetchRepositoryData(this._davReposId);
    }

    protected MetadataInterface getDAVContentForVersion(String version) throws ServiceException, RemoteException {
        MetadataInterface verContent = ((ContentInterface)this.getDAVContent()).getVersion(version);
        if (null == verContent) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"BrmSmartObject.getdav4version.ex.txt.fmt", (Object)version));
        }
        this.logMessage(Level.DEBUG, "Get DAV Content for version: " + verContent.getEntityURL());
        return verContent;
    }

    protected Document parse(InputStream in) throws ServiceException, RemoteException {
        this.logMessage(Level.DEBUG, "Parse xml input");
        Document doc = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = TransformerFactoryFactory.newDocumentBuilderFactory();
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            doc = builder.parse(in);
        }
        catch (IOException ioe) {
            this.logThrowable(Level.ERROR, ioe.getMessage(), this.getClass().toString(), ioe);
        }
        catch (ParserConfigurationException pce) {
            this.logThrowable(Level.ERROR, pce.getMessage(), this.getClass().toString(), pce);
        }
        catch (SAXException saxe) {
            this.logThrowable(Level.ERROR, saxe.getMessage(), this.getClass().toString(), saxe);
        }
        return doc;
    }

    @Override
    public List<String> getVersions() throws ServiceException, RemoteException {
        this.logMessage(Level.DEBUG, "Get version list");
        return this.getDAVContent().getPreviousVersionNames();
    }

    @Override
    public byte[] getXml(String version) throws ServiceException, RemoteException {
        this.logMessage(Level.DEBUG, "Get xml for version");
        return ((ContentInterface)this.getDAVContentForVersion(version)).getContentAsBytes();
    }

    @Override
    public List<DataSetInterface> getInputsForVersion(String version) throws ServiceException, RemoteException {
        this.logMessage(Level.DEBUG, "Get input list for version");
        ArrayList<DataSetInterface> inputs = new ArrayList<DataSetInterface>();
        InputStream in = ((ContentInterface)this.getDAVContentForVersion(version)).getContentAsStream();
        Document doc = this.parse(in);
        Node input = XMLUtil.getNode(doc, "/sas:decisionFlow/sas:input");
        String dataSetId = XMLUtil.getAttributeValue(input, "dataSetId");
        StringBuilder xpath_dataSet = new StringBuilder("/sas:decisionFlow/sas:dataSets/sas:dataSet");
        XMLUtil.appendXPathAttribute(xpath_dataSet, "id", dataSetId);
        Node dataSet = XMLUtil.getNode(doc, xpath_dataSet.toString());
        String dataSetName = XMLUtil.getAttributeValue(dataSet, "name");
        xpath_dataSet.append("/sas:");
        xpath_dataSet.append("termReference");
        NodeList termRefs = XMLUtil.getNodeList(doc, xpath_dataSet.toString());
        Map<String, TermInterface> cachedTerms = this.buildDomTermCache(doc);
        ArrayList<TermInterface> terms = new ArrayList<TermInterface>();
        if (null != termRefs && termRefs.getLength() > 0) {
            for (int i = 0; i < termRefs.getLength(); ++i) {
                Node termRef = termRefs.item(i);
                String termId = XMLUtil.getAttributeValue(termRef, "termId");
                TermInterface term = cachedTerms.get(termId);
                terms.add(term);
            }
        }
        DataSet ds = new DataSet(dataSetId, dataSetName, terms);
        inputs.add(ds);
        return inputs;
    }

    private String extractTermDescription(Document doc, StringBuilder xpath) {
        Node shortDesc = XMLUtil.getNode(doc, xpath + "/sas:" + "shortDesc");
        String shortDescValue = "";
        if (shortDesc != null && shortDesc.getFirstChild() != null) {
            shortDescValue = shortDesc.getFirstChild().getNodeValue();
        }
        return shortDescValue;
    }

    @Override
    public List<DataSetInterface> getOutputsForVersion(String version) throws ServiceException, RemoteException {
        this.logMessage(Level.DEBUG, "Get output list for version");
        ArrayList<DataSetInterface> outputs = new ArrayList<DataSetInterface>();
        InputStream in = ((ContentInterface)this.getDAVContentForVersion(version)).getContentAsStream();
        Document doc = this.parse(in);
        Node input = XMLUtil.getNode(doc, "/sas:decisionFlow/sas:input");
        String inputDataSetId = XMLUtil.getAttributeValue(input, "dataSetId");
        boolean hasRuleFiredDataSets = this.hasRuleFireDataSets(doc);
        NodeList dataSets = XMLUtil.getNodeList(doc, "/sas:decisionFlow/sas:dataSets/sas:dataSet");
        Map<String, TermInterface> cachedTerms = this.buildDomTermCache(doc);
        for (int i = 0; i < dataSets.getLength(); ++i) {
            Node dataSet = dataSets.item(i);
            String id = XMLUtil.getAttributeValue(dataSet, "id");
            String name = XMLUtil.getAttributeValue(dataSet, "name");
            if (id.equals(inputDataSetId) || XMLUtil.isRuleFiredTable(id, name) && hasRuleFiredDataSets) continue;
            ArrayList<TermInterface> terms = null;
            NodeList termRefs = XMLUtil.getNodeList(dataSet, "sas:termReference");
            if (termRefs == null || termRefs.getLength() == 0) continue;
            if (null != termRefs && termRefs.getLength() > 0) {
                terms = new ArrayList<TermInterface>();
                for (int j = 0; j < termRefs.getLength(); ++j) {
                    Node termRef = termRefs.item(j);
                    String termId = XMLUtil.getAttributeValue(termRef, "termId");
                    TermInterface term = cachedTerms.get(termId);
                    terms.add(term);
                }
            }
            outputs.add(new DataSet(id, name, terms));
        }
        return outputs;
    }

    private Map<String, TermInterface> buildDomTermCache(Document doc) {
        NodeList domTerms = XMLUtil.getNodeList(doc, "/sas:decisionFlow/sas:terms/sas:term");
        HashMap<String, TermInterface> cachedTerms = new HashMap<String, TermInterface>();
        for (int j = 0; j < domTerms.getLength(); ++j) {
            Node term = domTerms.item(j);
            String termId = XMLUtil.getAttributeValue(term, "id");
            NodeList termChildren = term.getChildNodes();
            boolean nameFound = false;
            boolean descriptionFound = false;
            boolean dataTypeFound = false;
            String name = "";
            String datatype = "";
            String shortDescValue = "";
            for (int i = 0; i < termChildren.getLength(); ++i) {
                Node child = termChildren.item(i);
                if (child.getNodeName().equals("name")) {
                    if (child.getFirstChild() != null) {
                        name = child.getFirstChild().getNodeValue();
                    }
                    nameFound = true;
                } else if (child.getNodeName().equals("dataType")) {
                    if (child.getFirstChild() != null) {
                        datatype = child.getFirstChild().getNodeValue();
                    }
                    dataTypeFound = true;
                } else if (child.getNodeName().equals("shortDesc")) {
                    if (child.getFirstChild() != null) {
                        shortDescValue = child.getFirstChild().getNodeValue();
                    }
                    descriptionFound = true;
                }
                if (dataTypeFound && nameFound && descriptionFound) break;
            }
            Term termdto = new Term();
            termdto.setId(termId);
            termdto.setName(name);
            termdto.setDataType(datatype);
            termdto.setDescription(shortDescValue);
            cachedTerms.put(termId, termdto);
        }
        return cachedTerms;
    }

    @Override
    public String addVersion(byte[] xml) throws ServiceException, RemoteException {
        MetadataInterface content = this.getDAVContent();
        if (null == content) {
            this.logMessage(Level.DEBUG, "Add a new content");
            content = this.getDAVRepository().newMetadata(this._davReposId, this.getName(), "item");
            ((ContentInterface)content).setContentFromBytes(xml);
            this.getDAVRepository().addEntity(content);
            content.version();
        } else {
            this.logMessage(Level.DEBUG, "Check in a new version");
            ContentInterface newVersion = (ContentInterface)content;
            RepositoryData data = this.getRepoData();
            DAVItem updateEntity = new DAVItem(data);
            this.getDAVRepository().checkout(newVersion);
            updateEntity.setContents(xml);
            this.getDAVRepository().updateEntity(updateEntity);
            this.getDAVRepository().checkin(newVersion);
        }
        return this.defaultVersion();
    }

    @Override
    public void deleteVersion(String version) throws ServiceException, RemoteException {
        this.logMessage(Level.DEBUG, "Delete a version");
        if (null == this.getVersions() || this.getVersions().size() <= 1) {
            throw new RuntimeException("At least one version is requried");
        }
        ContentInterface content = (ContentInterface)this.getDAVContentForVersion(version);
        content.delete();
    }

    @Override
    public String defaultVersion() throws ServiceException, RemoteException {
        List<String> allVersions = this.getVersions();
        Collections.sort(allVersions, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int o1_dotIndex = o1.indexOf(".");
                int o1_major = Integer.valueOf(o1.substring(0, o1_dotIndex));
                int o1_minor = Integer.valueOf(o1.substring(o1_dotIndex + 1));
                int o2_dotIndex = o2.indexOf(".");
                int o2_major = Integer.valueOf(o2.substring(0, o2_dotIndex));
                int o2_minor = Integer.valueOf(o2.substring(o2_dotIndex + 1));
                if (o1_major > o2_major) {
                    return 1;
                }
                if (o1_major < o2_major) {
                    return -1;
                }
                if (o1_minor > o2_minor) {
                    return 1;
                }
                if (o1_minor < o2_minor) {
                    return -1;
                }
                return 0;
            }
        });
        return allVersions.get(allVersions.size() - 1);
    }

    @Override
    public List<DataSetInterface> getRulesFiredOutput(String version) throws ServiceException, RemoteException {
        this.logMessage(Level.DEBUG, "Get rules fired list for version");
        ArrayList<DataSetInterface> output = new ArrayList<DataSetInterface>();
        InputStream in = ((ContentInterface)this.getDAVContentForVersion(version)).getContentAsStream();
        Document doc = this.parse(in);
        if (!this.hasRuleFireDataSets(doc)) {
            return new ArrayList<DataSetInterface>();
        }
        Map<String, TermInterface> cachedTerms = this.buildDomTermCache(doc);
        NodeList dataSets = XMLUtil.getNodeList(doc, "/sas:decisionFlow/sas:dataSets/sas:dataSet");
        for (int i = 0; i < dataSets.getLength(); ++i) {
            Node dataSet = dataSets.item(i);
            String dataSetName = XMLUtil.getAttributeValue(dataSet, "name");
            String dataSetId = XMLUtil.getAttributeValue(dataSet, "id");
            if (!XMLUtil.isRuleFiredTable(dataSetId, dataSetName)) continue;
            NodeList termRefs = XMLUtil.getNodeList(dataSet, "sas:termReference");
            ArrayList<TermInterface> terms = new ArrayList<TermInterface>();
            for (int j = 0; j < termRefs.getLength(); ++j) {
                Node termRef = termRefs.item(j);
                String termId = XMLUtil.getAttributeValue(termRef, "termId");
                TermInterface term = cachedTerms.get(termId);
                terms.add(term);
            }
            DataSet ds = new DataSet(dataSetId, dataSetName, terms);
            output.add(ds);
        }
        return output;
    }

    private boolean hasRuleFireDataSets(Document doc) throws ServiceException {
        try {
            NodeList dataSets = XMLUtil.XPathAPI_selectNodeList(doc, "/sas:decisionFlow/sas:dataSets/sas:dataSet");
            return dataSets.getLength() > 2;
        }
        catch (TransformerException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public List<TermInterface> getParameters(String version) throws ServiceException, RemoteException {
        this.logMessage(Level.DEBUG, "Get parameters list for version");
        ArrayList<Term> params = null;
        InputStream in = ((ContentInterface)this.getDAVContentForVersion(version)).getContentAsStream();
        Document doc = this.parse(in);
        StringBuilder xpath_para_term = new StringBuilder("/sas:decisionFlow/sas:terms/sas:term");
        XMLUtil.appendXPathAttribute(xpath_para_term, "parameter", "true");
        NodeList terms = XMLUtil.getNodeList(doc, xpath_para_term.toString());
        if (null != terms && terms.getLength() > 0) {
            params = new ArrayList<Term>();
            for (int i = 0; i < terms.getLength(); ++i) {
                Node termRef = terms.item(i);
                String termId = XMLUtil.getAttributeValue(termRef, "id");
                NodeList termChildren = termRef.getChildNodes();
                String termNameValue = "";
                String dataTypeValue = "";
                String shortDescValue = "";
                for (int j = 0; j < termChildren.getLength(); ++j) {
                    Node child = termChildren.item(j);
                    if (child.getNodeName().equals("name")) {
                        if (child.getFirstChild() == null) continue;
                        termNameValue = child.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (child.getNodeName().equals("dataType")) {
                        if (child.getFirstChild() == null) continue;
                        dataTypeValue = child.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (!child.getNodeName().equals("shortDesc") || child.getFirstChild() == null) continue;
                    shortDescValue = child.getFirstChild().getNodeValue();
                }
                Term term = new Term();
                term.setId(termId);
                term.setName(termNameValue);
                term.setDataType(dataTypeValue);
                term.setDescription(shortDescValue);
                params.add(term);
            }
        }
        return params;
    }

    @Override
    public Map<String, Integer> getRulesFiredColumnLengths() throws ServiceException, RemoteException {
        HashMap<String, Integer> lengths = new HashMap<String, Integer>();
        lengths.put("DCM_RULE_ACTION_FIRE.RULE_ACTION_FIRE_ID", 36);
        lengths.put("DCM_RULE_ACTION_FIRE.RULE_SET_SK", 8);
        lengths.put("DCM_RULE_ACTION_FIRE.RULE_SET_NM", 100);
        lengths.put("DCM_RULE_ACTION_FIRE.RULE_SK", 8);
        lengths.put("DCM_RULE_ACTION_FIRE.RULE_NM", 100);
        lengths.put("DCM_RULE_ACTION_FIRE.DEPLMT_SK", 8);
        lengths.put("DCM_RULE_ACTION_FIRE.RULE_FLOW_SK", 8);
        lengths.put("DCM_RULE_ACTION_FIRE.RULE_FLOW_NM", 100);
        lengths.put("DCM_RULE_ACTION_FIRE.RULE_FIRE_DTTM", 8);
        lengths.put("DCM_RULE_ACTION_FIRE.ENTIRE_RULE_CONDITION_TXT", 4000);
        lengths.put("DCM_RULE_ACTION_FIRE.ENTIRE_RULE_ACTION_TXT", 4000);
        lengths.put("DCM_RULE_ACTION_FIRE.DEPLMT_EXECUTION_ID", 36);
        lengths.put("DCM_RULE_ACTION_FIRE.ENTITY_PRIMARY_KEY", 1024);
        lengths.put("DCM_RULE_ACTION_FIRE.TRANSACTION_DTTM", 8);
        lengths.put("DCM_DEPLOYMENT_EXECUTION.DEPLMT_EXECUTION_ID", 36);
        lengths.put("DCM_DEPLOYMENT_EXECUTION.DEPLMT_SK", 8);
        lengths.put("DCM_DEPLOYMENT_EXECUTION.DEPLMT_NM", 100);
        lengths.put("DCM_DEPLOYMENT_EXECUTION.TRANSACTION_MODE_CD", 20);
        lengths.put("DCM_DEPLOYMENT_EXECUTION.RECORDS_PROCESSED_NO", 8);
        lengths.put("DCM_DEPLOYMENT_EXECUTION.TEST_FLG", 1);
        lengths.put("DCM_DEPLOYMENT_EXECUTION.START_DTTM", 8);
        lengths.put("DCM_DEPLOYMENT_EXECUTION.END_DTTM", 8);
        lengths.put("DCM_DEPLMT_EXEC_PARAMETER.DEPLMT_EXEC_PARAMETER_SK", 8);
        lengths.put("DCM_DEPLMT_EXEC_PARAMETER.DEPLMT_EXECUTION_ID", 36);
        lengths.put("DCM_DEPLMT_EXEC_PARAMETER.PARAMETER_NM", 100);
        lengths.put("DCM_DEPLMT_EXEC_PARAMETER.PARAMETER_AT_EXEC_VALUE", 1000);
        lengths.put("DCM_DEPLMT_EXEC_PARAMETER.PARM_VOCAB_TERM_SK", 8);
        return lengths;
    }

    @Override
    public boolean contentExists() throws ServiceException, RemoteException {
        return null != this.getDAVContent();
    }

    @Override
    public void deleteContents() throws ServiceException, RemoteException {
        if (null != this.getDAVContent()) {
            this.getDAVRepository().deleteEntity(this.getDAVContent());
            this._davContent = null;
        }
    }

    @Override
    public String getCode(String version) throws ServiceException, RemoteException {
        String result = "";
        byte[] xmlContent = this.getXml(version);
        Document doc = this.parse(new ByteArrayInputStream(xmlContent));
        if (doc == null) {
            throw new RemoteException();
        }
        Node code = XMLUtil.getNode(doc, "/sas:decisionFlow/sas:code");
        if (code == null) {
            try {
                result = new String(xmlContent, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                result = new String(xmlContent);
            }
        } else {
            result = code.getTextContent();
        }
        return result;
    }
}

