/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.ServerComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.ServerInterface;
import java.rmi.RemoteException;
import java.util.List;

@SASScope
public class UniqueNameValidator {
    private boolean nestedNamevalidate;
    private ValidatorContext context;
    private com.sas.services.information.ServerInterface server;

    protected UniqueNameValidator(ValidatorContext context) {
        this.context = context;
    }

    public static UniqueNameValidator getRepositoryNameValidator() {
        return new UniqueNameValidator(ValidatorContext.REPOSITORY);
    }

    public static UniqueNameValidator getServerNameValidator() {
        return new UniqueNameValidator(ValidatorContext.SERVER);
    }

    public boolean isNestedNamevalidate() {
        return this.nestedNamevalidate;
    }

    public void setNestedNamevalidate(boolean nestedNamevalidate) {
        this.nestedNamevalidate = nestedNamevalidate;
    }

    public ValidatorContext getContext() {
        return this.context;
    }

    public void setContext(ValidatorContext context) {
        this.context = context;
    }

    public com.sas.services.information.ServerInterface getServer() {
        return this.server;
    }

    public void setServer(com.sas.services.information.ServerInterface server) {
        this.server = server;
    }

    public boolean validateName(ServerInterface server, String name) throws ServiceException, RemoteException {
        try {
            this.setServer(server.getRepository().getServer());
            String objType = ((ServerComponent)server.getRepositoryEntity()).getCMetadataType();
            return this.validateName(name, objType);
        }
        catch (ServiceException se) {
            throw new ServiceException((Throwable)((Object)se), se.getMessage());
        }
        catch (RemoteException re) {
            new RemoteException(re.getMessage(), re);
        }
        catch (Exception e) {
            new ServiceException(e, e.getMessage());
        }
        return false;
    }

    protected boolean validateName(String objName, String objType) throws Exception {
        switch (this.context.ordinal()) {
            case 0: {
                for (Object obj : this.server.getRepositories(true)) {
                    if (this.isObjectNameUnique((RepositoryInterface)obj, objName, objType)) continue;
                    return false;
                }
                break;
            }
            case 1: {
                if (this.isObjectNameUnique(this.server, objName, objType)) break;
                return false;
            }
        }
        return true;
    }

    protected boolean isObjectNameUnique(RepositoryInterface repo, String objName, String objType) throws ServiceException, RemoteException {
        Filter filter = new Filter();
        FilterComponent fc = new FilterComponent("Name", 0, objName);
        filter.setType(objType);
        filter.setFilterComponent(fc);
        List machineList = repo.search(filter);
        return machineList.size() == 0;
    }

    protected boolean isObjectNameUnique(com.sas.services.information.ServerInterface server, String objName, String objType) throws ServiceException, RemoteException {
        Filter filter = new Filter();
        FilterComponent fc = new FilterComponent("Name", 0, objName);
        filter.setType(objType);
        filter.setFilterComponent(fc);
        List machineList = server.search(filter);
        return machineList.size() == 0;
    }

    protected static enum ValidatorContext {
        REPOSITORY,
        SERVER;

    }
}

