/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.metadata.KeywordFilter;
import java.util.Iterator;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class RemarksFilter
extends KeywordFilter {
    private static final long serialVersionUID = 4951317807052144606L;
    private static final int SELECT_BUFFER_INIT = 128;
    private String _name;
    private String _threadId;

    public RemarksFilter() {
        this.setType("Remarks");
        this._name = null;
        this._threadId = null;
    }

    public RemarksFilter(String key, int relation, String value) {
        super(key, relation, value);
        this.setType("Remarks");
        this._name = null;
        this._threadId = null;
    }

    @Override
    public String getOMRType() {
        return "";
    }

    @Override
    public String getDAVType() {
        return "remarks";
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    public String getThreadId() {
        return this._threadId;
    }

    public void setThreadId(String threadId) {
        this._threadId = threadId;
    }

    @Override
    public String getXMLSelectString() {
        StringBuffer buffer = new StringBuffer(128);
        if (this._name != null || this._keywords.size() > 0) {
            buffer.append("<XMLSelect Search=\"*");
            if (this._name != null) {
                buffer.append("[@Name='" + this._name + "']");
            }
            if (this._keywords.size() > 0) {
                buffer.append("[Keywords/*[");
                Iterator it = this._keywords.iterator();
                boolean firstName = true;
                while (it.hasNext()) {
                    if (!firstName) {
                        buffer.append(" OR ");
                    }
                    buffer.append("@Name='" + (String)it.next() + '\'');
                    firstName = false;
                }
                buffer.append(" ]]");
            }
            buffer.append("\" />\n");
        }
        return buffer.toString();
    }

    @Override
    public String getDAVBasicSearchString() {
        FilterComponent compy = this._component;
        FilterComponent nameComp = new FilterComponent();
        FilterComponent keywordComp = null;
        FilterComponent threadComp = null;
        if (this._name != null) {
            nameComp.setFilter("{http://www.sas.com/xml/namespace/services.webdav-1.1}name", 0, this._name);
        }
        if (this._threadId != null) {
            threadComp = new FilterComponent("{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}threadid", 0, this._threadId);
            nameComp.addComponent(threadComp);
            nameComp.setAggregation(0);
        }
        if (this._keywords.size() > 0) {
            keywordComp = new FilterComponent();
            for (String keyword : this._keywords) {
                keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}saskeyword", 1, keyword));
            }
            keywordComp.setAggregation(1);
        }
        if (keywordComp != null) {
            nameComp.addComponent(keywordComp);
            nameComp.setAggregation(0);
        }
        if (compy != null) {
            nameComp.addComponent(compy);
            nameComp.setAggregation(0);
        }
        this.setFilterComponent(nameComp);
        String result = super.getDAVBasicSearchString();
        this.setFilterComponent(compy);
        return result;
    }

    @Override
    public String getDAVSQLString() {
        FilterComponent compy = this._component;
        FilterComponent nameComp = new FilterComponent();
        FilterComponent keywordComp = null;
        FilterComponent threadComp = null;
        if (this._name != null) {
            nameComp.setFilter("{http://www.sas.com/xml/namespace/services.webdav-1.1}name", 0, this._name);
        }
        if (this._threadId != null) {
            threadComp = new FilterComponent("{http://www.sas.com/xml/namespace/services.webdav.comments-1.1}threadid", 0, this._threadId);
            nameComp.addComponent(threadComp);
            nameComp.setAggregation(0);
        }
        if (this._keywords.size() > 0) {
            keywordComp = new FilterComponent();
            Iterator it = this._keywords.iterator();
            while (it.hasNext()) {
                keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}saskeyword", 0, (String)it.next()));
            }
            keywordComp.setAggregation(1);
        }
        if (keywordComp != null) {
            nameComp.addComponent(keywordComp);
            nameComp.setAggregation(0);
        }
        if (compy != null) {
            nameComp.addComponent(compy);
            nameComp.setAggregation(0);
        }
        this.setFilterComponent(nameComp);
        String result = super.getDAVSQLString();
        this.setFilterComponent(compy);
        return result;
    }
}

