/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.CommentFilterInterface;
import com.sas.services.information.metadata.CommentInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.RemarksInterface;
import com.sas.services.information.metadata.dav.DAVEntityInterface;
import com.sas.services.information.metadata.dav.DAVFolderInterface;
import com.sas.services.information.metadata.dav.DAVRemarks;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class Remarks
extends Metadata
implements RemarksInterface {
    private static final long serialVersionUID = 2080469359187781428L;
    private static final int COMMENT_LIST_INIT = 4;
    private String _owner;
    private String _topic;
    private long _started;
    private DAVRemarks remarksData;
    private Set referrals = null;

    public Remarks() throws RemoteException {
        this(Remarks.class);
    }

    public Remarks(DAVRemarks remarks) throws RemoteException {
        this(remarks, Remarks.class);
    }

    protected Remarks(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected Remarks(DAVRemarks remarks, Class theClass) throws RemoteException {
        super(remarks, theClass);
        this.remarksData = remarks;
        this.remarksData.setStarted(System.currentTimeMillis());
    }

    @Override
    public String getType() throws RemoteException {
        return "Remarks";
    }

    public Remarks(UserContextInterface user, String topic) throws RemoteException {
        this._owner = user.getName();
        this._topic = topic;
        this._started = System.currentTimeMillis();
        this.remarksData.setOwner(this._owner);
        this.remarksData.setTopic(this._topic);
        this.remarksData.setStarted(this._started);
    }

    @Override
    public void addComment(CommentInterface comment) throws RemoteException {
        this.remarksData.addComment(comment);
    }

    @Override
    public CommentInterface getComment(CommentFilterInterface filter) throws RemoteException {
        List comments = this.getComments(filter);
        return comments.size() > 0 ? (CommentInterface)comments.get(0) : null;
    }

    @Override
    public void setThreadId(String threadId) throws RemoteException {
        this.remarksData.setThreadId(threadId);
    }

    @Override
    public String getThreadId() {
        return this.remarksData.getThreadId();
    }

    @Override
    public List getComments(CommentFilterInterface filter) throws RemoteException {
        UserContextInterface _uc = this._repository.getUserContext();
        String viewer = _uc.getName();
        String owner = this.getOwner();
        int filterModifier = filter == null ? 0 : filter.getFilterModifier();
        ArrayList<CommentInterface> commentList = new ArrayList<CommentInterface>(4);
        CommentInterface[] _comments = this.remarksData.getComments();
        if (filterModifier == 1 && owner != null && !owner.equals(viewer)) {
            return commentList;
        }
        if (_comments != null) {
            for (int i = 0; i < _comments.length; ++i) {
                CommentInterface comment = _comments[i];
                String author = comment.getAuthor();
                boolean secret = comment.isPrivate();
                boolean addcomment = false;
                switch (filterModifier) {
                    case 2: {
                        addcomment = viewer.equals(author);
                        break;
                    }
                    case 1: {
                        addcomment = viewer.equals(owner);
                        break;
                    }
                    case 0: {
                        addcomment = true;
                        if (!secret) break;
                        addcomment = author.equals(viewer);
                        break;
                    }
                    case 3: {
                        addcomment = true;
                        switch (filter.getRangeField()) {
                            case 2: {
                                addcomment = filter.rangeEvalLong(comment.getTimestamp());
                                break;
                            }
                            case 1: {
                                addcomment = filter.rangeEvalString(comment.getAuthor());
                                break;
                            }
                            case 0: {
                                addcomment = filter.rangeEvalString(comment.getText());
                                break;
                            }
                        }
                        if (!addcomment || !secret) break;
                        addcomment = author.equals(viewer);
                        break;
                    }
                }
                if (!addcomment) continue;
                commentList.add(comment);
            }
        }
        return commentList;
    }

    @Override
    public void clear() throws RemoteException {
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        UserContextInterface _uc = this._repository.getUserContext();
        String owner = this.getOwner();
        if (owner == null || owner.equals(_uc.getName())) {
            super.delete();
        }
    }

    @Override
    public String getOwner() throws RemoteException {
        return this.remarksData.getOwner();
    }

    @Override
    public String getTopic() throws RemoteException {
        return this.remarksData.getTopic();
    }

    @Override
    public Date getStarted() throws RemoteException {
        return new Date(this.remarksData.getStarted());
    }

    @Override
    public String getStarted(DateFormat df) throws RemoteException {
        return df.format(new Date(this.remarksData.getStarted()));
    }

    @Override
    public void update() throws ServiceException, RemoteException {
        super.update();
        DAVFolderInterface f = (DAVFolderInterface)this.getRepositoryEntity();
        for (DAVEntityInterface d : f.getEntities()) {
            d.update();
        }
    }

    @Override
    public void setOwner(UserContextInterface owner) throws IllegalStateException, RemoteException {
        if (this._owner != null) {
            throw new IllegalStateException("Owner is already set for this discussion thread");
        }
        this._owner = owner.getName();
        this.remarksData.setOwner(this._owner);
    }

    @Override
    public void setTopic(String topic) throws IllegalStateException, RemoteException {
        if (this._topic != null) {
            throw new IllegalStateException("Topic is already set for this discussion thread");
        }
        this._topic = topic;
        this.remarksData.setTopic(this._topic);
    }

    @Override
    public String getProperty(String propertyName) throws RemoteException {
        DAVEntityInterface d = (DAVEntityInterface)this.getRepositoryEntity();
        int p1 = propertyName.indexOf(123);
        int p2 = propertyName.indexOf(125);
        return p2 > p1 && p1 > -1 ? d.getAttribute(propertyName) : d.getAttribute("{}" + propertyName);
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) throws RemoteException {
        DAVEntityInterface d = (DAVEntityInterface)this.getRepositoryEntity();
        int p1 = propertyName.indexOf(123);
        int p2 = propertyName.indexOf(125);
        if (p2 > p1 && p1 > -1) {
            d.setAttribute(propertyName, propertyValue);
        } else {
            d.setAttribute("{}" + propertyName, propertyValue);
        }
    }

    @Override
    public void addReferral(String entityKey) throws RemoteException {
        DAVRemarks d = (DAVRemarks)this.getRepositoryEntity();
        if (this.referrals == null) {
            this.referrals = this.getReferrals();
        }
        this.referrals.add(entityKey);
        d.setReferrals(this.referrals);
    }

    public Set getReferrals() throws RemoteException {
        DAVRemarks d = (DAVRemarks)this.getRepositoryEntity();
        return d.getReferrals();
    }
}

