/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.util.TypeMapper;
import com.sas.text.Message;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class PathUrl
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4040274695161710994L;
    public static final char EXTENDED_PATH_DELIMITER = '#';
    public static final String PATHURL_DONT_USE_NAME = "@*#%$&*#";
    public static final int PARSE_FLAG_NO_TYPE = 1;
    private boolean _isWritable = true;
    private String _repository = null;
    private String _rootTree = null;
    private String _path = null;
    private String _name = null;
    private String _type = null;
    private String _primaryName = null;
    private String _fullType = null;
    private String _extendedPath = null;

    public static boolean isAbsolutePath(String pathString) {
        return !pathString.trim().toUpperCase().startsWith("SBIP");
    }

    public static PathUrl newPathUrlFromAbsolutePath(ServerInterface server, String absolutePath) throws ServiceException, RemoteException {
        RootFolderInterface rootFolder = server.getRootFolder();
        PathUrl rootPath = rootFolder.getPathUrl();
        PathUrl result = new PathUrl(rootPath, absolutePath);
        return result;
    }

    public static PathUrl newPathUrlFromExistingUrl(ServerInterface server, PathUrl oldPath) throws ServiceException, RemoteException {
        PathUrl rootPath;
        RootFolderInterface rootFolder;
        FolderInterface headFolder;
        String pathServer = oldPath.getServer();
        OMIRepositoryInterface owningRepos = null;
        String serverName = server.getName();
        if (serverName.equals(pathServer)) {
            return oldPath;
        }
        List reposList = server.getRepositories(true);
        for (OMIRepositoryInterface nextRepos : reposList) {
            if (!pathServer.equals(nextRepos.getISName()) && !pathServer.equals(nextRepos.getDefaultRepositoryName())) continue;
            owningRepos = nextRepos;
            break;
        }
        String rootFolderName = oldPath.getRootTree();
        if (owningRepos == null && (headFolder = (rootFolder = server.getRootFolder()).getSubfolder(rootFolderName)) != null) {
            PathUrl newPath = (PathUrl)oldPath.clone();
            newPath.setRepository(serverName);
            return newPath;
        }
        if (owningRepos != null && "FOUNDATION".equals(owningRepos.getRepositoryType())) {
            PathUrl newPath = (PathUrl)oldPath.clone();
            newPath.setRepository(serverName);
            return newPath;
        }
        if (owningRepos != null) {
            List rootList = owningRepos.getRootFolders();
            PublicObjectInterface goodRoot = null;
            for (FolderInterface nextFolder : rootList) {
                FolderInterface myRoot = nextFolder.getSubfolder(rootFolderName);
                if (myRoot == null) continue;
                if (goodRoot == null) {
                    goodRoot = nextFolder;
                    continue;
                }
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"PathUrl.ambiguouspath.msg.fmt.txt", (Object)rootFolderName, (Object)serverName));
            }
            if (goodRoot != null) {
                rootPath = goodRoot.getPathUrl();
                String absolutePath = oldPath.getAbsolutePath();
                PathUrl result = new PathUrl(rootPath, absolutePath);
                return result;
            }
        }
        String absolutePath = oldPath.getAbsolutePath();
        RootFolderInterface rootFolder2 = server.getRootFolder();
        rootPath = rootFolder2.getPathUrl();
        PathUrl result = new PathUrl(rootPath, absolutePath);
        return result;
    }

    public static String encodeString(String origString) {
        if (origString == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(origString.length());
        char[] charArray = origString.toCharArray();
        block8: for (int i = 0; i < charArray.length; ++i) {
            char nextChar = charArray[i];
            switch (nextChar) {
                case '#': {
                    buffer.append("%23");
                    continue block8;
                }
                case '%': {
                    buffer.append("%25");
                    continue block8;
                }
                case '/': {
                    buffer.append("%2F");
                    continue block8;
                }
                case '(': {
                    buffer.append("%28");
                    continue block8;
                }
                case ')': {
                    buffer.append("%29");
                    continue block8;
                }
                case '\\': {
                    buffer.append("%5C");
                }
                default: {
                    buffer.append(nextChar);
                }
            }
        }
        return buffer.toString();
    }

    public static String decodeString(String origString) {
        if (origString == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(origString.length());
        char[] charArray = origString.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char nextChar = charArray[i];
            if (i < charArray.length - 2 && nextChar == '%') {
                StringBuffer buf = new StringBuffer(3);
                buf.append(charArray[i + 1]);
                buf.append(charArray[i + 2]);
                try {
                    char blah = (char)Integer.parseInt(buf.toString(), 16);
                    if (blah < '\u001f' || blah >= '\u007f') {
                        buffer.append(nextChar);
                        continue;
                    }
                    buffer.append(blah);
                    i += 2;
                }
                catch (NumberFormatException ex) {
                    buffer.append(nextChar);
                }
                continue;
            }
            buffer.append(nextChar);
        }
        return buffer.toString();
    }

    public PathUrl(String url) {
        this.parseUrl(url.trim(), 0);
    }

    public PathUrl(String url, int flags) {
        this.parseUrl(url.trim(), flags);
    }

    public PathUrl(PathUrl context, String url) {
        String name;
        String path;
        String rootTree;
        url = url.trim();
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        if ((rootTree = context.getRootTree()) != null && rootTree.trim().length() == 0) {
            rootTree = null;
        }
        if ((path = context.getPath()) != null && path.trim().length() == 0) {
            path = null;
        }
        if ((name = context.getName()) != null && name.trim().length() == 0) {
            name = null;
        }
        String pathString = "SBIP://" + context.getRepository() + (rootTree == null ? "" : "/" + rootTree) + (path == null ? "" : "/" + path) + (name == null ? "" : (name.equals("/") ? "" : "/" + name)) + "/" + url;
        this.parseUrl(pathString, 0);
    }

    private void parseUrl(String url, int flags) {
        boolean isExtended = false;
        boolean endsWithType = false;
        boolean bl = endsWithType = url.endsWith(")") && (flags & 1) <= 0;
        if (endsWithType) {
            int typeIndex = url.lastIndexOf("(");
            String type = url.substring(typeIndex + 1, url.length() - 1);
            isExtended = TypeMapper.isExtendedType(type);
        }
        String upUrl = url;
        if (!(upUrl = upUrl.toUpperCase()).startsWith("SBIP://")) {
            throw new IllegalArgumentException(RB.getStringResource("PathUrl.badprotocol.ex.txt"));
        }
        String temp = url.substring(7);
        int index = temp.indexOf("/");
        if (index < 0) {
            throw new IllegalArgumentException(RB.getStringResource("PathUrl.reposandroot.msg.txt"));
        }
        this._repository = temp.substring(0, index);
        if ((index = (temp = temp.substring(index + 1)).indexOf("/")) < 0) {
            index = temp.lastIndexOf("(");
            int index2 = temp.indexOf(41, index);
            if (index < 0 || index > 0 && index2 < 0) {
                this._rootTree = temp;
            } else {
                this._rootTree = temp.substring(0, index);
                this._type = temp.substring(index + 1);
                this._fullType = this._type = this._type.substring(0, this._type.length() - 1);
            }
        } else {
            this._rootTree = temp.substring(0, index);
            int index2 = temp.lastIndexOf("/");
            if (index2 > index) {
                this._path = temp.substring(index + 1, index2);
            }
            temp = temp.substring(index2 + 1);
            index = temp.indexOf(35);
            int parenIndex = temp.indexOf(40);
            if (!isExtended || index < 0 || temp.charAt(index - 1) != ')' || parenIndex < 0 || parenIndex > index - 1) {
                index = temp.lastIndexOf("(");
                if (index > 0 && !endsWithType) {
                    index = -2;
                }
                if (index > 0) {
                    this._name = temp.substring(0, index);
                    this._type = temp.substring(index + 1);
                    this._type = this._type.substring(0, this._type.length() - 1);
                    if (this._type != null) {
                        this._fullType = this._type;
                        int index5 = this._type.indexOf(46);
                        if (index5 > -1) {
                            this._type = this._type.substring(0, index5);
                        }
                    }
                } else {
                    this._name = temp;
                }
            } else {
                boolean got_name = false;
                StringBuffer leftovers = new StringBuffer();
                StringTokenizer st = new StringTokenizer(temp, String.valueOf('#'));
                while (st.hasMoreTokens()) {
                    String nextToken = st.nextToken();
                    if (!got_name) {
                        if (!nextToken.endsWith(")")) {
                            leftovers.append(nextToken);
                            if (!st.hasMoreTokens()) continue;
                            leftovers.append('#');
                            continue;
                        }
                        if (leftovers.length() > 0) {
                            this._primaryName = leftovers.toString() + nextToken;
                            leftovers = new StringBuffer();
                        } else {
                            this._primaryName = nextToken;
                        }
                        got_name = true;
                        continue;
                    }
                    leftovers.append(nextToken);
                    if (!st.hasMoreTokens()) continue;
                    leftovers.append('#');
                }
                if (!got_name) {
                    this._primaryName = leftovers.toString();
                } else {
                    index = this._primaryName.lastIndexOf("(");
                    if (index > 0) {
                        temp = this._primaryName;
                        this._primaryName = temp.substring(0, index);
                        this._type = temp.substring(index + 1);
                        this._type = this._type.substring(0, this._type.length() - 1);
                        if (this._type != null) {
                            this._fullType = this._type;
                            int index5 = this._type.indexOf(46);
                            if (index5 > -1) {
                                this._type = this._type.substring(0, index5);
                            }
                        }
                    } else {
                        this._primaryName = temp;
                    }
                    this._extendedPath = leftovers.toString();
                }
                this._name = PATHURL_DONT_USE_NAME;
            }
        }
        if (this._name != null && this._name.trim().length() == 0) {
            this._name = null;
        }
        if (this._rootTree.trim().length() == 0) {
            this._rootTree = null;
        }
        if (this._path == null && this._rootTree == null && this._name == null && this._repository != null) {
            this._name = "/";
            this._fullType = this._type = "Folder";
        } else if (this._path == null && this._rootTree != null && this._name == null && this._type == null) {
            this._fullType = this._type = "Folder";
        } else if (this._path != null && this._name == null) {
            index = this._path.lastIndexOf(47);
            if (index < 0) {
                this._name = this._path;
                this._path = null;
            } else {
                this._name = this._path.substring(index + 1);
                this._path = this._path.substring(0, index);
            }
            this._fullType = this._type = "Folder";
        }
    }

    public PathUrl(String repository, String rootTree, String path, String name, String type) {
        this._repository = repository;
        this._rootTree = rootTree;
        this._path = path;
        this._name = name;
        this._type = type;
        if (this._type != null) {
            this._fullType = this._type;
            int index = this._type.indexOf(46);
            if (index > -1) {
                this._type = this._type.substring(0, index);
            }
        }
        this._isWritable = true;
    }

    public Object clone() {
        try {
            PathUrl result = (PathUrl)super.clone();
            result.setWritable();
            result.setRepository(this._repository);
            result.setRootTree(this._rootTree);
            result.setPath(this._path);
            result.setName(this._name);
            result.setType(this._type);
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isWritable() {
        return this._isWritable;
    }

    public void setUnwritable() {
        this._isWritable = false;
    }

    private void setWritable() {
        this._isWritable = true;
    }

    public String getRepository() {
        return this._repository;
    }

    public String getServer() {
        return this._repository;
    }

    public void setRepository(String repository) {
        if (!this._isWritable) {
            throw new IllegalStateException(RB.getStringResource("PathUrl.notwritable.msg.txt"));
        }
        this._repository = repository;
    }

    public String getRootTree() {
        return this._rootTree;
    }

    public void setRootTree(String tree) {
        if (!this._isWritable) {
            throw new IllegalStateException(RB.getStringResource("PathUrl.notwritable.msg.txt"));
        }
        this._rootTree = tree;
    }

    public String getPath() {
        return this._path;
    }

    public String getAbsolutePath() {
        String type;
        String name;
        String path;
        String rootTree;
        String extendedPath = this._extendedPath;
        if (extendedPath != null && extendedPath.trim().length() == 0) {
            extendedPath = null;
        }
        if ((rootTree = this._rootTree) != null && rootTree.trim().length() == 0) {
            rootTree = null;
        }
        if ((path = this._path) != null && path.trim().length() == 0) {
            path = null;
        }
        String string = name = extendedPath == null ? this._name : this._primaryName;
        if (name != null && name.trim().length() == 0) {
            name = null;
        }
        if ((type = this._type) != null && type.trim().length() == 0) {
            type = null;
        }
        return (rootTree != null ? '/' + this._rootTree : "") + (path != null ? '/' + this._path : "") + (name != null ? ("/".equals(name) ? name : '/' + name) : "") + (type != null ? '(' + this._type + ')' : "") + (extendedPath != null ? '#' + this._extendedPath : "");
    }

    public String getDisplayPath() {
        String name;
        String path;
        String extendedPath = this._extendedPath;
        if (extendedPath != null && extendedPath.trim().length() == 0) {
            extendedPath = null;
        }
        String rootTree = this._rootTree;
        if (this._rootTree == null && this._path == null && this._name.equals("/")) {
            return "/";
        }
        if (rootTree != null && rootTree.trim().length() == 0) {
            rootTree = null;
        }
        if ((path = this._path) != null && path.trim().length() == 0) {
            path = null;
        }
        String string = name = extendedPath == null ? this._name : this._primaryName;
        if (name != null && name.trim().length() == 0) {
            name = null;
        }
        return (rootTree != null ? '/' + this._rootTree : "") + (path != null ? '/' + this._path : "") + (name != null ? ("/".equals(name) ? name : '/' + name) : "") + (extendedPath != null ? '#' + this._extendedPath : "");
    }

    public void setPath(String path) {
        if (!this._isWritable) {
            throw new IllegalStateException(RB.getStringResource("PathUrl.notwritable.msg.txt"));
        }
        this._path = path;
    }

    public String getPrimaryName() {
        if (this._extendedPath != null && this._extendedPath.trim().length() > 0) {
            return PathUrl.decodeString(this._primaryName);
        }
        return this._name;
    }

    public String getName() {
        if (this._extendedPath != null && this._extendedPath.trim().length() > 0) {
            String lastNameType = null;
            int index = this._extendedPath.lastIndexOf(35);
            lastNameType = index > -1 ? this._extendedPath.substring(index + 1) : this._extendedPath;
            index = lastNameType.lastIndexOf(40);
            String lastName = lastNameType.substring(0, index);
            return PathUrl.decodeString(lastName);
        }
        return this._name;
    }

    public void setName(String name) {
        if (!this._isWritable) {
            throw new IllegalStateException(RB.getStringResource("PathUrl.notwritable.msg.txt"));
        }
        this._name = name;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        if (!this._isWritable) {
            throw new IllegalStateException(RB.getStringResource("PathUrl.notwritable.msg.txt"));
        }
        this._type = type;
    }

    public String getFullTypeString() {
        return this._fullType;
    }

    public String getExtendedPath() {
        return this._extendedPath;
    }

    public void setExtendedPath(String extension) {
        if (this._name != null && !PATHURL_DONT_USE_NAME.equals(this._name)) {
            this._primaryName = this._name;
            this._name = PATHURL_DONT_USE_NAME;
        }
        this._extendedPath = extension;
    }

    public String toString() {
        String type;
        String name;
        String path;
        String rootTree;
        String extendedPath = this._extendedPath;
        if (extendedPath != null && extendedPath.trim().length() == 0) {
            extendedPath = null;
        }
        if ((rootTree = this._rootTree) != null && rootTree.trim().length() == 0) {
            rootTree = null;
        }
        if ((path = this._path) != null && path.trim().length() == 0) {
            path = null;
        }
        String string = name = extendedPath == null ? this._name : this._primaryName;
        if (name != null && name.trim().length() == 0) {
            name = null;
        }
        if ((type = this._type) != null && type.trim().length() == 0) {
            type = null;
        }
        return "SBIP://" + this._repository + (rootTree != null ? '/' + this._rootTree : "") + (path != null ? '/' + this._path : "") + (name != null ? ("/".equals(name) ? name : '/' + name) : "") + (type != null ? '(' + this._type + ')' : "") + (extendedPath != null ? '#' + this._extendedPath : "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PathUrl)) {
            return false;
        }
        PathUrl other = (PathUrl)obj;
        String otherName = other.getName();
        if (this._name == null && otherName != null) {
            return false;
        }
        if (otherName == null && this._name != null) {
            return false;
        }
        if (this._name != null && !this._name.equals(otherName)) {
            return false;
        }
        String otherPath = other.getPath();
        if (this._path == null && otherPath != null) {
            return false;
        }
        if (otherPath == null && this._path != null) {
            return false;
        }
        if (this._path != null && !this._path.equals(otherPath)) {
            return false;
        }
        String otherRepos = other.getRepository();
        if (this._repository == null && otherRepos != null) {
            return false;
        }
        if (otherRepos == null && this._repository != null) {
            return false;
        }
        if (this._repository != null && !this._repository.equals(otherRepos)) {
            return false;
        }
        String otherRoot = other.getRootTree();
        if (this._rootTree == null && otherRoot != null) {
            return false;
        }
        if (otherRoot == null && this._rootTree != null) {
            return false;
        }
        if (this._rootTree != null && !this._rootTree.equals(otherRoot)) {
            return false;
        }
        String otherType = other.getType();
        if (this._type == null && otherType != null) {
            return false;
        }
        if (otherType == null && this._type != null) {
            return false;
        }
        return this._type == null || this._type.equals(otherType);
    }
}

