/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.TransformationInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;

public class OMRTransformation
extends Metadata
implements TransformationInterface {
    public OMRTransformation() throws RemoteException {
        super(OMRTransformation.class);
    }

    public OMRTransformation(Class theClass) throws RemoteException {
        super(theClass);
    }

    public OMRTransformation(Object o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public OMRTransformation(Object o) throws RemoteException {
        super(o, OMRTransformation.class);
    }

    public OMRTransformation(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            try {
                Transformation transform = (Transformation)omirepository.createMetadata(name, "Document");
                this._repositoryObject = transform;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (ServiceException ex) {
                    transform.delete();
                    throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
                }
            }
            catch (ServiceException ex) {
                this.logThrowable(Level.WARN, ex.getMessage(), "com.sas.services.information.metadata.OMRDocument", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        if (this._repositoryObject == null) {
            return "Transformation";
        }
        Transformation transformation = (Transformation)this._repositoryObject;
        String type = transformation.getPublicType();
        if (type == null || type.length() == 0) {
            type = "Transformation";
        }
        return type;
    }

    @Override
    public String getTransformRole() throws ServiceException, RemoteException {
        Transformation transformation = (Transformation)this._repositoryObject;
        return transformation.getTransformRole();
    }

    @Override
    public List<MetadataInterface> getTransformationSources() throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>();
        try {
            Transformation transformation = (Transformation)this._repositoryObject;
            AssociationList transformSources = transformation.getTransformationSources();
            for (Root nextSource : transformSources) {
                results.add(this._repository.factoryProcess(nextSource));
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }
}

