/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.impl.ConnectionImpl;
import com.sas.metadata.remote.impl.TCPIPConnectionImpl;
import com.sas.metadata.remote.impl.TCPIPConnectionImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.OMRConnection;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.TCPIPConnectionInterface;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRTCPIPConnection
extends OMRConnection
implements TCPIPConnectionInterface,
SubstitutionProperties {
    private static final long serialVersionUID = -524553159222577820L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRTCPIPConnection() throws RemoteException {
    }

    public OMRTCPIPConnection(TCPIPConnection o) throws RemoteException {
        super((Connection)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRTCPIPConnection(TCPIPConnectionImpl o) throws RemoteException {
        super((ConnectionImpl)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRTCPIPConnection(TCPIPConnectionImpl_Stub o) throws RemoteException {
        super((Connection)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRTCPIPConnection(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                TCPIPConnection connection = (TCPIPConnection)omirepository.createMetadata(name, "TCPIPConnection");
                connection.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = connection;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    connection.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRColumn", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "TCPIPConnection";
    }

    @Override
    public String getHost() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TCPIPConnection conn = (TCPIPConnection)this._repositoryObject;
        return conn.getHostName();
    }

    @Override
    public void setHost(String host) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TCPIPConnection conn = (TCPIPConnection)this._repositoryObject;
        conn.setHostName(host);
    }

    @Override
    public String getService() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TCPIPConnection conn = (TCPIPConnection)this._repositoryObject;
        return conn.getService();
    }

    @Override
    public void setService(String service) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TCPIPConnection conn = (TCPIPConnection)this._repositoryObject;
        conn.setService(service);
    }

    @Override
    public int getPort() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TCPIPConnection conn = (TCPIPConnection)this._repositoryObject;
        return conn.getPort();
    }

    @Override
    public void setPort(int port) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TCPIPConnection conn = (TCPIPConnection)this._repositoryObject;
        conn.setPort(port);
    }

    public PropertyList getSubstitutionProperties() throws UnexpectedSubstitutionException {
        int port = -1;
        PropertyList connList = null;
        try {
            port = this.getPort();
            PropertyList portList = new PropertyList();
            portList.addProperty("Port", String.valueOf(port));
            connList = new PropertyList();
            connList.addProperty(this.getName(), portList);
        }
        catch (RemoteException exception) {
            throw new UnexpectedSubstitutionException((Throwable)exception);
        }
        catch (ServiceException exception) {
            throw new UnexpectedSubstitutionException((Throwable)((Object)exception));
        }
        return connList;
    }

    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        if (map != null) {
            String port = null;
            int iPort = -1;
            try {
                PropertyMap connMap = map.getNestedProperties(this.getName());
                if (connMap != null && (port = connMap.getProperty("port")) != null) {
                    iPort = Integer.parseInt(port);
                    this.setPort(iPort);
                }
            }
            catch (RemoteException exception) {
                throw new UnexpectedSubstitutionException((Throwable)exception);
            }
            catch (ServiceException exception) {
                throw new UnexpectedSubstitutionException((Throwable)((Object)exception));
            }
        }
    }
}

