/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.impl.ServiceTypeImpl;
import com.sas.metadata.remote.impl.ServiceTypeImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.ServiceTypeInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRServiceType
extends Metadata
implements ServiceTypeInterface {
    private static final long serialVersionUID = -6005595207830941716L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRServiceType() throws RemoteException {
        super(OMRServiceType.class);
    }

    public OMRServiceType(ServiceType o) throws RemoteException {
        super(o, OMRServiceType.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServiceType(ServiceTypeImpl o) throws RemoteException {
        super(o, OMRServiceType.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServiceType(ServiceTypeImpl_Stub o) throws RemoteException {
        super(o, OMRServiceType.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServiceType(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRServiceType.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            try {
                ServiceType serviceType = (ServiceType)omirepository.createMetadata(name, "ServiceType");
                serviceType.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = serviceType;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    serviceType.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException e) {
                this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "ServiceType";
    }

    @Override
    public String getClassIdentifier() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ServiceType st = (ServiceType)this._repositoryObject;
        return st.getClassIdentifier();
    }

    @Override
    public void setClassIdentifier(String classIdentifier) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ServiceType st = (ServiceType)this._repositoryObject;
        st.setClassIdentifier(classIdentifier);
    }

    @Override
    public String getInterfaceName() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ServiceType st = (ServiceType)this._repositoryObject;
        return st.getInterfaceName();
    }

    @Override
    public void setInterfaceName(String interfaceName) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ServiceType st = (ServiceType)this._repositoryObject;
        st.setInterfaceName(interfaceName);
    }
}

