/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.impl.SoftwareComponentImpl;
import com.sas.metadata.remote.impl.SoftwareComponentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.ContentInfo;
import com.sas.services.information.Filter;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.FolderAdminInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRSoftwareComponent;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.util.Names;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRServerRootFolder
extends OMRSoftwareComponent
implements RootFolderInterface,
FolderAdminInterface {
    private static final long serialVersionUID = 785113950001863793L;
    private static final String ROOTFOLDERTYPE = "Server Root";
    private static final String ROOTFOLDERPATH = "/";
    public static final String REPOSITORY_CONTENT_MAPPING = "Report Repository Content Mapping";
    public static final String REPOSITORY_CONTENT_MAPPING_TYPE = "ReportRepositoryContentMapping";
    private long _myFolderRefreshInterval = Folder.folderRefreshInterval;
    private long _subfolderRefreshTime = 0L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private static boolean contentUserFailedMessageFlag = false;

    public OMRServerRootFolder() throws RemoteException {
        super(OMRServerRootFolder.class);
    }

    public OMRServerRootFolder(SoftwareComponent o) throws RemoteException {
        this(o, OMRServerRootFolder.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServerRootFolder(SoftwareComponentImpl o) throws RemoteException {
        this(o, OMRServerRootFolder.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServerRootFolder(SoftwareComponentImpl_Stub o) throws RemoteException {
        this(o, OMRServerRootFolder.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRServerRootFolder(Object o, Class theClass) throws RemoteException {
        super(o, theClass);
        this._myFolderRefreshInterval = Folder.folderRefreshInterval;
    }

    @Override
    public String getType() throws RemoteException {
        return "RootFolder";
    }

    @Override
    public String getName() throws RemoteException {
        return ROOTFOLDERPATH;
    }

    @Override
    public void addItem(MetadataInterface item) throws ServiceException, RemoteException {
        throw new ServiceException(RB.getStringResource("ServerRoot.noitems.ex.txt"));
    }

    @Override
    public MetadataInterface addNewItem(String name, String type) throws ServiceException, RemoteException {
        throw new ServiceException(RB.getStringResource("ServerRoot.noitems.ex.txt"));
    }

    @Override
    public void addSubfolder(FolderInterface folder) throws ServiceException, RemoteException {
        this.addSubfolder(folder, -1);
    }

    private void addSubfolder(FolderInterface folder, int index) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            OMIRepositoryInterface ri = (OMIRepositoryInterface)folder.getRepository();
            if (!"FOUNDATION".equals(ri.getRepositoryType())) {
                throw new ServiceException(RB.getStringResource("ServerRoot.foundationly.ex.txt"));
            }
            SoftwareComponent sc = (SoftwareComponent)this._repositoryObject;
            Tree newMember = (Tree)folder.getRepositoryEntity();
            AssociationList subs = sc.getSoftwareTrees();
            for (Root root : subs) {
                if (!root.getName().equals(newMember.getName())) continue;
                throw new ServiceException(RB.getStringResource("Folder.dupsubfolder.ex.txt"));
            }
            if (index < 0) {
                subs.add(newMember);
            } else {
                subs.add(index, newMember);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("Folder.removesubfolder.ex.txt"));
        }
    }

    @Override
    public void deleteItem(MetadataInterface item) throws ServiceException, RemoteException {
        throw new ServiceException(RB.getStringResource("ServerRoot.noitems.ex.txt"));
    }

    @Override
    public void deleteSubfolder(String name) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        FolderInterface fi = this.getSubfolder(name);
        if (fi != null) {
            fi.delete();
        }
    }

    @Override
    public String getFolderType() throws ServiceException, RemoteException {
        return ROOTFOLDERTYPE;
    }

    @Override
    public MetadataInterface getItem(String name) throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public MetadataInterface getPublicTypeItem(String name, String type) throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public MetadataInterface getItemByClass(String name, Class itemClass) throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public MetadataInterface getItemByType(String name, String metadataType) throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public List getItemSublist(int start, int end) throws RemoteException, ServiceException {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getItemSublist(int start, int end, String sort) throws RemoteException, ServiceException {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getItems() throws ServiceException, RemoteException {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getItemsByClass(Class itemClass) throws ServiceException, RemoteException {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getItemsByType(String metadataType) throws ServiceException, RemoteException {
        return Collections.EMPTY_LIST;
    }

    @Override
    public FolderInterface getParent() throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public String getPath() throws RemoteException {
        return ROOTFOLDERPATH;
    }

    @Override
    public FolderInterface getSubfolder(String name) throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (name == null) {
            return null;
        }
        List subfolders = this.getSubfolders();
        for (FolderInterface folder : subfolders) {
            if (!folder.getName().equalsIgnoreCase(name)) continue;
            return folder;
        }
        return null;
    }

    @Override
    public List getSubfolders() throws ServiceException, RemoteException {
        return this.getSubfolderFiltered(false);
    }

    private List getSubfolderFiltered(boolean filtered) throws RemoteException, ServiceException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent sc = (SoftwareComponent)this._repositoryObject;
        ArrayList<FolderInterface> result = null;
        AssociationList trees = null;
        try {
            if (System.currentTimeMillis() - this._subfolderRefreshTime > this._myFolderRefreshInterval) {
                trees = sc.getSoftwareTrees(true);
                this._subfolderRefreshTime = System.currentTimeMillis();
            } else {
                trees = sc.getSoftwareTrees();
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        if (trees == null || trees.size() == 0) {
            result = Collections.EMPTY_LIST;
        } else {
            result = new ArrayList<FolderInterface>(trees.size());
            for (Tree t : trees) {
                if (filtered && !"Folder".equals(t.getPublicType())) continue;
                FolderInterface fi = (FolderInterface)this._repository.factoryProcess(t);
                result.add(fi);
            }
        }
        return result;
    }

    @Override
    public int getTotalNumberOfItems() throws RemoteException, ServiceException {
        return 0;
    }

    @Override
    public FolderInterface makeSubfolder(String name, String type) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        FolderInterface result = this.getSubfolder(name);
        if (result == null) {
            try {
                if (!Names.validateOMRObjectName(name, true)) {
                    throw new ServiceException(RB.getStringResource("Folder.invalidName.ex.txt"));
                }
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException(e.getMessage());
            }
            InformationServiceInterface is = OMRServerRootFolder.getInformationService();
            MetadataInterface mi = is.newMetadata(null, name, this._repository, type);
            if (!(mi instanceof FolderInterface)) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Folder.notfoldertype.ex.fmt.txt", (Object)type));
            }
            result = (FolderInterface)mi;
            this.addSubfolder(result);
        }
        return result;
    }

    @Override
    public FolderInterface makeSubfolder(String name) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        FolderInterface result = this.getSubfolder(name);
        if (result == null) {
            try {
                if (!Names.validateOMRObjectName(name, true)) {
                    throw new ServiceException(RB.getStringResource("Folder.invalidName.ex.txt"));
                }
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException(e.getMessage());
            }
            if (this.hasDuplicateSubfolder(name)) {
                throw new IllegalArgumentException(RB.getStringResource("Folder.dupsubfolder.ex.txt"));
            }
            InformationServiceInterface is = OMRServerRootFolder.getInformationService();
            MetadataInterface mi = is.newMetadata(null, name, this._repository, "Folder");
            result = (FolderInterface)mi;
            Tree newTree = (Tree)result.getRepositoryEntity();
            try {
                newTree.getSoftwareComponents().add(this._repositoryObject);
            }
            catch (MdException ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
        }
        return result;
    }

    @Override
    public void removeItem(MetadataInterface item) throws ServiceException, RemoteException {
        throw new ServiceException(RB.getStringResource("ServerRoot.noitems.ex.txt"));
    }

    @Override
    public void removeSubfolder(String name) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (name == null) {
            return;
        }
        FolderInterface fi = this.getSubfolder(name);
        if (fi == null) {
            return;
        }
        SoftwareComponent sc = (SoftwareComponent)this._repositoryObject;
        Tree tree = (Tree)fi.getRepositoryEntity();
        try {
            AssociationList treeList = sc.getSoftwareTrees();
            treeList.remove(tree);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setFolderType(String type) throws ServiceException, RemoteException {
        throw new ServiceException(RB.getStringResource("ServerRoot.statictype.ex.txt"));
    }

    @Override
    public String getParentPath(String rootFolderName) throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public List getParents() throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public String getPath(String rootFolderName) throws ServiceException, RemoteException {
        return ROOTFOLDERPATH;
    }

    @Override
    public PathUrl getPathUrl() throws IllegalStateException, ServiceException, RemoteException {
        return new PathUrl(this._repository.getServer().getName(), null, null, ROOTFOLDERPATH, "Folder");
    }

    @Override
    public PathUrl getPathUrl(String rootTreeName) throws IllegalStateException, ServiceException, RemoteException {
        return this.getPathUrl();
    }

    @Override
    public List getPaths(String rootFolderName) throws ServiceException, RemoteException {
        return super.getPaths(rootFolderName);
    }

    @Override
    public void addChild(PublicObjectInterface newChild) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (!(newChild instanceof FolderInterface)) {
            throw new ServiceException(RB.getStringResource("ServerRoot.noitems.ex.txt"));
        }
        this.addSubfolder((FolderInterface)newChild);
    }

    @Override
    public PublicObjectInterface newChild(String type, String name) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (!FolderUtil.isFolder(type)) {
            throw new ServiceException(RB.getStringResource("ServerRoot.noitems.ex.txt"));
        }
        return this.makeSubfolder(name);
    }

    @Override
    public List getChildren() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        return this.getSubfolders();
    }

    @Override
    public List getChildren(String type) throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (!FolderUtil.isFolder(type)) {
            throw new ServiceException(RB.getStringResource("ServerRoot.noitems.ex.txt"));
        }
        return this.getSubfolders();
    }

    @Override
    public PublicObjectInterface getChildAt(int index) throws ServiceException, RemoteException {
        List children = this.getChildren();
        if (children == null || children.size() == 0) {
            throw new ArrayIndexOutOfBoundsException("The folder has no children");
        }
        return (PublicObjectInterface)children.get(index);
    }

    @Override
    public int getChildCount() throws ServiceException, RemoteException {
        List children = this.getChildren();
        return children.size();
    }

    @Override
    public void insertChild(PublicObjectInterface child, int index) throws ServiceException, RemoteException {
        if (!(child instanceof FolderInterface)) {
            throw new ServiceException(RB.getStringResource("ServerRoot.noitems.ex.txt"));
        }
        this.addSubfolder((FolderInterface)child, index);
    }

    @Override
    public void removeChild(PublicObjectInterface child) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (!(child instanceof FolderInterface)) {
            throw new ServiceException(RB.getStringResource("ServerRoot.noitems.ex.txt"));
        }
        this.removeSubfolder(child.getName());
    }

    @Override
    public boolean hasDuplicate(String name, String type) throws ServiceException, RemoteException {
        if (name == null || type == null) {
            return false;
        }
        if ("Folder".equals(type)) {
            return this.hasDuplicateSubfolder(name);
        }
        return false;
    }

    @Override
    public boolean hasDuplicateSubfolder(String name) throws ServiceException, RemoteException {
        StringBuffer selectBuffer = new StringBuffer();
        String selectName = XMLUtil.normalize(name);
        selectBuffer.append("<XMLSelect search=\"*[@Name='" + selectName + "' ");
        selectBuffer.append("][SoftwareComponents/SoftwareComponent[@Id='" + this.getReposId() + "']]\" />");
        String selectString = selectBuffer.toString();
        Filter filter = new Filter();
        filter.setType("Tree");
        filter.setExplicitSearchString("omi", selectString);
        MetadataServerInterface server = (MetadataServerInterface)this._repository.getServer();
        int count = server.getCountNoSecurity(filter, null);
        return count > 0;
    }

    @Override
    public boolean isEmpty() throws ServiceException, RemoteException {
        return this.countAssociatedObjects("SoftwareTrees") == 0;
    }

    @Override
    public ContentInfo getContentInfo() throws ServiceException, RemoteException {
        PathUrl sbipUrl = this.getPathUrl();
        PathUrl sbipRoot = (PathUrl)sbipUrl.clone();
        sbipRoot.setPath(null);
        sbipRoot.setName(null);
        sbipRoot.setType(null);
        ContentInfo contentInfo = null;
        try {
            String pw;
            String userId;
            Document doc = this.getContentInfoDoc();
            if (doc == null) {
                return null;
            }
            String uri = doc.getURI();
            TextStore ts = this.getAuthenticationTextStore(doc);
            if (ts != null) {
                String storedTextEncoded = ts.getStoredText();
                String storedText = null;
                boolean sasPasswordEncoding = storedTextEncoded.startsWith("{sas");
                try {
                    if (sasPasswordEncoding) {
                        storedText = SasPasswordString.decode((String)storedTextEncoded);
                    } else {
                        MdObjectStore store = (MdObjectStore)ts.getObjectStore();
                        MdFactory factory = store.getFactory();
                        storedText = factory.getUtil().decrypt(storedTextEncoded);
                    }
                }
                catch (SasPasswordEncodingException e) {
                    throw new ServiceException(e, e.getMessage());
                }
                int delimiterPos = storedText.indexOf(10);
                if (delimiterPos > 0 && delimiterPos < storedText.length() - 1) {
                    userId = storedText.substring(0, delimiterPos);
                    pw = storedText.substring(delimiterPos + 1);
                } else {
                    userId = storedText;
                    pw = "";
                }
            } else {
                userId = "";
                pw = "";
                if (!contentUserFailedMessageFlag) {
                    this.logFormat(Level.WARN, "com.sas.services.information.metadata.OMRServerRootFolder", RB.getResources(), "Folder.retrieveContentUserFailed.txt", sbipRoot.toString());
                    contentUserFailedMessageFlag = true;
                }
            }
            contentInfo = new ContentInfo(uri, "", userId, pw);
        }
        catch (RemoteException e) {
            throw new ServiceException(e, e.getMessage());
        }
        return contentInfo;
    }

    private Document getContentInfoDoc() throws IllegalArgumentException, ServiceException, RemoteException {
        String rootFolderName = ROOTFOLDERPATH;
        try {
            Document contentInfoDoc = null;
            SoftwareComponent sc = (SoftwareComponent)this._repositoryObject;
            AssociationList scDocList = sc.getDocuments();
            contentInfoDoc = this.getContentInfoDocFromList((List)scDocList, rootFolderName);
            if (contentInfoDoc == null && (contentInfoDoc = this.getContentInfoDocFromList((List)scDocList, REPOSITORY_CONTENT_MAPPING)) == null) {
                return null;
            }
            return contentInfoDoc;
        }
        catch (RemoteException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    private Document getContentInfoDocFromList(List list, String docName) throws RemoteException {
        Document contentInfoDoc = null;
        Iterator docItor = list.iterator();
        while (contentInfoDoc == null && docItor.hasNext()) {
            Document doc = (Document)docItor.next();
            if (!doc.getName().equals(docName)) continue;
            contentInfoDoc = doc;
        }
        return contentInfoDoc;
    }

    private TextStore getAuthenticationTextStore(Document doc) throws ServiceException {
        try {
            String nameToMatch = doc.getName();
            AssociationList noteList = doc.getNotes();
            for (TextStore textStore : noteList) {
                String tsName = textStore.getName();
                if (!nameToMatch.equals(tsName)) continue;
                return textStore;
            }
            return null;
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    @Override
    public Date getContentCreateDate() throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public Date getContentModifyDate() throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public void setContentCreateDate(Date date) throws ServiceException, RemoteException {
    }

    @Override
    public void setContentModifyDate(Date date) throws ServiceException, RemoteException {
    }

    @Override
    public List getSASFolders() throws ServiceException, RemoteException {
        return this.getSubfolderFiltered(true);
    }

    @Override
    public List getSASFolders(RepositoryInterface ri) throws ServiceException, RemoteException {
        List folderList = this.getSubfolderFiltered(true);
        ArrayList<FolderInterface> result = new ArrayList<FolderInterface>(folderList.size());
        for (FolderInterface fi : folderList) {
            RepositoryInterface fri = fi.getRepository();
            if (!fri.equals(ri)) continue;
            result.add(fi);
        }
        return result;
    }

    @Override
    public boolean isItemNameUnique(MetadataInterface member) throws ServiceException, RemoteException {
        return false;
    }

    @Override
    public FolderInterface createTopLevelFolder(OMIRepositoryInterface repos, String folderName) throws ServiceException, RemoteException {
        String reposType = repos.getRepositoryType();
        if ("FOUNDATION".equalsIgnoreCase(reposType)) {
            return this.makeSubfolder(folderName);
        }
        if ("PROJECT".equalsIgnoreCase(reposType)) {
            return null;
        }
        if (!Names.validateOMRObjectName(folderName, false)) {
            throw new IllegalArgumentException(RB.getStringResource("Folder.invalidName.ex.txt"));
        }
        FolderInterface topLevelFolder = null;
        List folders = this.getSASFolders(repos);
        if (folders != null && folders.size() > 0) {
            for (FolderInterface folder : folders) {
                if (!folderName.equalsIgnoreCase(folder.getName())) continue;
                topLevelFolder = folder;
                break;
            }
            if (topLevelFolder == null) {
                topLevelFolder = (FolderInterface)folders.get(0);
            }
        }
        if (topLevelFolder == null) {
            if (this.hasDuplicateSubfolder(folderName)) {
                throw new ServiceException(Message.format((String)"ServerRoot.duplicateFolder.fmt.txt", (Object)(ROOTFOLDERPATH + folderName)));
            }
            try {
                RootFolderInterface root = this.createRepositoryRootFolder(repos);
                if (root != null) {
                    topLevelFolder = root.makeSubfolder(folderName);
                    Tree tree = (Tree)topLevelFolder.getRepositoryEntity();
                    SoftwareComponent sc = (SoftwareComponent)this._repositoryObject;
                    tree.getSoftwareComponents().add((Object)sc);
                }
            }
            catch (MdException e) {
                throw new ServiceException(Message.format((String)"ServerRoot.createFolderError.fmt.txt", (Object)(ROOTFOLDERPATH + folderName)));
            }
        }
        return topLevelFolder;
    }

    @Override
    public boolean moveMembersOnOverflow() throws ServiceException, RemoteException {
        return false;
    }

    @Override
    public RootFolderInterface createRepositoryRootFolder(OMIRepositoryInterface repos) throws ServiceException, RemoteException {
        int flags = 392;
        String options = "<XMLSELECT SEARCH=\"*[@Name='BIP Service' and @ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06']\" />";
        Filter filter = new Filter();
        filter.setType("SoftwareComponent");
        filter.setExplicitSearchString("omi", options);
        filter.setOMRFlags(flags);
        List objects = repos.search(filter);
        if (objects != null && objects.size() > 0) {
            Object obj = objects.get(0);
            if (obj instanceof RootFolderInterface) {
                return (RootFolderInterface)obj;
            }
            return null;
        }
        throw new ServiceException(Message.format((String)"ServerRoot.missingRootFolder.fmt.txt", (Object)repos.getDefaultRepositoryName()));
    }
}

