/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.impl.TCPIPConnectionImpl;
import com.sas.metadata.remote.impl.TCPIPConnectionImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.OMRTCPIPConnection;
import com.sas.services.information.metadata.ProxyInterface;
import com.sas.services.information.metadata.RB;
import java.net.URI;
import java.rmi.RemoteException;

public class OMRProxy
extends OMRTCPIPConnection
implements ProxyInterface {
    protected static final String PROXY_PATH_PROPNAME = "ProxyPath";
    protected static final String PROXY_APP_PROTOCOL = "Proxy";
    protected static String[] m_supportedSchemes = new String[]{"http", "https"};
    protected static int[] m_defPorts = new int[]{80, 443};

    public OMRProxy(TCPIPConnection o) throws RemoteException {
        super(o);
    }

    public OMRProxy(TCPIPConnectionImpl o) throws RemoteException {
        super(o);
    }

    public OMRProxy(TCPIPConnectionImpl_Stub o) throws RemoteException {
        super(o);
    }

    public OMRProxy(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(repos, name, parent);
    }

    @Override
    public String getPath() throws ServiceException, RemoteException {
        StringBuilder path = new StringBuilder();
        TCPIPConnection proxyConn = (TCPIPConnection)this._repositoryObject;
        try {
            AssociationList properties = proxyConn.getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                Property pathProp = (Property)properties.get(i);
                if (!pathProp.getPropertyName().equals(PROXY_PATH_PROPNAME)) continue;
                path.append(pathProp.getDefaultValue());
            }
        }
        catch (MdException e) {
            throw new ServiceException(e, RB.getStringResource("Proxy.patherror.ex.txt"));
        }
        return path.toString();
    }

    @Override
    public String getScheme() throws RemoteException {
        return ((TCPIPConnection)this._repositoryObject).getCommunicationProtocol();
    }

    @Override
    public String getURI() throws ServiceException, RemoteException {
        String path;
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append(this.getScheme() + "://" + this.getHost());
        if (!this.isUsingDefaultPort()) {
            uriBuilder.append(":" + String.valueOf(this.getPort()));
        }
        if ((path = this.getPath()) != null && path.length() != 0) {
            uriBuilder.append(path);
        }
        return uriBuilder.toString();
    }

    private int getDefaultPortForScheme(String scheme) {
        for (int i = 0; i < m_supportedSchemes.length; ++i) {
            if (!m_supportedSchemes[i].equalsIgnoreCase(scheme)) continue;
            return m_defPorts[i];
        }
        return 0;
    }

    private boolean isUsingDefaultPort() throws ServiceException, RemoteException {
        return this.getPort() == this.getDefaultPortForScheme(this.getScheme());
    }

    @Override
    public void setPath(String path) throws RemoteException, ServiceException {
        TCPIPConnection proxyConn = (TCPIPConnection)this._repositoryObject;
        try {
            Property pathProp;
            AssociationList properties = proxyConn.getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                pathProp = (Property)properties.get(i);
                if (!pathProp.getPropertyName().equals(PROXY_PATH_PROPNAME)) continue;
                pathProp.setDefaultValue(path);
                return;
            }
            pathProp = (Property)((OMIRepositoryInterface)this._repository).createMetadata(RB.getStringResource("Proxy.pathpropname.ex.txt"), "Property");
            pathProp.setPropertyName(PROXY_PATH_PROPNAME);
            pathProp.setSQLType(12);
            pathProp.setDefaultValue(path);
            proxyConn.getProperties().add((Object)pathProp);
        }
        catch (MdException e) {
            throw new ServiceException(e, RB.getStringResource("Proxy.setpatherror.ex.txt"));
        }
    }

    @Override
    public void setScheme(String scheme) throws RemoteException {
        ((TCPIPConnection)this._repositoryObject).setCommunicationProtocol(scheme);
    }

    @Override
    public void setURI(String uri) throws ServiceException, RemoteException {
        URI ourURI = URI.create(uri);
        this.validate(ourURI);
        this.initializeFromURI(ourURI);
    }

    private void initializeFromURI(URI ourURI) throws RemoteException, ServiceException {
        this.setScheme(ourURI.getScheme());
        this.setHost(ourURI.getHost());
        int port = ourURI.getPort();
        if (port == -1) {
            this.setPort(this.getDefaultPortForScheme(ourURI.getScheme()));
        } else {
            this.setPort(port);
        }
        this.setPath(ourURI.getPath());
    }

    private void validate(URI uri) throws ServiceException {
        String scheme = uri.getScheme();
        boolean ok = false;
        if (scheme == null) {
            throw new ServiceException(RB.getStringResource("Proxy.invformaterror.ex.txt"));
        }
        for (int i = 0; i < m_supportedSchemes.length && !ok; ++i) {
            if (!m_supportedSchemes[i].equalsIgnoreCase(scheme)) continue;
            ok = true;
        }
        if (!ok) {
            throw new ServiceException(RB.getStringResource("Proxy.unsuppscheme.ex.txt"));
        }
        if (uri.getPort() != -1 && uri.getPort() > 65535) {
            throw new ServiceException(RB.getStringResource("Proxy.invalidport.ex.txt"));
        }
    }
}

