/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.impl.PropertySetImpl;
import com.sas.metadata.remote.impl.PropertySetImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.PropertySetInterface;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRPropertySet
extends Metadata
implements PropertySetInterface {
    private static final long serialVersionUID = -4087817372978942747L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRPropertySet() throws RemoteException {
        super(OMRPropertySet.class);
    }

    public OMRPropertySet(PropertySet o) throws RemoteException {
        super(o, OMRPropertySet.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPropertySet(PropertySetImpl o) throws RemoteException {
        super(o, OMRPropertySet.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPropertySet(PropertySetImpl_Stub o) throws RemoteException {
        super(o, OMRPropertySet.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPropertySet(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(OMRPropertySet.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omiRepos = null;
        try {
            omiRepos = (OMIRepositoryInterface)repos;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(RB.getStringResource("Metadata.wrongrepos.ex.txt"));
        }
        PropertySet propertyset = null;
        try {
            propertyset = (PropertySet)omiRepos.createMetadata(name, "PropertySet");
            propertyset.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
        }
        catch (ServiceException svcex) {
            String message = svcex.getMessage();
            throw new IllegalArgumentException(message);
        }
        this._repositoryObject = propertyset;
        this._repositoryFlag = 2;
        this.setRepository(repos);
        if (parent != null) {
            try {
                parent.addItem(this);
            }
            catch (Exception ex) {
                propertyset.delete();
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "PropertySet";
    }

    @Override
    public List getSetProperties() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> results = null;
        try {
            PropertySet prop = (PropertySet)this._repositoryObject;
            AssociationList propList = prop.getSetProperties();
            results = new ArrayList<MetadataInterface>(propList.size());
            Iterator it = propList.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                results.add(mi);
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
            return null;
        }
        return results;
    }

    @Override
    public void addSetProperty(PropertyInterface property) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            PropertySet prop = (PropertySet)this._repositoryObject;
            AssociationList propList = prop.getSetProperties();
            propList.add(property.getRepositoryEntity());
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
        }
    }

    @Override
    public void removeSetProperty(PropertyInterface property) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            PropertySet prop = (PropertySet)this._repositoryObject;
            AssociationList propList = prop.getSetProperties();
            propList.remove(property.getRepositoryEntity());
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
        }
    }

    @Override
    public void setSetProperties(List properties) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            PropertySet prop = (PropertySet)this._repositoryObject;
            AssociationList propList = prop.getSetProperties();
            propList.clear();
            propList.addAll((Collection)properties);
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
        }
    }

    @Override
    public void setOwningObject(MetadataInterface owner) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            PropertySet prop = (PropertySet)this._repositoryObject;
            prop.setOwningObject((Root)owner.getRepositoryEntity());
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
        }
    }

    @Override
    public MetadataInterface getOwningObject() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            PropertySet prop = (PropertySet)this._repositoryObject;
            MetadataInterface mi = this._repository.factoryProcess(prop.getOwningObject());
            return mi;
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
            return null;
        }
    }

    @Override
    public void setSetRole(String role) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            PropertySet prop = (PropertySet)this._repositoryObject;
            prop.setSetRole(role);
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
        }
    }

    @Override
    public String getSetRole() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            PropertySet prop = (PropertySet)this._repositoryObject;
            return prop.getSetRole();
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
            return null;
        }
    }
}

