/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.metadata.remote.impl.TransformationImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MessageQueueInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.MetadataNameConstraint;
import com.sas.services.information.metadata.OMRAbstractQueueManager;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.TCPIPConnectionInterface;
import com.sas.services.util.Names;
import com.sas.services.util.UpgradeInterface;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRMessageQueue
extends Metadata
implements MessageQueueInterface,
UpgradeInterface {
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRMessageQueue() throws RemoteException {
        super(OMRMessageQueue.class);
    }

    public OMRMessageQueue(Transformation transformation) throws RemoteException {
        super(transformation, OMRMessageQueue.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRMessageQueue(TransformationImpl transformation) throws RemoteException {
        super(transformation, OMRMessageQueue.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRMessageQueue(TransformationImpl_Stub transformation) throws RemoteException {
        super(transformation, OMRMessageQueue.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRMessageQueue(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Transformation transformation = (Transformation)omirepository.createMetadata(name, "Transformation");
                transformation.setPublicType("MessageQueue");
                transformation.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                transformation.setTransformRole("SASMessageQueue");
                this._repositoryObject = transformation;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    transformation.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
    }

    public OMRMessageQueue(RepositoryInterface repository, String queueName, String queueDescription, ServerComponentInterface queueManager) throws ServiceException, RemoteException {
        super(OMRMessageQueue.class);
        if (repository == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.repository.ex.txt"));
        }
        if (queueName == null || queueName.trim().length() == 0) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.name.ex.txt"));
        }
        if (queueManager == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.serverComponent.ex.txt"));
        }
        if (!"SASMessageQueue".equals(queueManager.getClassIdentifier())) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"OMRMessageQueue.serverComponentNotQueueManager.ex.fmt.txt", (Object)queueManager.getName()));
        }
        ServerComponent serverComponent = (ServerComponent)queueManager.getRepositoryEntity();
        Transformation transformation = null;
        try {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repository;
            transformation = (Transformation)omirepository.createMetadata(queueName, "Transformation");
            transformation.setPublicType("MessageQueue");
            transformation.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            transformation.setTransformRole("SASMessageQueue");
            transformation.setDesc(queueDescription);
            AssociationList depComponents = transformation.getDeployedComponents();
            if (!depComponents.contains(serverComponent)) {
                depComponents.add(serverComponent);
            }
            this._repositoryObject = transformation;
            this._repositoryFlag = 2;
            this.setRepository(repository);
        }
        catch (MdException e) {
            if (transformation != null) {
                transformation.delete();
            }
            throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"OMRMessageQueue.create.ex.fmt.txt", (Object)queueName));
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "MessageQueue";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getQueueURI() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        String queueURI = null;
        Transformation transformation = this.getTransformation();
        ServerComponentInterface serverComponent = this.getQueueManager();
        if (serverComponent == null) throw new ServiceException(RB.getStringResource("OMRMessageQueue.createURI.ex.fmt.txt"));
        String protocol = serverComponent.getApplicationProtocol();
        if ("Websphere".equals(protocol)) {
            return this.createURIForMQSeries(transformation, serverComponent);
        }
        if (!"MSMQ".equals(protocol)) throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMRMessageQueue.unknownProtocol.ex.fmt.txt", (Object)protocol));
        return this.createURIForMSMQ(transformation, serverComponent);
    }

    private String createURIForMQSeries(Transformation queue, ServerComponentInterface serverComponent) throws ServiceException {
        StringBuffer stringBuffer = null;
        try {
            String queueManagerName;
            int length = 5;
            String protocol = "MQSERIES";
            String queueName = queue.getName();
            if ("MQSERIES" != null) {
                length += "MQSERIES".length();
            }
            if ((queueManagerName = serverComponent.getName()) != null) {
                length += queueManagerName.length();
            }
            if (queueName != null) {
                length += queueName.length();
            }
            stringBuffer = new StringBuffer(length);
            if ("MQSERIES" != null) {
                stringBuffer.append("MQSERIES");
                stringBuffer.append("://");
            }
            if (queueManagerName != null) {
                stringBuffer.append(queueManagerName);
                stringBuffer.append(':');
            }
            if (queueName != null) {
                stringBuffer.append(queueName);
            }
        }
        catch (RemoteException e) {
            throw new ServiceException(e, RB.getStringResource("OMRMessageQueue.createURIForMQSeries.ex.txt"));
        }
        return stringBuffer.toString();
    }

    private String createURIForMSMQ(Transformation queue, ServerComponentInterface serverComponent) throws ServiceException {
        StringBuffer stringBuffer = null;
        try {
            String host;
            int length = 5;
            String protocol = "MSMQ";
            String queueName = queue.getName();
            if ("MSMQ" != null) {
                length += "MSMQ".length();
            }
            if (queueName != null) {
                length += queueName.length();
            }
            if ((host = serverComponent.getHost()) == null || host.length() == 0) {
                host = ".";
            }
            if (host != null) {
                length += host.length();
            }
            stringBuffer = new StringBuffer(length);
            if ("MSMQ" != null) {
                stringBuffer.append("MSMQ");
                stringBuffer.append("://");
            }
            if (host != null) {
                stringBuffer.append(host);
                stringBuffer.append('\\');
            }
            if (queueName != null) {
                stringBuffer.append(queueName);
            }
        }
        catch (RemoteException e) {
            throw new ServiceException(e, RB.getStringResource("OMRMessageQueue.createURIForMSMQ.ex.txt"));
        }
        return stringBuffer.toString();
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this._repository.refreshEntity(this);
        Transformation transformation = this.getTransformation();
        try {
            AssociationList depComponents = transformation.getDeployedComponents(true);
            Iterator iter = depComponents.iterator();
            DeployedComponent deployedComponent = null;
            while (iter.hasNext()) {
                deployedComponent = (DeployedComponent)iter.next();
                ((MdObjectStore)deployedComponent.getObjectStore()).refreshObjectFromServer((CMetadata)deployedComponent, false, true);
            }
        }
        catch (MdException mex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRMessageQueue", mex);
        }
    }

    private Transformation getTransformation() {
        return (Transformation)this._repositoryObject;
    }

    @Override
    public ServerComponentInterface getQueueManager() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Transformation transformation = this.getTransformation();
        try {
            AssociationList dcList = transformation.getDeployedComponents();
            if (dcList.size() > 0) {
                DeployedComponent dc = (DeployedComponent)dcList.get(0);
                ServerComponentInterface sci = (ServerComponentInterface)this._repository.factoryProcess(dc);
                return sci;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return null;
    }

    @Override
    public void setQueueManager(ServerComponentInterface server) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (!"SASMessageQueue".equals(server.getClassIdentifier())) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"OMRMessageQueue.serverComponentNotQueueManager.ex.fmt.txt", (Object)server.getName()));
        }
        Transformation transformation = this.getTransformation();
        try {
            AssociationList dcList = transformation.getDeployedComponents();
            dcList.clear();
            if (dcList.size() > 0) {
                DeployedComponent dc = (DeployedComponent)server.getRepositoryEntity();
                dcList.add(dc);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public TCPIPConnectionInterface getServerConnection() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Transformation transformation = this.getTransformation();
        try {
            AssociationList dcList = transformation.getDeployedComponents();
            if (dcList.size() > 0) {
                DeployedComponent dc = (DeployedComponent)dcList.get(0);
                TCPIPConnection tc = (TCPIPConnection)dc.getSourceConnections().get(0);
                TCPIPConnectionInterface tci = (TCPIPConnectionInterface)this._repository.factoryProcess(tc);
                return tci;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return null;
    }

    @Override
    public void setServerConnection(TCPIPConnectionInterface connection) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Transformation transformation = this.getTransformation();
        try {
            AssociationList dcList = transformation.getDeployedComponents();
            if (dcList.size() > 0) {
                DeployedComponent dc = (DeployedComponent)dcList.get(0);
                AssociationList conns = dc.getSourceConnections();
                conns.clear();
                TCPIPConnection tc = (TCPIPConnection)connection.getRepositoryEntity();
                conns.add(tc);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (this._repositoryObject != null && this._repositoryObject instanceof Transformation) {
            if (!this.getUsageVersion().isCompatible(new UsageVersion(0, 0), CURRENT_VERSION)) {
                throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
            }
            Transformation mQueue = (Transformation)this._repositoryObject;
            while (!Names.validateOMRObjectName(mQueue.getName(), false)) {
                String value;
                String name = null;
                if (mQueue.getName().length() > 60) {
                    name = mQueue.getName().substring(0, 60);
                } else if (Character.isSpaceChar(mQueue.getName().charAt(0)) || Character.isSpaceChar(mQueue.getName().charAt(mQueue.getName().length() - 1))) {
                    name = mQueue.getName().trim();
                } else if (mQueue.getName().contains("\\")) {
                    value = "\\";
                    name = mQueue.getName().substring(mQueue.getName().indexOf("\\") + value.length());
                } else if (mQueue.getName().contains("/")) {
                    value = "/";
                    name = mQueue.getName().substring(mQueue.getName().indexOf("/") + value.length());
                }
                if (name == null) continue;
                mQueue.setName(name);
            }
            if (mQueue.getUsageVersion() < CURRENT_VERSION.encode()) {
                mQueue.setUsageVersion(CURRENT_VERSION.encode());
            }
            MessageQueueNameConstraint constraint = null;
            FolderInterface fi = this.getParent();
            if (fi == null) {
                Metadata qMan = null;
                Transformation queueObject = (Transformation)this._repositoryObject;
                try {
                    if (queueObject.getDeployedComponents() != null && queueObject.getDeployedComponents().size() != 0) {
                        ServerComponent sc = (ServerComponent)((Transformation)this._repositoryObject).getDeployedComponents().get(0);
                        if (sc.getUsageVersion() < CURRENT_VERSION.encode()) {
                            sc.setUsageVersion(CURRENT_VERSION.encode());
                        }
                        if (sc.getPublicType().length() == 0) {
                            if (sc.getClassIdentifier().equals("MessageQueue.Websphere")) {
                                sc.setPublicType("MQM.Websphere");
                            } else if (sc.getClassIdentifier().equals("MessageQueue.MSMQ")) {
                                sc.setPublicType("MQM.MSMQ");
                            }
                        }
                        qMan = (OMRAbstractQueueManager)this._repository.factoryProcess(sc);
                    }
                }
                catch (MdException e) {
                    throw new ServiceException(e, e.getMessage());
                }
                if (null == qMan) {
                    this.logMessage(Level.WARN, "When the message queue " + this.getName() + " was being upgraded, no queue manager was found.  This queue will be placed in the Message Queues folder.");
                    fi = this.GetMessageQueueFolder();
                } else {
                    FolderInterface ourFolder;
                    String ourReposID;
                    String qManReposID;
                    fi = qMan.getParent();
                    if (null == fi) {
                        ((OMRAbstractQueueManager)qMan).upgradeFromPreviousVersion();
                        fi = qMan.getParent();
                    }
                    if (!(qManReposID = qMan.getReposId().substring(0, 8)).equals(ourReposID = this.getReposId().substring(0, 8)) && null == (fi = (ourFolder = this.GetMessageQueueFolder()).getSubfolder(qMan.getName()))) {
                        fi = ourFolder.makeSubfolder(qMan.getName());
                        fi.update();
                    }
                }
                if (null == fi) {
                    throw new ServiceException(RB.getStringResource("OMRMessageQueue.noFolder.ex.txt"));
                }
                constraint = new MessageQueueNameConstraint(this, (OMRAbstractQueueManager)qMan);
            }
            this.validateNameAndFolder(fi, constraint);
            this.update();
        }
    }

    private FolderInterface getRootFolder() throws RemoteException, ServiceException {
        boolean isFoundation = this._repository.getServer().getFoundationRepository().getUniqueId().equals(this._repository.getUniqueId());
        FolderInterface fi = isFoundation ? this._repository.getServer().getRootFolder() : (FolderInterface)this._repository.getRootFolders().get(0);
        return fi;
    }

    private FolderInterface GetMessageQueueFolder() throws ServiceException, RemoteException {
        FolderInterface folder;
        FolderInterface root = this.getRootFolder();
        FolderInterface parent = root.getSubfolder("Shared Data");
        if (null == parent) {
            parent = root.makeSubfolder("Shared Data");
            parent.update();
        }
        if (null == (folder = parent.getSubfolder("Message Queues"))) {
            folder = root.makeSubfolder("Message Queues");
            folder.update();
        }
        return folder;
    }

    @SASScope
    private class MessageQueueNameConstraint
    implements MetadataNameConstraint {
        private OMRMessageQueue m_queue;
        private OMRAbstractQueueManager m_qMan;

        MessageQueueNameConstraint(OMRMessageQueue queue, OMRAbstractQueueManager qMan) {
            this.m_queue = queue;
            this.m_qMan = qMan;
        }

        @Override
        public boolean isNameValid(MetadataInterface object, String name) throws ServiceException, RemoteException {
            boolean isUnique = true;
            String query = this.m_qMan != null ? "<XMLSelect search=\"*[@PublicType=:'MessageQueue' and @Name='" + name + "'][DeployedComponents/ServerComponent[@Name='" + this.m_qMan.getName() + "']]\"/>" : "<XMLSelect search=\"*[@PublicType=:'MessageQueue' and @Name='" + name + "']\"/>";
            Filter filter = new Filter();
            filter.setType("Transformation");
            filter.setOMRFlags(16384);
            filter.setExplicitSearchString("omi", query);
            int count = ((MetadataServerInterface)this.m_queue.getRepository().getServer()).getCountNoSecurity(filter, null);
            if (count > 0) {
                List queues = ((MetadataServerInterface)this.m_queue.getRepository().getServer()).search(filter);
                boolean skip = false;
                for (int i = 0; i < queues.size() && !skip; ++i) {
                    if (!((OMRMessageQueue)queues.get(i)).getReposId().equals(this.m_queue.getReposId())) continue;
                    skip = true;
                }
                if (!skip) {
                    isUnique = false;
                }
            }
            return isUnique;
        }
    }
}

