/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.metadata.remote.impl.ServerComponentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.HttpServerInterface;
import com.sas.services.information.metadata.OMRServerComponent;
import com.sas.services.information.metadata.RB;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.UsageVersion;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRHttpServer
extends OMRServerComponent
implements HttpServerInterface,
Serializable {
    private static final long serialVersionUID = 281536572153488852L;
    private static final int EMPTY_LIST_INIT = 1;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRHttpServer() throws RemoteException {
        super(OMRHttpServer.class);
    }

    public OMRHttpServer(ServerComponent o) throws RemoteException {
        super(o, OMRHttpServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRHttpServer(ServerComponentImpl o) throws RemoteException {
        super(o, OMRHttpServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRHttpServer(ServerComponentImpl_Stub o) throws RemoteException {
        super(o, OMRHttpServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRHttpServer(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(OMRHttpServer.class);
        if (repos == null || name == null || parent == null) {
            throw new IllegalArgumentException();
        }
        try {
            DeployedComponent dc = (DeployedComponent)((OMIRepositoryInterface)repos).createMetadata(name, "ServerComponent");
            dc.setClassIdentifier("DAC0D7F0-10DA-11D6-8816-AA0004006D06");
            dc.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = dc;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            try {
                parent.addItem(this);
            }
            catch (Exception ex) {
                dc.delete();
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
        }
    }

    @Override
    public PropertyList getSubstitutionProperties() {
        PropertyList srvProperties = new PropertyList();
        try {
            srvProperties = super.getSubstitutionProperties();
            if (this.getTypeDescriptor() != null) {
                int pathCount = 0;
                AssociationList packages = ((ServerComponent)this._repositoryObject).getDataPackages(true);
                if (packages != null && packages.size() > 0) {
                    for (int i = 0; i < packages.size(); ++i) {
                        DeployedDataPackage iDDP = (DeployedDataPackage)packages.get(i);
                        if (!(iDDP instanceof Directory)) continue;
                        ++pathCount;
                        if (i == 0 && packages.size() == 1) {
                            srvProperties.addProperty("DirPath", ((Directory)iDDP).getDirectoryName());
                            continue;
                        }
                        srvProperties.addProperty("DirPath", i + 1, ((Directory)iDDP).getDirectoryName());
                    }
                }
            }
        }
        catch (ServiceException e) {
            throw new UnexpectedSubstitutionException((Throwable)((Object)e));
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        return srvProperties;
    }

    @Override
    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        try {
            super.setSubstitutionProperties(map);
            AssociationList packages = ((ServerComponent)this._repositoryObject).getDataPackages(true);
            for (int i = 0; i < packages.size(); ++i) {
                String path;
                DeployedDataPackage iDDP = (DeployedDataPackage)packages.get(i);
                if (!(iDDP instanceof Directory)) continue;
                if (i == 0 && packages.size() == 1 && map.containsProperty("DirPath")) {
                    path = map.getProperty("DirPath");
                    if (path == ((Directory)iDDP).getDirectoryName()) continue;
                    ((Directory)iDDP).setDirectoryName(path);
                    continue;
                }
                if (!map.containsIndexedProperty("DirPath", i + 1) || (path = map.getProperty("DirPath", i + 1)) == ((Directory)iDDP).getDirectoryName()) continue;
                ((Directory)iDDP).setDirectoryName(path);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "Server.Http";
    }

    @Override
    public String getUrl() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        String result = "";
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList ass = server.getSourceConnections();
            for (Object o : ass) {
                if (!(o instanceof TCPIPConnection)) continue;
                TCPIPConnection con = (TCPIPConnection)o;
                String host = con.getHostName();
                int port = con.getPort();
                String protocol = con.getApplicationProtocol();
                return protocol + "://" + host + (port > 0 ? ":" + port : "");
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRHttpServer", ex);
        }
        return result;
    }

    @Override
    public String getProxyUrl() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        String result = "";
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList ass = server.getProperties();
            for (Property prop : ass) {
                String name = prop.getPropertyName();
                if (name == null) {
                    name = prop.getName();
                }
                if (!name.equalsIgnoreCase("ProxyURL")) continue;
                return prop.getDefaultValue();
            }
            ass = server.getSourceConnections();
            for (Object o : ass) {
                if (!(o instanceof TCPIPConnection)) continue;
                TCPIPConnection con = (TCPIPConnection)o;
                AssociationList props = con.getProperties();
                for (Property prop : props) {
                    String name = prop.getPropertyName();
                    if (name == null) {
                        name = prop.getName();
                    }
                    if (!name.equalsIgnoreCase("ProxyURL")) continue;
                    return prop.getDefaultValue();
                }
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRHttpServer", ex);
        }
        return result;
    }

    @Override
    public void setProxyUrl(String proxyUrl) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList ass = server.getProperties();
            for (Property prop : ass) {
                String name = prop.getPropertyName();
                if (name == null) {
                    name = prop.getName();
                }
                if (!name.equalsIgnoreCase("ProxyURL")) continue;
                prop.setDefaultValue(proxyUrl);
                return;
            }
            MdObjectStore store = (MdObjectStore)server.getObjectStore();
            MdFactory factory = store.getFactory();
            Property prop = (Property)factory.createComplexMetadataObject(store, null, "ProxyURL", "Property", server.getRepositoryID());
            prop.setName("ProxyURL");
            prop.setPropertyName("ProxyURL");
            prop.setDefaultValue(proxyUrl);
            PropertyType propType = (PropertyType)factory.createComplexMetadataObject(store, null, "StringType", "PropertyType", server.getRepositoryID());
            propType.setSQLType(12);
            prop.setOwningType(propType);
            ass.add((Object)prop);
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRHttpServer", ex);
        }
    }

    @Override
    public List getDomains() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<String> result = null;
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList connList = server.getSourceConnections();
            result = new ArrayList(connList.size());
            for (Connection connection : connList) {
                AuthenticationDomain dom = connection.getDomain();
                if (dom == null) continue;
                result.add(dom.getName());
            }
        }
        catch (Exception e) {
            result = new ArrayList<String>(1);
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRHttpServer", e);
        }
        return result;
    }

    @Override
    public String getAuthenticationType() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        String result = "";
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList ass = server.getSourceConnections();
            for (Object o : ass) {
                if (!(o instanceof TCPIPConnection)) continue;
                TCPIPConnection con = (TCPIPConnection)o;
                return con.getAuthenticationType();
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRHttpServer", ex);
        }
        return result;
    }

    @Override
    public void setAuthenticationType(String authType) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList ass = server.getSourceConnections();
            for (Object o : ass) {
                if (!(o instanceof TCPIPConnection)) continue;
                TCPIPConnection con = (TCPIPConnection)o;
                con.setAuthenticationType(authType);
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRHttpServer", ex);
        }
    }
}

