/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.impl.DeployedDataPackageImpl;
import com.sas.metadata.remote.impl.FileImpl;
import com.sas.metadata.remote.impl.FileImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ConnectionInterface;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.FileInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRDeployedDataPackage;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRFile
extends OMRDeployedDataPackage
implements FileInterface {
    private static final long serialVersionUID = -21953758288212563L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRFile() throws RemoteException {
    }

    public OMRFile(File o) throws RemoteException {
        super((DeployedDataPackage)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRFile(FileImpl o) throws RemoteException {
        super((DeployedDataPackageImpl)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRFile(FileImpl_Stub o) throws RemoteException {
        super((DeployedDataPackage)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRFile(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                File file = (File)omirepository.createMetadata(name, "File");
                file.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = file;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    file.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRColumn", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "File";
    }

    @Override
    public boolean isARelativeName() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        boolean result = file.getIsARelativeName() != 0;
        return result;
    }

    @Override
    public void setIsARelativeName(boolean isRelative) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        file.setIsARelativeName(isRelative ? 1 : 0);
    }

    @Override
    public String getFileName() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        return file.getFileName();
    }

    @Override
    public void setFileName(String name) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        file.setFileName(name);
    }

    @Override
    public String getFileExtension() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        return file.getFileExtension();
    }

    @Override
    public void setFileExtension(String extension) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        file.setFileExtension(extension);
    }

    @Override
    public String getTextRole() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        return file.getTextRole();
    }

    @Override
    public void setTextRole(String textRole) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        file.setTextRole(textRole);
    }

    @Override
    public String getTextType() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        return file.getTextType();
    }

    @Override
    public void setTextType(String textType) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        file.setTextType(textType);
    }

    @Override
    public List getDirectories() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        ArrayList<MetadataInterface> results = null;
        try {
            AssociationList directoryList = file.getDirectories();
            if (directoryList.size() > 0) {
                results = new ArrayList<MetadataInterface>(directoryList.size());
                Iterator it = directoryList.iterator();
                while (it.hasNext()) {
                    MetadataInterface mi = this._repository.factoryProcess(it.next());
                    results.add(mi);
                }
            } else {
                results = Collections.EMPTY_LIST;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addDirectory(DirectoryInterface directory) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        try {
            AssociationList directoryList = file.getDirectories();
            directoryList.add(directory.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeDirectory(DirectoryInterface directory) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        try {
            AssociationList directoryList = file.getDirectories();
            directoryList.remove(directory.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setDirectories(List directories) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        try {
            AssociationList directoryList = file.getDirectories();
            directoryList.clear();
            for (DirectoryInterface di : directories) {
                directoryList.add(di.getRepositoryEntity());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getScriptedConnections() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        ArrayList<MetadataInterface> results = null;
        try {
            AssociationList connList = file.getScriptedConnections();
            if (connList.size() > 0) {
                results = new ArrayList<MetadataInterface>(connList.size());
                Iterator it = connList.iterator();
                while (it.hasNext()) {
                    MetadataInterface mi = this._repository.factoryProcess(it.next());
                    results.add(mi);
                }
            } else {
                results = Collections.EMPTY_LIST;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addScriptedConnection(SASClientConnectionInterface connection) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        try {
            AssociationList connList = file.getScriptedConnections();
            connList.add(connection.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeScriptedConnection(SASClientConnectionInterface connection) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        try {
            AssociationList connList = file.getScriptedConnections();
            connList.remove(connection.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setScriptedConnections(List connections) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        File file = (File)this._repositoryObject;
        try {
            AssociationList connList = file.getScriptedConnections();
            connList.clear();
            for (ConnectionInterface ci : connections) {
                connList.add(ci.getRepositoryEntity());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }
}

