/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Email;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.impl.EmailImpl;
import com.sas.metadata.remote.impl.EmailImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.EmailInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMREmail
extends Metadata
implements EmailInterface {
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    protected OMREmail(Class theClass) throws RemoteException {
        super(theClass);
    }

    public OMREmail() throws RemoteException {
        this(OMREmail.class);
    }

    protected OMREmail(Email o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public OMREmail(Email o) throws RemoteException {
        super(o, OMREmail.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMREmail(EmailImpl o) throws RemoteException {
        super(o, OMREmail.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMREmail(EmailImpl_Stub o) throws RemoteException {
        super(o, OMREmail.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMREmail(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMREmail.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Email email = (Email)omirepository.createMetadata(name, "Email");
                email.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = email;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    email.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMREmail", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getAddress() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Email email = (Email)this._repositoryObject;
        return email.getAddress();
    }

    @Override
    public String getEmailType() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Email email = (Email)this._repositoryObject;
        return email.getEmailType();
    }

    @Override
    public List<MetadataInterface> getEmailSubscriber() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Email email = (Email)this._repositoryObject;
        try {
            AssociationList subscriberList = email.getEmailSubscriber();
            ArrayList<MetadataInterface> list = new ArrayList<MetadataInterface>(subscriberList.size());
            if (subscriberList != null) {
                Iterator e = subscriberList.iterator();
                while (e.hasNext()) {
                    MetadataInterface mi = this._repository.factoryProcess(e.next());
                    list.add(mi);
                }
            }
            return list;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List<PersonInterface> getPersons() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Email email = (Email)this._repositoryObject;
        try {
            AssociationList personList = email.getPersons();
            ArrayList<PersonInterface> list = new ArrayList<PersonInterface>(personList.size());
            if (personList != null) {
                Iterator e = personList.iterator();
                while (e.hasNext()) {
                    PersonInterface pi = (PersonInterface)this._repository.factoryProcess(e.next());
                    list.add(pi);
                }
            }
            return list;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setAddress(String address) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Email email = (Email)this._repositoryObject;
        email.setAddress(address);
    }

    @Override
    public void setEmailType(String inEmailType) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Email email = (Email)this._repositoryObject;
        email.setEmailType(inEmailType);
    }

    @Override
    public void setEmailSubscribers(List<MetadataInterface> subscribers) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Email email = (Email)this._repositoryObject;
        try {
            AssociationList subscriberlist = email.getEmailSubscriber();
            subscriberlist.clear();
            if (subscribers != null) {
                Iterator<MetadataInterface> e = subscribers.iterator();
                while (e.hasNext()) {
                    subscriberlist.add(e.next().getRepositoryEntity());
                }
            }
            email.setEmailSubscriber(subscriberlist);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setPersons(List<PersonInterface> persons) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Email email = (Email)this._repositoryObject;
        try {
            AssociationList personlist = email.getPersons();
            personlist.clear();
            if (persons != null) {
                Iterator<PersonInterface> e = persons.iterator();
                while (e.hasNext()) {
                    personlist.add(e.next().getRepositoryEntity());
                }
            }
            email.setPersons(personlist);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }
}

