/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ContentType;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.impl.DocumentImpl;
import com.sas.metadata.remote.impl.DocumentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.DocumentInterface;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.util.UpgradeInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRDocument
extends Metadata
implements DocumentInterface,
UpgradeInterface {
    private static final long serialVersionUID = 408094090754984877L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRDocument() throws RemoteException {
    }

    public OMRDocument(Object o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDocument(Document o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDocument(DocumentImpl o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDocument(DocumentImpl_Stub o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDocument(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            try {
                Document doc = (Document)omirepository.createMetadata(name, "Document");
                doc.setPublicType("Document");
                doc.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = doc;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (ServiceException ex) {
                    doc.delete();
                    throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
                }
            }
            catch (ServiceException ex) {
                this.logThrowable(Level.WARN, ex.getMessage(), "com.sas.services.information.metadata.OMRDocument", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "Document";
    }

    @Override
    public String getTextRole() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Document doc = (Document)this._repositoryObject;
        return doc.getTextRole();
    }

    @Override
    public String getTextType() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Document doc = (Document)this._repositoryObject;
        return doc.getTextType();
    }

    @Override
    public String getURI() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Document doc = (Document)this._repositoryObject;
        return doc.getURI();
    }

    @Override
    public void setTextRole(String role) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Document doc = (Document)this._repositoryObject;
        doc.setTextRole(role);
    }

    @Override
    public void setTextType(String type) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Document doc = (Document)this._repositoryObject;
        doc.setTextType(type);
    }

    @Override
    public void setURI(String uri) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Document doc = (Document)this._repositoryObject;
        doc.setURI(uri);
    }

    @Override
    public String getDocumentType() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Document doc = (Document)this._repositoryObject;
            ContentType type = doc.getAssociatedContentType();
            if (type != null) {
                return type.getName();
            }
            return this.getType();
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, ex.getMessage(), "com.sas.services.information.metadata.OMRDocument", ex);
            return null;
        }
    }

    @Override
    public void addObject(MetadataInterface newObject) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            Document doc = (Document)this._repositoryObject;
            Root obj = (Root)newObject.getRepositoryEntity();
            AssociationList objList = doc.getObjects();
            objList.add(obj);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeObject(MetadataInterface object) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            Document doc = (Document)this._repositoryObject;
            Root obj = (Root)object.getRepositoryEntity();
            AssociationList objList = doc.getObjects();
            objList.remove(obj);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setObjects(List objectList) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            Document doc = (Document)this._repositoryObject;
            AssociationList objList = doc.getObjects();
            objList.clear();
            for (MetadataInterface newObject : objectList) {
                Root obj = (Root)newObject.getRepositoryEntity();
                objList.add(obj);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getObjects() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>();
        try {
            Document doc = (Document)this._repositoryObject;
            AssociationList objList = doc.getObjects();
            for (MetadataInterface newObject : objList) {
                Root obj = (Root)newObject.getRepositoryEntity();
                MetadataInterface mi = this._repository.factoryProcess(obj);
                results.add(mi);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (!this.getUsageVersion().isCompatible(new UsageVersion(0, 0), OMRDocument.CURRENT_VERSION)) {
            throw new VersionIncompatibleException(this.getClass().getName(), OMRDocument.CURRENT_VERSION, this.getUsageVersion());
        }
        jomaObject = (Document)this._repositoryObject;
        if (!jomaObject.getPublicType().equals("Document")) {
            jomaObject.setPublicType("Document");
        }
        if (jomaObject.getUsageVersion() < OMRDocument.CURRENT_VERSION.encode()) {
            jomaObject.setUsageVersion(OMRDocument.CURRENT_VERSION.encode());
        }
        repository = null;
        targetFolder = this.getParent();
        repository = targetFolder != null ? targetFolder.getRepository() : this._repository;
        if (targetFolder == null) {
            folderSet = false;
            docReposId = jomaObject.getFQID().substring(0, 8);
            try {
                docObjectsList = jomaObject.getObjects();
                for (k = 0; k < docObjectsList.size(); ++k) {
                    obj = (Root)docObjectsList.get(k);
                    objReposId = obj.getFQID().substring(0, 8);
                    if (!objReposId.equals(docReposId) || (parentFolderList = obj.getTrees()).size() <= 0 || !(folderReposId = (parentFolder = (Tree)parentFolderList.get(0)).getFQID().substring(0, 8)).equals(docReposId)) continue;
                    folder = (Folder)repository.factoryProcess(parentFolder);
                    this.validateNameAndFolder(folder);
                    folderSet = true;
                    break;
                }
            }
            catch (MdException ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            if (!folderSet) {
                notesFolder = null;
                try {
                    notesFolder = FolderUtil.makeDocumentsFolder(this);
                    if (notesFolder == null) ** GOTO lbl41
                    notesFolder.moveMembersOnOverflow();
                    this.validateNameAndFolder(notesFolder);
                }
                catch (Exception e) {
                    throw new ServiceException(e, e.getMessage());
                }
            }
        } else {
            this.validateNameAndFolder(targetFolder);
        }
lbl41:
        // 4 sources

        try {
            jomaObject.getObjectStore().updatedMetadataAll();
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }
}

