/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DatabaseCatalog;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.impl.DatabaseCatalogImpl;
import com.sas.metadata.remote.impl.DatabaseCatalogImpl_Stub;
import com.sas.metadata.remote.impl.DeployedDataPackageImpl;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.DatabaseCatalogInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdentityGroupInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.LoginInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRDeployedDataPackage;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RelationalSchemaInterface;
import com.sas.services.information.metadata.servers.DataServerInterface;
import com.sas.services.information.metadata.servers.DatabaseInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRDatabaseCatalog
extends OMRDeployedDataPackage
implements DatabaseCatalogInterface,
DatabaseInterface {
    private static final long serialVersionUID = 2891178482190157300L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    protected OMRDatabaseCatalog(Class c) throws RemoteException {
        super(c);
    }

    public OMRDatabaseCatalog() throws RemoteException {
        this(OMRDatabaseCatalog.class);
    }

    protected OMRDatabaseCatalog(DatabaseCatalog o, Class c) throws RemoteException {
        super((DeployedDataPackage)o, c);
    }

    public OMRDatabaseCatalog(DatabaseCatalog o) throws RemoteException {
        this(o, OMRDatabaseCatalog.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRDatabaseCatalog(DatabaseCatalogImpl o, Class c) throws RemoteException {
        super((DeployedDataPackageImpl)o, c);
    }

    public OMRDatabaseCatalog(DatabaseCatalogImpl o) throws RemoteException {
        this(o, OMRDatabaseCatalog.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRDatabaseCatalog(DatabaseCatalogImpl_Stub o, Class c) throws RemoteException {
        super((DeployedDataPackage)o, c);
    }

    public OMRDatabaseCatalog(DatabaseCatalogImpl_Stub o) throws RemoteException {
        this(o, OMRDatabaseCatalog.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDatabaseCatalog(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRDatabaseCatalog.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                DatabaseCatalog databaseCatalog = (DatabaseCatalog)omirepository.createMetadata(name, "DatabaseCatalog");
                databaseCatalog.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = databaseCatalog;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    databaseCatalog.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRDatabaseCatalog", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "DatabaseCatalog";
    }

    @Override
    public List getSchemas() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>();
        DatabaseCatalog dc = (DatabaseCatalog)this._repositoryObject;
        try {
            AssociationList list = dc.getSchemas();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                result.add(mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return result;
    }

    @Override
    public void addSchema(RelationalSchemaInterface schema) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DatabaseCatalog dc = (DatabaseCatalog)this._repositoryObject;
        RelationalSchema rs = (RelationalSchema)schema.getRepositoryEntity();
        try {
            dc.getSchemas().add((Object)rs);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeSchema(RelationalSchemaInterface schema) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        DatabaseCatalog dc = (DatabaseCatalog)this._repositoryObject;
        RelationalSchema rs = (RelationalSchema)schema.getRepositoryEntity();
        try {
            dc.getSchemas().remove((Object)rs);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public Map<String, String> getDatabaseProperties() throws RemoteException, ServiceException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("DESCRIPTION", this.getDescription());
        LoginInterface login = this.getDataServerLogin();
        if (login != null) {
            result.put("USERNAME", login.getUserId());
            result.put("AUTHDOMAIN", login.getDomain());
        }
        return result;
    }

    @Override
    public void updateDatabaseProperties(Map<String, String> properties) throws RemoteException, ServiceException {
        String CUSTOM_ASSOCIATION_NAME = "AssociatedLogin";
        String CUSTOM_ASSOCIATION_PARTNER_NAME = "AssociatedDatabase";
        if (properties.containsKey("DESCRIPTION")) {
            this.setDescription(properties.get("DESCRIPTION"));
        }
        if (properties.containsKey("USERNAME") && properties.containsKey("PASSWORD")) {
            try {
                LoginInterface login = null;
                IdentityInterface identityGroup = null;
                String domain = "";
                if (properties.containsKey("AUTHDOMAIN")) {
                    domain = properties.get("AUTHDOMAIN");
                } else {
                    Map<String, String> svrProps;
                    DataServerInterface dataServer = this.getDataServer();
                    if (dataServer != null && (svrProps = dataServer.getServerProperties()).containsKey("AUTHDOMAIN")) {
                        domain = svrProps.get("AUTHDOMAIN");
                    }
                }
                LoginInterface existingLogin = this.getDataServerLogin();
                if (existingLogin != null) {
                    if (domain.equalsIgnoreCase(existingLogin.getDomain())) {
                        login = existingLogin;
                        Login mdLogin = (Login)login.getRepositoryEntity();
                        Identity mdIdentity = mdLogin.getAssociatedIdentity();
                        if (mdIdentity.getCMetadataType().equals("IdentityGroup") && mdIdentity.getName().equals(properties.get("IDENTITY_GROUP"))) {
                            identityGroup = (IdentityGroupInterface)this._repository.factoryProcess(mdIdentity);
                        } else {
                            mdLogin.getAssociatedIdentitys().remove((Object)mdIdentity);
                        }
                    } else {
                        existingLogin.delete();
                    }
                }
                if (identityGroup == null) {
                    Filter filter = new Filter("Name", 0, properties.get("IDENTITY_GROUP"));
                    filter.setType("IdentityGroup");
                    RepositoryInterface ri = this._repository;
                    List idGroupList = ri.search(filter);
                    identityGroup = idGroupList.size() > 0 ? (IdentityGroupInterface)idGroupList.get(0) : (IdentityGroupInterface)OMRDatabaseCatalog.getInformationService().newMetadata(null, properties.get("IDENTITY_GROUP"), this._repository, "IdentityGroup");
                }
                List logins = identityGroup.getLogins();
                for (LoginInterface groupLogin : logins) {
                    if (!groupLogin.getUserId().equalsIgnoreCase(properties.get("USERNAME")) || !groupLogin.getDomain().equalsIgnoreCase(properties.get("AUTHDOMAIN"))) continue;
                    login = groupLogin;
                    break;
                }
                if (login == null) {
                    login = (LoginInterface)OMRDatabaseCatalog.getInformationService().newMetadata(null, "Login." + properties.get("USERNAME"), this._repository, "Login");
                    login.setDomain(domain);
                    login.setUserId(properties.get("USERNAME"));
                    login.setPassword(properties.get("PASSWORD"));
                    Login mdLogin = (Login)login.getRepositoryEntity();
                    mdLogin.setAssociatedIdentity((Identity)identityGroup.getRepositoryEntity());
                } else {
                    login.setUserId(properties.get("USERNAME"));
                    login.setPassword(properties.get("PASSWORD"));
                }
                if (login != existingLogin) {
                    AssociationList caList = ((DatabaseCatalog)this._repositoryObject).getCustomAssociations();
                    if (caList != null && !caList.isEmpty()) {
                        CustomAssociation ca = (CustomAssociation)caList.get(0);
                        AssociationList assocObjs = ca.getAssociatedObjects();
                        assocObjs.removeAllElements();
                        assocObjs.add(login.getRepositoryEntity());
                    } else {
                        CustomAssociation custAssoc = (CustomAssociation)((OMIRepositoryInterface)login.getRepository()).createMetadata(CUSTOM_ASSOCIATION_NAME, "CustomAssociation");
                        custAssoc.setPartnerName(CUSTOM_ASSOCIATION_PARTNER_NAME);
                        custAssoc.setOwningObject((Root)((DatabaseCatalog)this._repositoryObject));
                        custAssoc.setisOwned(1);
                        custAssoc.getAssociatedObjects().add(login.getRepositoryEntity());
                    }
                }
            }
            catch (MdException e) {
                throw new ServiceException(e);
            }
        }
    }

    public DataServerInterface getDataServer() throws RemoteException, ServiceException {
        DeployedComponent dc;
        AssociationList dcList;
        DataServerInterface dataServer = null;
        try {
            dcList = ((DatabaseCatalog)this._repositoryObject).getDeployedComponents();
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        if (dcList != null && !dcList.isEmpty() && (dc = (DeployedComponent)dcList.get(0)).getPublicType().equals("Server.SASInfrastructureData")) {
            return (DataServerInterface)this._repository.factoryProcess(dc);
        }
        return dataServer;
    }

    public LoginInterface getDataServerLogin() throws RemoteException, ServiceException {
        LoginInterface result = null;
        try {
            CMetadata obj;
            CustomAssociation ca;
            AssociationList assocObjs;
            AssociationList caList = ((DatabaseCatalog)this._repositoryObject).getCustomAssociations();
            if (caList != null && !caList.isEmpty() && (assocObjs = (ca = (CustomAssociation)caList.get(0)).getAssociatedObjects()) != null && !assocObjs.isEmpty() && (obj = (CMetadata)assocObjs.get(0)).getCMetadataType().equals("Login")) {
                result = (LoginInterface)this._repository.factoryProcess(obj);
            }
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        return result;
    }
}

