/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.Keyword;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;

public abstract class MetadataBuilder<T extends MetadataInterface, J extends PrimaryType, B extends MetadataBuilder<T, J, B>> {
    private MdFactory factory = null;
    private MdObjectStore objectStore = null;
    private String repositoryId = null;
    private Class<J> metadataType;
    private String publicType;
    private double usageVersion;
    protected String prototypeName = null;
    protected Prototype prototype = null;
    protected Map<String, Property> prototypeProperties = null;
    protected UserContextInterface user = null;
    protected OMIServer metadataServer = null;
    protected RepositoryInterface repository = null;
    protected String repositoryName = null;
    protected String name = null;
    protected String desc = null;
    private Map<String, ExtensionDescriptor> extendedAttributes = null;
    private Set<String> keywords = null;
    protected Map<String, String> options = new LinkedHashMap<String, String>();
    protected static final String OTHER_OPTIONS_PROPERTY = "OPTIONSTRING";
    protected J built = null;
    protected T builtSmartObject = null;

    protected MetadataBuilder(Class<J> metadataType, String publicType, double usageVersion) {
        this.metadataType = metadataType;
        this.publicType = publicType;
        this.usageVersion = usageVersion;
    }

    public B name(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        Names.validateOMRObjectName(name, true);
        this.name = name;
        return (B)this;
    }

    public B desc(String desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.desc = desc;
        return (B)this;
    }

    public B keyword(String keyword) {
        if (keyword == null) {
            throw new NullPointerException();
        }
        if (this.keywords == null) {
            this.keywords = new LinkedHashSet<String>();
        }
        this.keywords.add(keyword);
        return (B)this;
    }

    public B option(String optionName) {
        if (optionName == null) {
            throw new NullPointerException();
        }
        this.options.put(optionName, optionName);
        return (B)this;
    }

    public B option(String optionName, String optionValue) {
        if (optionName == null || optionValue == null) {
            throw new NullPointerException();
        }
        this.options.put(optionName, optionValue);
        return (B)this;
    }

    public B extendedAttribute(String name, String value, String description) {
        if (name == null || value == null) {
            throw new NullPointerException();
        }
        if (this.extendedAttributes == null) {
            this.extendedAttributes = new LinkedHashMap<String, ExtensionDescriptor>();
        }
        this.extendedAttributes.put(name, new ExtensionDescriptor(name, value, description));
        return (B)this;
    }

    public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
        try {
            if (this.name == null) {
                throw new IllegalStateException("Name must be specified");
            }
            this.buildSetup(user);
            if (!this.options.isEmpty()) {
                this.loadPrototypeProperties();
                if (!this.prototypeProperties.containsKey(OTHER_OPTIONS_PROPERTY)) {
                    for (String option : this.options.keySet()) {
                        if (this.prototypeProperties.containsKey(option.toUpperCase())) continue;
                        throw new IllegalArgumentException(option + " is not a valid option");
                    }
                }
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    protected T buildInternal(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
        try {
            this.validate(user);
            this.createObject();
            if (this.builtSmartObject == null) {
                this.builtSmartObject = this.metadataServer.factoryProcess(this.built);
            }
            return this.builtSmartObject;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    protected final void buildSetup(UserContextInterface user) throws ServiceException {
        if (user == null) {
            throw new NullPointerException("UserContext must be specified");
        }
        try {
            this.user = user;
            this.metadataServer = (OMIServer)user.getAuthServer();
            if (this.repository == null) {
                this.repository = this.repositoryName == null ? this.metadataServer.getFoundationRepository() : this.metadataServer.getRepository(this.repositoryName);
            }
            this.repositoryId = ((OMIRepositoryInterface)this.repository).getDefaultRepositoryId();
            this.factory = this.metadataServer.getMdFactory();
            this.objectStore = this.metadataServer.getObjectStore();
            this.built = null;
            this.builtSmartObject = null;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    protected void createObject() throws RemoteException, MdException, ServiceException {
        this.built = (PrimaryType)this.factory.createComplexMetadataObject(this.objectStore, this.name, this.metadataType.getSimpleName(), this.repositoryId.substring(9));
        this.built.setDesc(this.desc);
        if (this.publicType != null) {
            this.built.setPublicType(this.publicType);
        }
        if (this.usageVersion != 0.0) {
            this.built.setUsageVersion(this.usageVersion);
        }
        if (this.keywords != null) {
            for (String string : this.keywords) {
                Keyword keywordObject = this.createMetadata(string, Keyword.class);
                keywordObject.getObjects().add(this.built);
            }
        }
        if (!this.options.isEmpty()) {
            StringBuilder otherOptions = new StringBuilder();
            for (String optionName : this.options.keySet()) {
                String upcased = optionName.toUpperCase();
                if (this.prototypeProperties.containsKey(upcased)) {
                    this.createPropertyFromPrototype(this.prototypeProperties.get(upcased), this.options.get(optionName));
                    continue;
                }
                if (otherOptions.length() > 0) {
                    otherOptions.append(" ");
                }
                otherOptions.append(optionName);
                otherOptions.append("=");
                otherOptions.append(this.options.get(optionName));
            }
            if (otherOptions.length() > 0) {
                this.createPropertyFromPrototype(this.prototypeProperties.get(OTHER_OPTIONS_PROPERTY), otherOptions.toString());
            }
        }
        if (this.extendedAttributes != null) {
            for (ExtensionDescriptor extensionDescriptor : this.extendedAttributes.values()) {
                Extension ext = this.createMetadata(extensionDescriptor.name, Extension.class);
                ext.setValue(extensionDescriptor.value);
                if (extensionDescriptor.description != null) {
                    ext.setDesc(extensionDescriptor.description);
                }
                ext.setOwningObject(this.built);
            }
        }
        if (this.prototype == null && this.prototypeName != null) {
            this.prototype = this.findMetadataByName(this.prototypeName, Prototype.class);
        }
        if (this.prototype != null) {
            this.built.setUsingPrototype((Root)this.prototype);
        }
    }

    protected void loadPrototypeProperties() throws RemoteException, MdException {
        if (this.prototype == null && this.prototypeName != null) {
            this.prototype = this.findMetadataByName(this.prototypeName, Prototype.class);
        }
        this.prototypeProperties = new HashMap<String, Property>();
        if (this.prototype == null) {
            return;
        }
        AssociationList properties = this.prototype.getProperties();
        for (Property property : properties) {
            this.prototypeProperties.put(property.getPropertyName().toUpperCase(), property);
        }
        PropertyGroup propertyGroup = this.prototype.getPrimaryPropertyGroup();
        if (propertyGroup != null) {
            this.loadPrototypePropertiesSubgroup(propertyGroup);
        }
    }

    private void loadPrototypePropertiesSubgroup(PropertyGroup group) throws RemoteException, MdException {
        AssociationList properties = group.getGroupedProperties();
        for (AbstractProperty abstractProperty : properties) {
            if (!(abstractProperty instanceof Property)) continue;
            Property property = (Property)abstractProperty;
            this.prototypeProperties.put(property.getPropertyName().toUpperCase(), property);
        }
        AssociationList subgroups = group.getSubpropertyGroups();
        for (PropertyGroup subgroup : subgroups) {
            this.loadPrototypePropertiesSubgroup(subgroup);
        }
    }

    protected final <M extends Root> M createMetadata(String name, Class<M> type) throws RemoteException {
        Root object = (Root)this.factory.createComplexMetadataObject(this.objectStore, name, type.getSimpleName(), this.repositoryId.substring(9));
        return (M)object;
    }

    protected final Property createProperty(String name, String propertyName, String delimiter, String value) throws RemoteException {
        Property property = this.createMetadata(name, Property.class);
        property.setDefaultValue(value);
        property.setDelimiter(delimiter);
        property.setPropertyName(propertyName);
        property.setSQLType(12);
        property.setAssociatedObject(this.built);
        return property;
    }

    protected final Property createPropertyFromPrototype(Property prototype, String value) throws RemoteException {
        Property property = this.createMetadata(prototype.getName(), Property.class);
        property.setDefaultValue(value);
        property.setDelimiter(prototype.getDelimiter());
        property.setIsExpert(prototype.getIsExpert());
        property.setIsLinked(prototype.getIsLinked());
        property.setIsRequired(prototype.getIsRequired());
        property.setIsUpdateable(prototype.getIsUpdateable());
        property.setIsVisible(prototype.getIsVisible());
        property.setPropertyName(prototype.getPropertyName());
        property.setPropertyRole(prototype.getPropertyRole());
        property.setSQLType(prototype.getSQLType());
        property.setUseValueOnly(prototype.getUseValueOnly());
        property.setAssociatedObject(this.built);
        return property;
    }

    protected final <M extends Root> M findMetadataByName(String name, Class<M> type) throws RemoteException, MdException {
        List objects = this.factory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.objectStore, this.repositoryId, type.getSimpleName(), 8584, "<XMLSelect search=\"*[@Name='" + StringEscapeUtils.escapeXml11((String)name) + "']\"/>");
        if (objects.isEmpty()) {
            return null;
        }
        return (M)((Root)objects.get(0));
    }

    protected final <M extends Root> M findMetadata(String search, Class<M> type) throws RemoteException, MdException {
        List objects = this.factory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.objectStore, this.repositoryId, type.getSimpleName(), 8584, "<XMLSelect search=\"" + search + "\"/>");
        if (objects.isEmpty()) {
            return null;
        }
        return (M)((Root)objects.get(0));
    }

    private class ExtensionDescriptor {
        String name;
        String value;
        String description;

        ExtensionDescriptor(String name, String value, String description) {
            this.name = name;
            this.value = value;
            this.description = description;
        }
    }
}

