/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.information.Filter;
import com.sas.services.util.XMLUtil;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class HttpServerFilter
extends Filter {
    private static final long serialVersionUID = 6397412930408191863L;
    private static final int TEMPLATE_BUFFER_INIT = 200;
    private static final int SELECT_BUFFER_INIT = 128;
    private String _domain;

    public HttpServerFilter() {
    }

    public HttpServerFilter(String key, int relation, String value) {
        super(key, relation, value);
        this.setType("HttpServer");
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    @Override
    public String getOMRType() {
        return "ServerComponent";
    }

    public String getLDAPType() {
        return "sas-httpserver";
    }

    @Override
    public String getXMLSelectString() {
        StringBuffer buffer = new StringBuffer(128);
        String name = this.getName();
        boolean join = false;
        buffer.append("<XMLSelect Search=\"*[");
        if (name != null) {
            buffer.append("@Name='" + XMLUtil.normalize(name) + '\'');
            join = true;
        }
        if (join) {
            buffer.append(" AND");
        }
        buffer.append(" @ClassIdentifier='DAC0D7F0-10DA-11D6-8816-AA0004006D06'");
        join = true;
        buffer.append("]\" />\n");
        if (this.getOMRTemplate() == null) {
            StringBuffer template = new StringBuffer(200);
            template.append("<Templates>\n");
            template.append("<ServerComponent Name=\"\">\n");
            template.append("  <PropertySets/>\n");
            template.append("  <Properties/>\n");
            template.append("  <SourceConnections/>\n");
            template.append("  <ProviderConnections/>\n");
            template.append("  <AssociatedMachine/>\n");
            template.append("</ServerComponent>\n");
            template.append("</Templates>");
            this.setOMRTemplate(template.toString());
        }
        return buffer.toString();
    }

    @Override
    public String getDAVBasicSearchString() {
        return "UNSUPPORTED";
    }

    @Override
    public String getDAVSQLString() {
        return "UNSUPPORTED";
    }
}

