/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;

@SASScope
class TrackingEntry {
    private String _entityKey;
    private RepositoryInterface _repos;
    private WeakReference _ref;
    private long _time;

    public TrackingEntry(MetadataInterface mi) {
        try {
            this._entityKey = mi.getReposKey();
            this._repos = mi.getRepository();
            this._ref = new WeakReference<MetadataInterface>(mi);
            this._time = System.currentTimeMillis();
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
    }

    public String getEntityKey() {
        return this._entityKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MetadataInterface getMetadata() {
        this._time = System.currentTimeMillis();
        if (this._ref != null && this._ref.get() != null) return (MetadataInterface)this._ref.get();
        try {
            MetadataInterface mi = this._repos.fetch(this._entityKey);
            this._ref = new WeakReference<MetadataInterface>(mi);
            return mi;
        }
        catch (ServiceException svcEx) {
            try {
                if (this._repos == null) return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return (MetadataInterface)this._ref.get();
    }

    public void setMetadata(MetadataInterface mi) {
        this._ref = new WeakReference<MetadataInterface>(mi);
    }

    public WeakReference getReference() {
        return this._ref;
    }

    public long getTime() {
        return this._time;
    }
}

