/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.entities.GUID;
import com.sas.services.MergePolicy;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.information.InformationServiceInitObject;
import com.sas.services.information.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;

public class RepositoryGroup
implements Cloneable,
ConsumedResourceInterface,
Serializable {
    static final String ELEMENT_NAME = "GroupDef";
    static final String ATTRIBUTE_UID = "uid";
    static final String ATTRIBUTE_NAME = "name";
    static final String ATTRIBUTE_DESCRIPTION = "description";
    static final String ELEMENT_NAME_MEMBER = "Member";
    private static final int HASHCODE_PRIME = 31;
    private static final long serialVersionUID = 6466428104987242439L;
    private static final int NAMELIST_INIT = 8;
    private String _uid = GUID.newGUID();
    private String _name;
    private String _description;
    private List<String> _groupNames = new ArrayList<String>(8);
    private boolean _writable = true;

    public RepositoryGroup() {
    }

    public RepositoryGroup(String name) {
        this();
        this._name = name;
    }

    public RepositoryGroup(String name, String description) {
        this(name);
        this.setDescription(description);
    }

    public RepositoryGroup(String name, List<String> group) {
        this(name);
        if (group != null) {
            for (String repositoryName : group) {
                this.addRepository(repositoryName);
            }
        }
    }

    public RepositoryGroup(String uid, String name, String description, List<String> group) {
        this(name, group);
        this.setDescription(description);
        if (uid != null && uid.length() > 0) {
            this._uid = uid;
        }
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    final boolean hasConflict(RepositoryGroup other) {
        boolean isEqual = false;
        if (this == other) {
            isEqual = true;
        } else if (other != null) {
            String otherDesc = other.getDescription();
            String otherName = other.getName();
            String thisDesc = this.getDescription();
            String thisName = this.getName();
            isEqual = !(otherName != null && !"".equals(otherName) && thisName != null && !Strings.equal((String)otherName, (String)thisName, (boolean)false, (boolean)false) || otherDesc != null && !"".equals(otherDesc) && thisDesc != null && !Strings.equal((String)otherDesc, (String)thisDesc, (boolean)false, (boolean)false));
        }
        return !isEqual;
    }

    void merge(RepositoryGroup newObject, InformationServiceInitObject serviceConfig, MergePolicy mergePolicy) {
        if (newObject != null) {
            String value = newObject.getDescription();
            if (value != null) {
                this.setDescription(value);
            }
            if ((value = newObject.getName()) != null) {
                this.setName(value);
            }
            this.mergeRepositoryGroupMembers(newObject, serviceConfig);
        }
    }

    void replace(RepositoryGroup newRepositoryGroup, InformationServiceInitObject serviceConfig, MergePolicy mergePolicy) {
        if (newRepositoryGroup != null) {
            this.setDescription(newRepositoryGroup.getDescription());
            this.setName(newRepositoryGroup.getName());
            this.mergeRepositoryGroupMembers(newRepositoryGroup, serviceConfig);
        }
    }

    private void mergeRepositoryGroupMembers(RepositoryGroup repositoryGroup, InformationServiceInitObject serviceConfig) {
        if (repositoryGroup != null && serviceConfig != null) {
            for (String repositoryDefName : repositoryGroup.getGroupNames()) {
                if (serviceConfig.getReposDef(repositoryDefName) != null) {
                    if (this._groupNames.contains(repositoryDefName)) continue;
                    this.addRepository(repositoryDefName);
                    continue;
                }
                LogManager.getLogger(InformationServiceInitObject.class).warn(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.undefinedReposDef.ex.fmt.txt", (Object)repositoryDefName));
            }
        }
    }

    @Override
    public String getResourceID() {
        return this._uid;
    }

    @Override
    public String getResourceValue() {
        return this._name;
    }

    @Override
    public String getLocalizedResourceType() {
        return RB.getStringResource("RepositoryGroup.resourceType.txt");
    }

    @Override
    public String getLocalizedResourceTypeAndValue() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTypeValue.repositoryGroup.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
    }

    @Override
    public String getResourceType() {
        return "RepositoryGroup";
    }

    @Override
    public int getResourceTypeCode() {
        return 4;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    public void addRepository(String name) {
        if (!this._writable) {
            throw new IllegalStateException();
        }
        if (!this._groupNames.contains(name)) {
            this._groupNames.add(name);
        }
    }

    public void removeRepository(String name) {
        if (!this._writable) {
            throw new IllegalStateException();
        }
        this._groupNames.remove(name);
    }

    public List<String> getGroupNames() {
        return new ArrayList<String>(this._groupNames);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (!this._writable) {
            throw new IllegalStateException();
        }
        this._name = name;
    }

    public void setProtected() {
        this._writable = false;
    }

    public RepositoryGroup copyTo(String name) {
        RepositoryGroup newGroup = new RepositoryGroup(name);
        for (String groupName : this._groupNames) {
            newGroup.addRepository(groupName);
        }
        return newGroup;
    }

    public String toString() {
        return this._name + " - " + this._description;
    }

    private boolean containsSameGroups(RepositoryGroup repositoryGroup) {
        boolean isEquivalent;
        List<String> reposGroupNames = repositoryGroup.getGroupNames();
        boolean bl = isEquivalent = this._groupNames.size() == reposGroupNames.size();
        if (isEquivalent) {
            for (String groupName : this._groupNames) {
                if (reposGroupNames.contains(groupName)) continue;
                isEquivalent = false;
                break;
            }
        }
        return isEquivalent;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RepositoryGroup clone = (RepositoryGroup)super.clone();
        clone._groupNames = new ArrayList<String>(this._groupNames);
        return clone;
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (this == o) {
            isEqual = true;
        } else if (o == null) {
            isEqual = false;
        } else {
            try {
                RepositoryGroup repositoryGroup = (RepositoryGroup)o;
                isEqual = Strings.equal((String)this.getName(), (String)repositoryGroup.getName(), (boolean)false, (boolean)false) && Strings.equal((String)this.getDescription(), (String)repositoryGroup.getDescription(), (boolean)false, (boolean)false) && this._writable == repositoryGroup._writable && this.containsSameGroups(repositoryGroup);
            }
            catch (ClassCastException e) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 5;
        int primeNumber = 31;
        hashCode = 31 * hashCode + Boolean.toString(this._writable).hashCode();
        hashCode = 31 * hashCode + (this._description == null ? 0 : this._description.hashCode());
        hashCode = 31 * hashCode + (this._name == null ? 0 : this._name.hashCode());
        hashCode = 31 * hashCode + (this._groupNames == null ? 0 : this._groupNames.hashCode());
        return hashCode;
    }
}

